/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ChannelPositionModifyRequest;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableChannelPositionModifyRequest
implements ChannelPositionModifyRequest {
    private final String id;
    private final Integer position_value;
    private final boolean position_absent;
    private final Boolean lockPermissions_value;
    private final boolean lockPermissions_absent;
    private final String parentId_value;
    private final boolean parentId_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableChannelPositionModifyRequest(String id, Possible<Optional<Integer>> position, Possible<Optional<Boolean>> lockPermissions, Possible<Optional<String>> parentId) {
        this.id = Objects.requireNonNull(id, "id");
        Possible<Optional<Integer>> position$impl = position;
        Possible<Optional<Boolean>> lockPermissions$impl = lockPermissions;
        Possible<Optional<String>> parentId$impl = parentId;
        this.position_value = Possible.flatOpt(position$impl).orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.lockPermissions_value = Possible.flatOpt(lockPermissions$impl).orElse(null);
        this.lockPermissions_absent = lockPermissions$impl.isAbsent();
        this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableChannelPositionModifyRequest(ImmutableChannelPositionModifyRequest original, String id, Possible<Optional<Integer>> position, Possible<Optional<Boolean>> lockPermissions, Possible<Optional<String>> parentId) {
        this.id = id;
        Possible<Optional<Integer>> position$impl = position;
        Possible<Optional<Boolean>> lockPermissions$impl = lockPermissions;
        Possible<Optional<String>> parentId$impl = parentId;
        this.position_value = Possible.flatOpt(position$impl).orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.lockPermissions_value = Possible.flatOpt(lockPermissions$impl).orElse(null);
        this.lockPermissions_absent = lockPermissions$impl.isAbsent();
        this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="position")
    public Possible<Optional<Integer>> position() {
        return this.position_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.position_value));
    }

    @Override
    @JsonProperty(value="lock_permissions")
    public Possible<Optional<Boolean>> lockPermissions() {
        return this.lockPermissions_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.lockPermissions_value));
    }

    @Override
    @JsonProperty(value="parent_id")
    public Possible<Optional<String>> parentId() {
        return this.parentId_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.parentId_value));
    }

    public final ImmutableChannelPositionModifyRequest withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableChannelPositionModifyRequest(this, newValue, this.position(), this.lockPermissions(), this.parentId());
    }

    public ImmutableChannelPositionModifyRequest withPosition(Possible<Optional<Integer>> value) {
        Possible<Optional<Integer>> newValue = Objects.requireNonNull(value);
        return new ImmutableChannelPositionModifyRequest(this, this.id, newValue, this.lockPermissions(), this.parentId());
    }

    @Deprecated
    public ImmutableChannelPositionModifyRequest withPosition(@Nullable Integer value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableChannelPositionModifyRequest(this, this.id, (Possible<Optional<Integer>>)newValue, this.lockPermissions(), this.parentId());
    }

    public ImmutableChannelPositionModifyRequest withPositionOrNull(@Nullable Integer value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableChannelPositionModifyRequest(this, this.id, (Possible<Optional<Integer>>)newValue, this.lockPermissions(), this.parentId());
    }

    public ImmutableChannelPositionModifyRequest withLockPermissions(Possible<Optional<Boolean>> value) {
        Possible<Optional<Boolean>> newValue = Objects.requireNonNull(value);
        return new ImmutableChannelPositionModifyRequest(this, this.id, this.position(), newValue, this.parentId());
    }

    @Deprecated
    public ImmutableChannelPositionModifyRequest withLockPermissions(@Nullable Boolean value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableChannelPositionModifyRequest(this, this.id, this.position(), (Possible<Optional<Boolean>>)newValue, this.parentId());
    }

    public ImmutableChannelPositionModifyRequest withLockPermissionsOrNull(@Nullable Boolean value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableChannelPositionModifyRequest(this, this.id, this.position(), (Possible<Optional<Boolean>>)newValue, this.parentId());
    }

    public ImmutableChannelPositionModifyRequest withParentId(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableChannelPositionModifyRequest(this, this.id, this.position(), this.lockPermissions(), newValue);
    }

    @Deprecated
    public ImmutableChannelPositionModifyRequest withParentId(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableChannelPositionModifyRequest(this, this.id, this.position(), this.lockPermissions(), (Possible<Optional<String>>)newValue);
    }

    public ImmutableChannelPositionModifyRequest withParentIdOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableChannelPositionModifyRequest(this, this.id, this.position(), this.lockPermissions(), (Possible<Optional<String>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelPositionModifyRequest && this.equalTo(0, (ImmutableChannelPositionModifyRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelPositionModifyRequest another) {
        return this.id.equals(another.id) && this.position().equals(another.position()) && this.lockPermissions().equals(another.lockPermissions()) && this.parentId().equals(another.parentId());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.position().hashCode();
        h += (h << 5) + this.lockPermissions().hashCode();
        h += (h << 5) + this.parentId().hashCode();
        return h;
    }

    public String toString() {
        return "ChannelPositionModifyRequest{id=" + this.id + ", position=" + this.position().toString() + ", lockPermissions=" + this.lockPermissions().toString() + ", parentId=" + this.parentId().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableChannelPositionModifyRequest fromJson(Json json) {
        Builder builder = ImmutableChannelPositionModifyRequest.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.position != null) {
            builder.position(json.position);
        }
        if (json.lockPermissions != null) {
            builder.lockPermissions(json.lockPermissions);
        }
        if (json.parentId != null) {
            builder.parentId(json.parentId);
        }
        return builder.build();
    }

    public static ImmutableChannelPositionModifyRequest of(String id, Possible<Optional<Integer>> position, Possible<Optional<Boolean>> lockPermissions, Possible<Optional<String>> parentId) {
        return new ImmutableChannelPositionModifyRequest(id, position, lockPermissions, parentId);
    }

    public static ImmutableChannelPositionModifyRequest copyOf(ChannelPositionModifyRequest instance) {
        if (instance instanceof ImmutableChannelPositionModifyRequest) {
            return (ImmutableChannelPositionModifyRequest)instance;
        }
        return ImmutableChannelPositionModifyRequest.builder().from(instance).build();
    }

    public boolean isPositionPresent() {
        return !this.position_absent;
    }

    public Integer positionOrElse(Integer defaultValue) {
        return !this.position_absent ? this.position_value : defaultValue;
    }

    public boolean isLockPermissionsPresent() {
        return !this.lockPermissions_absent;
    }

    public Boolean lockPermissionsOrElse(Boolean defaultValue) {
        return !this.lockPermissions_absent ? this.lockPermissions_value : defaultValue;
    }

    public boolean isParentIdPresent() {
        return !this.parentId_absent;
    }

    public String parentIdOrElse(String defaultValue) {
        return !this.parentId_absent ? this.parentId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        private Possible<Optional<Integer>> position_possible = Possible.absent();
        private Possible<Optional<Boolean>> lockPermissions_possible = Possible.absent();
        private Possible<Optional<String>> parentId_possible = Possible.absent();
        @Nullable
        private String id;

        private Builder() {
        }

        public final Builder from(ChannelPositionModifyRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.position(instance.position());
            this.lockPermissions(instance.lockPermissions());
            this.parentId(instance.parentId());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="position")
        public Builder position(Possible<Optional<Integer>> value) {
            this.position_possible = value;
            return this;
        }

        @Deprecated
        public Builder position(@Nullable Integer value) {
            this.position_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder positionOrNull(@Nullable Integer value) {
            this.position_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="lock_permissions")
        public Builder lockPermissions(Possible<Optional<Boolean>> value) {
            this.lockPermissions_possible = value;
            return this;
        }

        @Deprecated
        public Builder lockPermissions(@Nullable Boolean value) {
            this.lockPermissions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder lockPermissionsOrNull(@Nullable Boolean value) {
            this.lockPermissions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="parent_id")
        public Builder parentId(Possible<Optional<String>> value) {
            this.parentId_possible = value;
            return this;
        }

        @Deprecated
        public Builder parentId(@Nullable String value) {
            this.parentId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder parentIdOrNull(@Nullable String value) {
            this.parentId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public ImmutableChannelPositionModifyRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelPositionModifyRequest(null, this.id, this.position_build(), this.lockPermissions_build(), this.parentId_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build ChannelPositionModifyRequest, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<Integer>> position_build() {
            return this.position_possible;
        }

        private Possible<Optional<Boolean>> lockPermissions_build() {
            return this.lockPermissions_possible;
        }

        private Possible<Optional<String>> parentId_build() {
            return this.parentId_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ChannelPositionModifyRequest {
        @Nullable
        String id;
        Possible<Optional<Integer>> position = Possible.absent();
        Possible<Optional<Boolean>> lockPermissions = Possible.absent();
        Possible<Optional<String>> parentId = Possible.absent();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="position")
        public void setPosition(Possible<Optional<Integer>> position) {
            this.position = position;
        }

        @JsonProperty(value="lock_permissions")
        public void setLockPermissions(Possible<Optional<Boolean>> lockPermissions) {
            this.lockPermissions = lockPermissions;
        }

        @JsonProperty(value="parent_id")
        public void setParentId(Possible<Optional<String>> parentId) {
            this.parentId = parentId;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<Integer>> position() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<Boolean>> lockPermissions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> parentId() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ChannelPositionModifyRequest, attribute initializers form cycle " + attributes;
        }
    }
}

