/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.BulkBanRequest;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ImmutableBulkBanRequest
implements BulkBanRequest {
    private final long[] userIds_value;
    private final Integer deleteMessageSeconds_value;
    private final boolean deleteMessageSeconds_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBulkBanRequest(List<Id> userIds, Possible<Integer> deleteMessageSeconds) {
        List<Id> userIds$impl = userIds;
        Possible<Integer> deleteMessageSeconds$impl = deleteMessageSeconds;
        this.userIds_value = userIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.deleteMessageSeconds_value = deleteMessageSeconds$impl.toOptional().orElse(null);
        this.deleteMessageSeconds_absent = deleteMessageSeconds$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableBulkBanRequest(ImmutableBulkBanRequest original, List<Id> userIds, Possible<Integer> deleteMessageSeconds) {
        List<Id> userIds$impl = userIds;
        Possible<Integer> deleteMessageSeconds$impl = deleteMessageSeconds;
        this.userIds_value = userIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.deleteMessageSeconds_value = deleteMessageSeconds$impl.toOptional().orElse(null);
        this.deleteMessageSeconds_absent = deleteMessageSeconds$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="user_ids")
    public List<Id> userIds() {
        return LongStream.of(this.userIds_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="delete_message_seconds")
    public Possible<Integer> deleteMessageSeconds() {
        return this.deleteMessageSeconds_absent ? Possible.absent() : Possible.of((Object)this.deleteMessageSeconds_value);
    }

    public ImmutableBulkBanRequest withUserIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableBulkBanRequest(this, newValue, this.deleteMessageSeconds());
    }

    public ImmutableBulkBanRequest withDeleteMessageSeconds(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new ImmutableBulkBanRequest(this, this.userIds(), newValue);
    }

    public ImmutableBulkBanRequest withDeleteMessageSeconds(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableBulkBanRequest(this, this.userIds(), (Possible<Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBulkBanRequest && this.equalTo(0, (ImmutableBulkBanRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableBulkBanRequest another) {
        return Objects.equals(this.userIds_value, another.userIds_value) && this.deleteMessageSeconds().equals(another.deleteMessageSeconds());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.userIds_value);
        h += (h << 5) + this.deleteMessageSeconds().hashCode();
        return h;
    }

    public String toString() {
        return "BulkBanRequest{userIds=" + Objects.toString(this.userIds_value) + ", deleteMessageSeconds=" + this.deleteMessageSeconds().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBulkBanRequest fromJson(Json json) {
        Builder builder = ImmutableBulkBanRequest.builder();
        if (json.userIds != null) {
            builder.userIds(json.userIds);
        }
        if (json.deleteMessageSeconds != null) {
            builder.deleteMessageSeconds(json.deleteMessageSeconds);
        }
        return builder.build();
    }

    public static ImmutableBulkBanRequest of(List<Id> userIds, Possible<Integer> deleteMessageSeconds) {
        return new ImmutableBulkBanRequest(userIds, deleteMessageSeconds);
    }

    public static ImmutableBulkBanRequest copyOf(BulkBanRequest instance) {
        if (instance instanceof ImmutableBulkBanRequest) {
            return (ImmutableBulkBanRequest)instance;
        }
        return ImmutableBulkBanRequest.builder().from(instance).build();
    }

    public boolean isDeleteMessageSecondsPresent() {
        return !this.deleteMessageSeconds_absent;
    }

    public Integer deleteMessageSecondsOrElse(Integer defaultValue) {
        return !this.deleteMessageSeconds_absent ? this.deleteMessageSeconds_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Long> userIds_list = null;
        private Possible<Integer> deleteMessageSeconds_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(BulkBanRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.userIds(instance.userIds());
            this.deleteMessageSeconds(instance.deleteMessageSeconds());
            return this;
        }

        public Builder addUserId(long element) {
            this.userIds_getOrCreate().add(element);
            return this;
        }

        public Builder addUserId(String element) {
            this.userIds_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addUserId(Id element) {
            this.userIds_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllUserIds(List<Long> elements) {
            this.userIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="user_ids")
        public Builder userIds(List<Id> elements) {
            this.userIds_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder userIds(Iterable<Id> elements) {
            this.userIds_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="delete_message_seconds")
        public Builder deleteMessageSeconds(Possible<Integer> value) {
            this.deleteMessageSeconds_possible = value;
            return this;
        }

        public Builder deleteMessageSeconds(Integer value) {
            this.deleteMessageSeconds_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableBulkBanRequest build() {
            return new ImmutableBulkBanRequest(null, this.userIds_build(), this.deleteMessageSeconds_build());
        }

        private List<Id> userIds_build() {
            return this.userIds_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> userIds_getOrCreate() {
            if (this.userIds_list == null) {
                this.userIds_list = new ArrayList<Long>();
            }
            return this.userIds_list;
        }

        private Possible<Integer> deleteMessageSeconds_build() {
            return this.deleteMessageSeconds_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements BulkBanRequest {
        @Nullable
        List<Id> userIds;
        Possible<Integer> deleteMessageSeconds = Possible.absent();

        Json() {
        }

        @JsonProperty(value="user_ids")
        public void setUserIds(List<Id> userIds) {
            this.userIds = userIds;
        }

        @JsonProperty(value="delete_message_seconds")
        public void setDeleteMessageSeconds(Possible<Integer> deleteMessageSeconds) {
            this.deleteMessageSeconds = deleteMessageSeconds;
        }

        @Override
        public List<Id> userIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Integer> deleteMessageSeconds() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build BulkBanRequest, attribute initializers form cycle " + attributes;
        }
    }
}

