/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.BaseOnboardingData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ImmutableBaseOnboardingData
implements BaseOnboardingData {
    private final long[] defaultChannelIds_value;
    private final boolean enabled;
    private final int mode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseOnboardingData(List<Id> defaultChannelIds, boolean enabled, int mode) {
        List<Id> defaultChannelIds$impl = defaultChannelIds;
        this.enabled = enabled;
        this.mode = mode;
        this.defaultChannelIds_value = defaultChannelIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    private ImmutableBaseOnboardingData(ImmutableBaseOnboardingData original, List<Id> defaultChannelIds, boolean enabled, int mode) {
        List<Id> defaultChannelIds$impl = defaultChannelIds;
        this.enabled = enabled;
        this.mode = mode;
        this.defaultChannelIds_value = defaultChannelIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="default_channel_ids")
    public List<Id> defaultChannelIds() {
        return LongStream.of(this.defaultChannelIds_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="mode")
    public int mode() {
        return this.mode;
    }

    public ImmutableBaseOnboardingData withDefaultChannelIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableBaseOnboardingData(this, newValue, this.enabled, this.mode);
    }

    public final ImmutableBaseOnboardingData withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableBaseOnboardingData(this, this.defaultChannelIds(), value, this.mode);
    }

    public final ImmutableBaseOnboardingData withMode(int value) {
        if (this.mode == value) {
            return this;
        }
        return new ImmutableBaseOnboardingData(this, this.defaultChannelIds(), this.enabled, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseOnboardingData && this.equalTo(0, (ImmutableBaseOnboardingData)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseOnboardingData another) {
        return Objects.equals(this.defaultChannelIds_value, another.defaultChannelIds_value) && this.enabled == another.enabled && this.mode == another.mode;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.defaultChannelIds_value);
        h += (h << 5) + Boolean.hashCode(this.enabled);
        h += (h << 5) + this.mode;
        return h;
    }

    public String toString() {
        return "BaseOnboardingData{defaultChannelIds=" + Objects.toString(this.defaultChannelIds_value) + ", enabled=" + this.enabled + ", mode=" + this.mode + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBaseOnboardingData fromJson(Json json) {
        Builder builder = ImmutableBaseOnboardingData.builder();
        if (json.defaultChannelIds != null) {
            builder.defaultChannelIds(json.defaultChannelIds);
        }
        if (json.enabledIsSet) {
            builder.enabled(json.enabled);
        }
        if (json.modeIsSet) {
            builder.mode(json.mode);
        }
        return builder.build();
    }

    public static ImmutableBaseOnboardingData of(List<Id> defaultChannelIds, boolean enabled, int mode) {
        return new ImmutableBaseOnboardingData(defaultChannelIds, enabled, mode);
    }

    public static ImmutableBaseOnboardingData copyOf(BaseOnboardingData instance) {
        if (instance instanceof ImmutableBaseOnboardingData) {
            return (ImmutableBaseOnboardingData)instance;
        }
        return ImmutableBaseOnboardingData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ENABLED = 1L;
        private static final long INIT_BIT_MODE = 2L;
        private long initBits = 3L;
        private List<Long> defaultChannelIds_list = null;
        private boolean enabled;
        private int mode;

        private Builder() {
        }

        public final Builder from(BaseOnboardingData instance) {
            Objects.requireNonNull(instance, "instance");
            this.defaultChannelIds(instance.defaultChannelIds());
            this.enabled(instance.enabled());
            this.mode(instance.mode());
            return this;
        }

        public Builder addDefaultChannelId(long element) {
            this.defaultChannelIds_getOrCreate().add(element);
            return this;
        }

        public Builder addDefaultChannelId(String element) {
            this.defaultChannelIds_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addDefaultChannelId(Id element) {
            this.defaultChannelIds_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllDefaultChannelIds(List<Long> elements) {
            this.defaultChannelIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="default_channel_ids")
        public Builder defaultChannelIds(List<Id> elements) {
            this.defaultChannelIds_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder defaultChannelIds(Iterable<Id> elements) {
            this.defaultChannelIds_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="enabled")
        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="mode")
        public final Builder mode(int mode) {
            this.mode = mode;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseOnboardingData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseOnboardingData(null, this.defaultChannelIds_build(), this.enabled, this.mode);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("enabled");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mode");
            }
            return "Cannot build BaseOnboardingData, some of required attributes are not set " + attributes;
        }

        private List<Id> defaultChannelIds_build() {
            return this.defaultChannelIds_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> defaultChannelIds_getOrCreate() {
            if (this.defaultChannelIds_list == null) {
                this.defaultChannelIds_list = new ArrayList<Long>();
            }
            return this.defaultChannelIds_list;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements BaseOnboardingData {
        @Nullable
        List<Id> defaultChannelIds;
        boolean enabled;
        boolean enabledIsSet;
        int mode;
        boolean modeIsSet;

        Json() {
        }

        @JsonProperty(value="default_channel_ids")
        public void setDefaultChannelIds(List<Id> defaultChannelIds) {
            this.defaultChannelIds = defaultChannelIds;
        }

        @JsonProperty(value="enabled")
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledIsSet = true;
        }

        @JsonProperty(value="mode")
        public void setMode(int mode) {
            this.mode = mode;
            this.modeIsSet = true;
        }

        @Override
        public List<Id> defaultChannelIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean enabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int mode() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build BaseOnboardingData, attribute initializers form cycle " + attributes;
        }
    }
}

