/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.service;

import discord4j.discordjson.json.SendSoundboardSoundRequest;
import discord4j.discordjson.json.SoundboardSoundCreateRequest;
import discord4j.discordjson.json.SoundboardSoundData;
import discord4j.discordjson.json.SoundboardSoundDataList;
import discord4j.discordjson.json.SoundboardSoundModifyRequest;
import discord4j.rest.request.Router;
import discord4j.rest.route.Routes;
import discord4j.rest.service.RestService;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class SoundboardService
extends RestService {
    public SoundboardService(Router router) {
        super(router);
    }

    public Mono<Void> sendSoundboardSound(long channelId, SendSoundboardSoundRequest request) {
        return Routes.SEND_SOUNDBOARD_SOUND.newRequest(channelId).body(request).exchange(this.getRouter()).skipBody();
    }

    public Flux<SoundboardSoundData> getDefaultSoundboardSounds() {
        return Routes.LIST_DEFAULT_SOUNDBOARD_SOUNDS.newRequest(new Object[0]).exchange(this.getRouter()).bodyToMono(SoundboardSoundData[].class).flatMapMany(Flux::fromArray);
    }

    public Flux<SoundboardSoundData> getGuildSoundboardSounds(long guildId) {
        return Routes.LIST_GUILD_SOUNDBOARD_SOUNDS.newRequest(guildId).exchange(this.getRouter()).bodyToMono(SoundboardSoundDataList.class).map(SoundboardSoundDataList::items).flatMapMany(Flux::fromIterable);
    }

    public Mono<SoundboardSoundData> getGuildSoundboardSound(long guildId, long soundBoardId) {
        return Routes.GET_GUILD_SOUNDBOARD_SOUND.newRequest(guildId, soundBoardId).exchange(this.getRouter()).bodyToMono(SoundboardSoundData.class);
    }

    public Mono<SoundboardSoundData> createGuildSoundboardSound(long guildId, SoundboardSoundCreateRequest request, @Nullable String reason) {
        return Routes.CREATE_GUILD_SOUNDBOARD_SOUND.newRequest(guildId).body(request).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(SoundboardSoundData.class);
    }

    public Mono<SoundboardSoundData> modifyGuildSoundboardSound(long guildId, long soundBoardId, SoundboardSoundModifyRequest request, @Nullable String reason) {
        return Routes.MODIFY_GUILD_SOUNDBOARD_SOUND.newRequest(guildId, soundBoardId).body(request).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(SoundboardSoundData.class);
    }

    public Mono<Void> deleteGuildSoundboardSound(long guildId, long soundBoardId, @Nullable String reason) {
        return Routes.DELETE_GUILD_SOUNDBOARD_SOUND.newRequest(guildId, soundBoardId).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter()).bodyToMono(Void.class);
    }
}

