/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.service;

import discord4j.common.annotations.Experimental;
import discord4j.discordjson.json.CreateTestEntitlementRequest;
import discord4j.discordjson.json.EntitlementData;
import discord4j.discordjson.json.SkuData;
import discord4j.discordjson.json.SubscriptionData;
import discord4j.rest.request.Router;
import discord4j.rest.route.Routes;
import discord4j.rest.service.RestService;
import discord4j.rest.util.Multimap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Experimental
public class MonetizationService
extends RestService {
    public MonetizationService(Router router) {
        super(router);
    }

    public Flux<SkuData> getAllSkus(long applicationId) {
        return Routes.LIST_SKUS.newRequest(applicationId).exchange(this.getRouter()).bodyToMono(SkuData[].class).flatMapMany(Flux::fromArray);
    }

    public Flux<EntitlementData> getAllEntitlements(long applicationId) {
        return this.getAllEntitlements(applicationId, new Multimap<String, Object>());
    }

    public Flux<EntitlementData> getAllEntitlements(long applicationId, Multimap<String, Object> params) {
        return Routes.LIST_ENTITLEMENTS.newRequest(applicationId).query(params).exchange(this.getRouter()).bodyToMono(EntitlementData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<EntitlementData> createTestEntitlement(long applicationId, CreateTestEntitlementRequest request) {
        return Routes.CREATE_TEST_ENTITLEMENT.newRequest(applicationId).body(request).exchange(this.getRouter()).bodyToMono(EntitlementData.class);
    }

    public Mono<Void> deleteTestEntitlement(long applicationId, long entitlementId) {
        return Routes.DELETE_TEST_ENTITLEMENT.newRequest(applicationId, entitlementId).exchange(this.getRouter()).skipBody();
    }

    public Mono<Void> consumeEntitlement(long applicationId, long entitlementId) {
        return Routes.CONSUME_ENTITLEMENT.newRequest(applicationId, entitlementId).exchange(this.getRouter()).skipBody();
    }

    public Flux<SubscriptionData> getSkuSubscriptions(long skuId, Multimap<String, Object> params) {
        return Routes.LIST_SKU_SUBSCRIPTIONS.newRequest(skuId).query(params).exchange(this.getRouter()).bodyToMono(SubscriptionData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<SubscriptionData> getSkuSubscription(long skuId, long subscriptionId) {
        return Routes.GET_SKU_SUBSCRIPTION.newRequest(skuId, subscriptionId).exchange(this.getRouter()).bodyToMono(SubscriptionData.class);
    }
}

