/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.common.sinks.EmissionStrategy;
import discord4j.rest.request.RequestQueue;
import discord4j.rest.request.RequestQueueFactory;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;
import reactor.util.Logger;
import reactor.util.Loggers;

class SinksRequestQueueFactory
implements RequestQueueFactory {
    private static final Logger log = Loggers.getLogger(SinksRequestQueueFactory.class);
    private final Function<Sinks.ManySpec, Sinks.Many<Object>> requestSinkFactory;
    private final EmissionStrategy emissionStrategy;

    SinksRequestQueueFactory(Function<Sinks.ManySpec, Sinks.Many<Object>> requestSinkFactory, EmissionStrategy emissionStrategy) {
        this.requestSinkFactory = requestSinkFactory;
        this.emissionStrategy = emissionStrategy;
    }

    @Override
    public <T> RequestQueue<T> create() {
        return new RequestQueue<T>(){
            private final Sinks.Many<Object> sink;
            {
                this.sink = (Sinks.Many)SinksRequestQueueFactory.this.requestSinkFactory.apply(Sinks.many());
            }

            @Override
            public boolean push(T request) {
                return SinksRequestQueueFactory.this.emissionStrategy.emitNext(this.sink, request);
            }

            @Override
            public Flux<T> requests() {
                return this.sink.asFlux();
            }
        };
    }
}

