/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.diagnostics.widgets.logging.model;

import com.inet.annotations.JsonData;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

@JsonData
public class FilterOptions {
    private static final ArrayList<String> DATE_FILTER_LIST = new ArrayList<String>(Arrays.asList(a.ap.name(), a.aq.name(), a.ar.name(), a.as.name(), a.at.name()));
    private ArrayList<SourceLevelCombi> filterSourceLevelCombis = new ArrayList();
    private ArrayList<String> filterSources = new ArrayList();
    private ArrayList<String> filterLevels = new ArrayList();
    private ArrayList<String> filterThreads = new ArrayList();
    private ArrayList<String> filterDate = DATE_FILTER_LIST;

    public ArrayList<String> getFilterSources() {
        return this.filterSources;
    }

    public ArrayList<String> getFilterLevels() {
        return this.filterLevels;
    }

    public ArrayList<SourceLevelCombi> getFilterSourceLevelCombis() {
        return this.filterSourceLevelCombis;
    }

    public ArrayList<String> getFilterThreads() {
        return this.filterThreads;
    }

    public void setFilterThreads(ArrayList<String> filterThreads) {
        this.filterThreads = filterThreads;
    }

    public ArrayList<String> getFilterDate() {
        return this.filterDate;
    }

    public static enum a {
        ap(3600L),
        aq(21600L),
        ar(86400L),
        as(172800L),
        at(604800L);

        private final long dateDifference;

        private a(long l) {
            this.dateDifference = l;
        }

        public boolean a(Date date) {
            Date date2 = Date.from(Instant.now().minusSeconds(this.dateDifference));
            return date.after(date2);
        }
    }

    @JsonData
    public static class SourceLevelCombi
    implements Comparable<SourceLevelCombi> {
        private String level;
        private String source;

        public SourceLevelCombi(String level, String source) {
            if (level == null || source == null) {
                throw new NullPointerException();
            }
            this.level = level;
            this.source = source;
        }

        @Override
        public int compareTo(SourceLevelCombi o) {
            if (o.source.equals(this.source)) {
                return this.level.compareTo(o.level);
            }
            return this.source.compareTo(o.source);
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.level == null ? 0 : this.level.hashCode());
            n2 = 31 * n2 + (this.source == null ? 0 : this.source.hashCode());
            return n2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceLevelCombi sourceLevelCombi = (SourceLevelCombi)obj;
            if (!this.level.equals(sourceLevelCombi.level)) {
                return false;
            }
            return this.source.equals(sourceLevelCombi.source);
        }
    }
}

