/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.diagnostics.widgets.dump;

import com.inet.authentication.LoginRoles;
import com.inet.authentication.base.LoginManager;
import com.inet.authentication.stayloggedin.StayLoggedInSession;
import com.inet.http.ExpandableHttpSessionListener;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.http.websocket.WebsocketConnection;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.diagnostics.DiagnosticsPlugin;
import com.inet.shared.diagnostics.shared.DumpWidgetExtension;
import com.inet.shared.diagnostics.widgets.dump.SessionDump;
import com.inet.shared.servlet.ServletUtils;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class f
implements DumpWidgetExtension {
    @Override
    public String getKey() {
        return "sessiondump";
    }

    @Override
    public String getTitle() {
        return DiagnosticsPlugin.MSG.getMsg("sessiondump.title", new Object[0]);
    }

    @Override
    public String getDescription() {
        return DiagnosticsPlugin.MSG.getMsg("sessiondump.desc", new Object[0]);
    }

    @Override
    public String getButtonLabel() {
        return DiagnosticsPlugin.MSG.getMsg("sessiondump.button", new Object[0]);
    }

    @Override
    public void generateDump() throws IOException {
    }

    @Override
    public void includeDump(HttpServletResponse response) throws IOException {
        Object object;
        Object object22;
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/plain; charset=utf-8");
        ServletUtils.setContentDisposition((HttpServletResponse)response, (String)"sessiondump.txt", (boolean)false);
        response.setStatus(200);
        long l = System.currentTimeMillis();
        ArrayList arrayList = new ArrayList(WebSocketEventHandler.getInstance().getAllConnections());
        ArrayList arrayList2 = new ArrayList(ExpandableHttpSessionListener.getActiveSessions());
        HashMap<String, ArrayList> hashMap = new HashMap<String, ArrayList>();
        for (Object object3 : arrayList) {
            object22 = object3.getActiveHttpSession();
            if (object22 == null) continue;
            object = hashMap.computeIfAbsent(object22.getId(), string -> new ArrayList());
            ((ArrayList)object).add(object3);
        }
        try (UTF8StreamWriter uTF8StreamWriter = new UTF8StreamWriter((OutputStream)response.getOutputStream());){
            Object object4;
            Object object3;
            uTF8StreamWriter.append((CharSequence)"Session Dump - ").append(new Timestamp(l).toString());
            uTF8StreamWriter.append((CharSequence)"\n\tSockets: ").append(String.valueOf(arrayList.size()));
            uTF8StreamWriter.append((CharSequence)"\n\tSessions: ").append(String.valueOf(arrayList2.size()));
            uTF8StreamWriter.append('\n');
            for (Object object22 : arrayList2) {
                try {
                    ArrayList arrayList3;
                    uTF8StreamWriter.append('\n').append(object22.getId());
                    object = LoginManager.getLoginProcessor((HttpSession)object22);
                    if (object != null) {
                        object4 = object.getUserAccountID();
                        uTF8StreamWriter.append((CharSequence)"\n\tsource = ").append(object.getLoginSource()).append("\n\tlogin = ").append(object.getLoginID()).append("\n\taccount = ").append(String.valueOf(object4));
                        if (object4 != null && (arrayList3 = UserManager.getInstance().getUserAccount(object4)) != null) {
                            uTF8StreamWriter.append((CharSequence)"\n\tname = ").append(arrayList3.getDisplayName());
                        }
                        if (object instanceof LoginRoles) {
                            uTF8StreamWriter.append((CharSequence)"\n\troles = ").append(((LoginRoles)object).getRoles().toString());
                        }
                    }
                    if ((object4 = (StayLoggedInSession)object22.getAttribute(StayLoggedInSession.class.getName())) != null) {
                        f.a("Stay logged in provider", object4.getProvider(), uTF8StreamWriter);
                        f.a("Stay logged in last use", new Timestamp(object4.getLastUse()), uTF8StreamWriter);
                    }
                    if ((arrayList3 = (ArrayList)hashMap.get(object22.getId())) != null) {
                        for (WebsocketConnection websocketConnection : arrayList3) {
                            f.a("Polling ID", websocketConnection.getPollingID(), uTF8StreamWriter);
                        }
                    }
                    f.a("user-agent", (HttpSession)object22, uTF8StreamWriter);
                    f.a("RemoteAddr", (HttpSession)object22, uTF8StreamWriter);
                    f.a(Locale.class.getName(), (HttpSession)object22, uTF8StreamWriter);
                    Object object5 = object22.getAttribute(TimeZone.class.getName());
                    if (object5 instanceof TimeZone) {
                        f.a(TimeZone.class.getName(), ((TimeZone)object5).getID(), uTF8StreamWriter);
                    }
                    f.a("creation time", l - object22.getCreationTime() + " ms", uTF8StreamWriter);
                    f.a("access time", l - object22.getLastAccessedTime() + " ms", uTF8StreamWriter);
                    f.a("creation time", new Timestamp(object22.getCreationTime()), uTF8StreamWriter);
                    f.a("access time", new Timestamp(object22.getLastAccessedTime()), uTF8StreamWriter);
                }
                catch (IllegalStateException illegalStateException) {}
            }
            uTF8StreamWriter.append('\n');
            for (Object object22 : arrayList) {
                object = object22.getSession();
                if (object != null) {
                    uTF8StreamWriter.append((CharSequence)"\nws:").append(object.getId());
                    object4 = object.getQueryString();
                    f.a("URL", String.valueOf(object.getRequestURI()) + (String)(object4 != null ? "?" + (String)object4 : ""), uTF8StreamWriter);
                } else {
                    uTF8StreamWriter.append((CharSequence)"\npoll");
                }
                object4 = object22.getActiveHttpSession();
                f.a("Http Session", object4 != null ? object4.getId() : "-", uTF8StreamWriter);
                f.a("Polling ID", object22.getPollingID(), uTF8StreamWriter);
            }
            object3 = ServerPluginManager.getInstance().get(SessionDump.class);
            object22 = object3.iterator();
            while (object22.hasNext()) {
                object = (SessionDump)object22.next();
                object.dump((Writer)uTF8StreamWriter);
            }
        }
    }

    private static void a(@Nonnull String string, @Nonnull HttpSession httpSession, @Nonnull UTF8StreamWriter uTF8StreamWriter) throws IOException {
        Object object = httpSession.getAttribute(string);
        if (object != null) {
            uTF8StreamWriter.append((CharSequence)"\n\t").append(string).append(" = ").append(object.toString());
        }
    }

    private static void a(@Nonnull String string, @Nullable Object object, @Nonnull UTF8StreamWriter uTF8StreamWriter) throws IOException {
        if (object != null) {
            uTF8StreamWriter.append((CharSequence)"\n\t").append(string).append(" = ").append(object.toString());
        }
    }
}

