/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.diagnostics.widgets.benchmark.datasource;

import com.inet.lib.list.IntList;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.remote.gui.shared.model.StringWrapped;
import com.inet.report.ReportException;
import com.inet.report.diagnostics.CRDiagnosticsPlugin;
import com.inet.report.diagnostics.widgets.benchmark.datasource.server.c;
import com.inet.shared.diagnostics.shared.DiagnosticsUtils;
import com.inet.shared.diagnostics.widgets.benchmark.model.ArrayMeasurement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class b
extends ServiceMethod<StringWrapped, ArrayMeasurement> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayMeasurement a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, StringWrapped stringWrapped) throws IOException {
        String string = stringWrapped.getData();
        if (string == null || string.isEmpty()) {
            return new ArrayMeasurement(new int[]{-1}, CRDiagnosticsPlugin.MSG.getMsg("benchmark.no_datasource_available", new Object[0]));
        }
        Connection connection = null;
        try {
            connection = c.c(string);
            if (connection == null) {
                ArrayMeasurement arrayMeasurement = new ArrayMeasurement(new int[]{-1}, CRDiagnosticsPlugin.MSG.getMsg("benchmark.no_conn_for_not_jdbc_data", new Object[0]));
                return arrayMeasurement;
            }
            ArrayMeasurement arrayMeasurement = this.a(connection);
            return arrayMeasurement;
        }
        catch (ReportException reportException) {
            DiagnosticsUtils.LOGGER.error((Throwable)reportException);
            ArrayMeasurement arrayMeasurement = new ArrayMeasurement(new int[]{-1}, CRDiagnosticsPlugin.MSG.getMsg("benchmark.no_conn_created", new Object[0]) + reportException.getMessage());
            return arrayMeasurement;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    DiagnosticsUtils.LOGGER.error((Throwable)sQLException);
                }
            }
        }
    }

    private ArrayMeasurement a(Connection connection) {
        int n = 1024;
        byte[] byArray = new byte[n * 1024];
        IntList intList = new IntList();
        long l = System.currentTimeMillis();
        Throwable throwable = null;
        for (int i = 0; i < 40; ++i) {
            try {
                int n2;
                long l2 = System.currentTimeMillis();
                long l3 = 0L;
                do {
                    this.a(connection, byArray);
                    ++l3;
                } while ((n2 = (int)(System.currentTimeMillis() - l2)) == 0);
                int n3 = (int)(l3 * (long)n * 1024L * 8L * 2L / (long)n2);
                if (n3 < 0) {
                    n3 = Integer.MAX_VALUE;
                }
                intList.addElement(n3);
            }
            catch (Throwable throwable2) {
                if (throwable2.getMessage().contains("Packet for query is too large")) {
                    DiagnosticsUtils.LOGGER.warn((Object)String.format("Now using half of the current load (%d KBytes), because faced error: %s", n, throwable2.getMessage()));
                    byArray = new byte[(n /= 2) * 1024];
                    continue;
                }
                DiagnosticsUtils.LOGGER.error(throwable2);
                throwable = throwable2;
                break;
            }
            if (System.currentTimeMillis() - l >= 10000L) break;
        }
        Object object = "";
        if (throwable != null) {
            if (intList.isEmpty()) {
                return new ArrayMeasurement(new int[]{-1}, CRDiagnosticsPlugin.MSG.getMsg("benchmark.no_data_collected_for_selected_source", new Object[0]) + throwable.getMessage());
            }
            object = CRDiagnosticsPlugin.MSG.getMsg("benchmark.collected_data_but_was_error", new Object[0]) + throwable.getMessage();
        }
        return new ArrayMeasurement(intList.toArray(), (String)object);
    }

    private void a(Connection connection, byte[] byArray) throws SQLException {
        String string = connection.getMetaData().getDatabaseProductName().toLowerCase();
        boolean bl = string.contains("oracle");
        try (PreparedStatement preparedStatement = connection.prepareStatement(bl ? "SELECT ? FROM dual" : "SELECT ?");){
            if (bl) {
                preparedStatement.setBlob(1, new ByteArrayInputStream(byArray), byArray.length);
            } else {
                preparedStatement.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                resultSet.next();
                resultSet.getObject(1);
            }
        }
    }

    public String getMethodName() {
        return "dataSource";
    }

    public short getMethodType() {
        return 1;
    }

    public /* synthetic */ Object invoke(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (StringWrapped)object);
    }
}

