/*
 * Decompiled with CFR 0.152.
 */
package de.anormalmedia.sbstutorial.gui.recorder;

import de.anormalmedia.sbstutorial.gui.ComponentFinder;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class XMLPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextArea ta;
    private File currentfile = null;
    private JLabel lblFile;
    private JButton btnew;
    private JButton btopen;
    private JButton btsave;
    private JButton btsaveas;

    public XMLPanel() {
        super(new BorderLayout());
        this.getInputMap(1).put(KeyStroke.getKeyStroke(83, 2), "save");
        this.getActionMap().put("save", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                XMLPanel.this.saveCurrentFile();
            }
        });
        this.ta = new JTextArea();
        this.add((Component)new JScrollPane(this.ta), "Center");
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        this.add((Component)tb, "North");
        this.btnew = new JButton("new");
        tb.add(this.btnew);
        this.btnew.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                XMLPanel.this.ta.setText("");
                XMLPanel.this.ta.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                XMLPanel.this.ta.append("\n<SBSTutorial>");
                XMLPanel.this.ta.append("\n\t<languageresource file=\"LanguageResources\" />");
                XMLPanel.this.ta.append("\n\t<!-- <externallanguageresource file=\"LanguageResources\" /> -->");
                XMLPanel.this.ta.append("\n\t<flashcolor r=\"255\" g=\"0\" b=\"0\" a=\"128\" />");
                XMLPanel.this.ta.append("\n\t<location vertical=\"bottom\" horizontal=\"right\" />");
                XMLPanel.this.ta.append("\n\t<size width=\"400\" height=\"300\" />");
                XMLPanel.this.ta.append("\n\t<title>new tutorial</title>");
                XMLPanel.this.ta.append("\n\t<intro>");
                XMLPanel.this.ta.append("\n\t\t<description>");
                XMLPanel.this.ta.append("\n\t\t</description>");
                XMLPanel.this.ta.append("\n\t</intro>");
                XMLPanel.this.ta.append("\n\t<step>");
                XMLPanel.this.ta.append("\n\t\t<description>");
                XMLPanel.this.ta.append("\n\t\t</description>");
                XMLPanel.this.ta.append("\n\t\t<!-- <ignorestep /> -->");
                XMLPanel.this.ta.append("\n\t\t<!-- <restartstep /> -->");
                XMLPanel.this.ta.append("\n\t</step>");
                XMLPanel.this.ta.append("\n\t<conclusion>");
                XMLPanel.this.ta.append("\n\t\t<description>");
                XMLPanel.this.ta.append("\n\t\t</description>");
                XMLPanel.this.ta.append("\n\t</conclusion>");
                XMLPanel.this.ta.append("\n</SBSTutorial>");
                XMLPanel.this.btsave.setEnabled(false);
                XMLPanel.this.lblFile.setText("<new file>");
            }
        });
        this.btopen = new JButton("open");
        tb.add(this.btopen);
        this.btopen.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                File selectedFile;
                JFileChooser fc = new JFileChooser();
                int result = fc.showOpenDialog(XMLPanel.this);
                if (result == 0 && (selectedFile = fc.getSelectedFile()) != null && selectedFile.exists() && selectedFile.isFile()) {
                    try {
                        XMLPanel.this.ta.setText("");
                        BufferedReader br = new BufferedReader(new FileReader(selectedFile));
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            XMLPanel.this.ta.append(String.valueOf(line) + "\n");
                        }
                        br.close();
                        XMLPanel.this.currentfile = selectedFile;
                        XMLPanel.this.lblFile.setText(XMLPanel.this.currentfile.getName());
                        XMLPanel.this.btsave.setEnabled(true);
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.btsave = new JButton("save");
        tb.add(this.btsave);
        this.btsave.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                XMLPanel.this.saveCurrentFile();
            }
        });
        this.btsave.setEnabled(false);
        this.btsaveas = new JButton("saveas");
        tb.add(this.btsaveas);
        this.btsaveas.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                File selectedFile;
                JFileChooser fc = new JFileChooser();
                int result = fc.showOpenDialog(XMLPanel.this);
                if (result == 0 && (selectedFile = fc.getSelectedFile()) != null) {
                    XMLPanel.this.currentfile = selectedFile;
                    XMLPanel.this.lblFile.setText(XMLPanel.this.currentfile.getName());
                    XMLPanel.this.saveCurrentFile();
                    XMLPanel.this.btsave.setEnabled(true);
                }
            }
        });
        this.lblFile = new JLabel();
        tb.add(this.lblFile);
    }

    private void saveCurrentFile() {
        if (this.currentfile != null) {
            try {
                PrintWriter pw = new PrintWriter(this.currentfile, "UTF-8");
                pw.print(this.ta.getText());
                pw.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public void insertEvent(AWTEvent event) {
        StringBuilder b = new StringBuilder();
        b.append("\t\t");
        b.append("<waitforevent");
        b.append(" ");
        b.append("getClass=\"" + event.getClass() + "\"");
        b.append(" ");
        b.append("getID=\"" + event.getID() + "\"");
        if (event instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)event;
            b.append(" ");
            b.append("getClickCount=\"" + me.getClickCount() + "\"");
            b.append(" ");
            b.append("getButton=\"" + me.getButton() + "\"");
            b.append(" ");
            b.append("getModifiers=\"" + me.getModifiers() + "\"");
        } else if (event instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)event;
            b.append(" ");
            b.append("getKeyCode=\"" + ke.getKeyCode() + "\"");
            b.append(" ");
            b.append("getKeyChar=\"" + ke.getKeyChar() + "\"");
            b.append(" ");
            b.append("getModifiers=\"" + ke.getModifiers() + "\"");
        }
        b.append(">");
        Object source = event.getSource();
        if (source != null && source instanceof Component) {
            Component cmp = (Component)source;
            b.append("\n");
            b.append("\t\t\t");
            b.append("<component");
            b.append(" ");
            b.append("getClass=\"" + ComponentFinder.getAwtSwingClass(cmp.getClass()).toString().replace("class ", "") + "\"");
            b.append(" ");
            b.append("getName=\"" + cmp.getName() + "\"");
            b.append(" ");
            b.append("/>");
        }
        b.append("\n");
        b.append("\t\t");
        b.append("</waitforevent>");
        b.append("\n");
        this.ta.insert(b.toString(), this.ta.getCaretPosition());
    }

    public JTextArea getTextArea() {
        return this.ta;
    }

    public void insertString(Object selectedValue) {
        if (selectedValue != null) {
            this.ta.insert(selectedValue.toString(), this.ta.getCaretPosition());
        }
    }
}

