/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing;

import com.inet.annotations.InternalApi;
import com.inet.lib.core.OS;
import com.inet.swing.InetLookAndFeel;
import com.inet.swing.i18n.LibConstants;
import com.inet.swing.widgets.b;
import com.inet.swing.widgets.c;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleContext;

@InternalApi
public class SwingFunctions {
    private static final AbstractButton[] ay = new AbstractButton[2];
    private static final AbstractButton[] az = new AbstractButton[3];
    private static final AbstractButton[] aA = new AbstractButton[4];
    private static final JComponent[] aB = new JComponent[2];
    private static final JComponent[] aC = new JComponent[3];
    private static final Vector<SimpleAttributeSet> aD = new Vector();
    private static final Vector<SimpleAttributeSet> aE = new Vector();
    public static final int BORDER_TOP = 0;
    public static final int BORDER_BOTTOM = 1;
    public static final int BORDER_LEFT = 2;
    public static final int BORDER_RIGHT = 3;
    public static final int BS_WINDOWS = 0;
    public static final int BS_LINUX = 1;
    public static final int BS_MACOS = 2;

    private SwingFunctions() {
    }

    public static final Rectangle calculateSpan(Container container) {
        int n2 = container.getWidth();
        int n3 = container.getHeight();
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
            Component component = container.getComponent(i2);
            Rectangle rectangle = component.getBounds();
            n2 = Math.min(n2, rectangle.x);
            n3 = Math.min(n3, rectangle.y);
            n4 = Math.max(n4, rectangle.x + rectangle.width);
            n5 = Math.max(n5, rectangle.y + rectangle.height);
        }
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    public static final void sortButtons(JButton ... buttons) {
        Arrays.sort(buttons, new LocalButtonComparator());
    }

    public static final Border createRolloverBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        CompoundBorder compoundBorder = new CompoundBorder(new BasicBorders.RolloverButtonBorder(uIDefaults.getColor("controlShadow"), uIDefaults.getColor("controlDkShadow"), uIDefaults.getColor("controlHighlight"), uIDefaults.getColor("controlLtHighlight")), new EmptyBorder(1, 1, 1, 1));
        return compoundBorder;
    }

    public static final Border createEmptyBorder() {
        return BorderFactory.createEmptyBorder(10, 10, 10, 10);
    }

    public static final Border createSideBorder(int side) {
        return SwingFunctions.createSideBorder(side, null);
    }

    public static Border createSideBorder(int side, Insets insets) {
        int n2 = side == 0 ? 1 : 0;
        int n3 = side == 1 ? 1 : 0;
        int n4 = side == 2 ? 1 : 0;
        int n5 = side == 3 ? 1 : 0;
        Color color = InetLookAndFeel.ILNF_DEFAULTBACKGROUND.darker();
        Color color2 = InetLookAndFeel.ILNF_DEFAULTBACKGROUND.brighter();
        CompoundBorder compoundBorder = null;
        compoundBorder = side == 0 || side == 2 ? BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(n2, n4, n3, n5, color), BorderFactory.createMatteBorder(n2, n4, n3, n5, color2)) : BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(n2, n4, n3, n5, color2), BorderFactory.createMatteBorder(n2, n4, n3, n5, color));
        if (insets != null) {
            compoundBorder = BorderFactory.createCompoundBorder(compoundBorder, BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        }
        return compoundBorder;
    }

    public static final BorderLayout createBorderLayout() {
        return new BorderLayout(10, 10);
    }

    public static final GridLayout createGridLayout(int rows, int columns) {
        return new GridLayout(rows, columns, 10, 10);
    }

    public static final void mutex(AbstractButton button1, AbstractButton button2) {
        SwingFunctions.ay[0] = button1;
        SwingFunctions.ay[1] = button2;
        SwingFunctions.mutex(ay);
        SwingFunctions.ay[0] = null;
        SwingFunctions.ay[1] = null;
    }

    public static final void mutex(AbstractButton button1, AbstractButton button2, AbstractButton button3) {
        SwingFunctions.az[0] = button1;
        SwingFunctions.az[1] = button2;
        SwingFunctions.az[2] = button3;
        SwingFunctions.mutex(az);
        SwingFunctions.az[0] = null;
        SwingFunctions.az[1] = null;
        SwingFunctions.az[2] = null;
    }

    public static final void mutex(AbstractButton button1, AbstractButton button2, AbstractButton button3, AbstractButton button4) {
        SwingFunctions.aA[0] = button1;
        SwingFunctions.aA[1] = button2;
        SwingFunctions.aA[2] = button3;
        SwingFunctions.aA[3] = button4;
        SwingFunctions.mutex(aA);
        SwingFunctions.aA[0] = null;
        SwingFunctions.aA[1] = null;
        SwingFunctions.aA[2] = null;
        SwingFunctions.aA[3] = null;
    }

    public static final void mutex(AbstractButton[] buttons) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i2 = 0; i2 < buttons.length; ++i2) {
            buttonGroup.add(buttons[i2]);
        }
    }

    public static final void setFixedSize(JComponent component, int width, int height) {
        component.setMaximumSize(new Dimension(width, height));
        component.setMinimumSize(new Dimension(width, height));
        component.setPreferredSize(new Dimension(width, height));
    }

    public static final void setMinimumSize(JComponent component, int width, int height) {
        component.setMinimumSize(new Dimension(width, height));
        component.setPreferredSize(new Dimension(width, height));
    }

    public static final void makeCompactGrid(Container parent, int rows, int cols, int xpad, int ypad) {
        SwingFunctions.makeCompactGrid(parent, rows, cols, xpad, ypad, false);
    }

    public static final void makeCompactGrid(Container parent, int rows, int cols) {
        SwingFunctions.makeCompactGrid(parent, rows, cols, 10, 10, false);
    }

    public static final void makeCompactGrid(Container parent, int rows, int cols, boolean limit) {
        SwingFunctions.makeCompactGrid(parent, rows, cols, 10, 10, limit);
    }

    public static final void makeCompactGrid(Container parent, int rows, int cols, int xpad, int ypad, boolean limit) {
        Spring spring = Spring.constant(xpad);
        Spring spring2 = Spring.constant(ypad);
        SpringLayout springLayout = null;
        try {
            springLayout = (SpringLayout)parent.getLayout();
            if (springLayout == null) {
                springLayout = new SpringLayout();
                parent.setLayout(springLayout);
            }
        }
        catch (ClassCastException classCastException) {
            springLayout = new SpringLayout();
            parent.setLayout(springLayout);
        }
        if (limit) {
            for (int i2 = 0; i2 < parent.getComponentCount(); ++i2) {
                SwingFunctions.a((JComponent)parent.getComponent(i2));
            }
        }
        Spring spring3 = Spring.constant(0);
        for (int i3 = 0; i3 < cols; ++i3) {
            int n2;
            Spring spring4 = Spring.constant(0);
            for (n2 = 0; n2 < rows; ++n2) {
                spring4 = Spring.max(spring4, SwingFunctions.a(n2, i3, parent, cols).getWidth());
            }
            for (n2 = 0; n2 < rows; ++n2) {
                SpringLayout.Constraints constraints = SwingFunctions.a(n2, i3, parent, cols);
                constraints.setX(spring3);
                constraints.setWidth(spring4);
            }
            spring3 = Spring.sum(spring3, Spring.sum(spring4, spring));
        }
        Spring spring5 = Spring.constant(0);
        for (int i4 = 0; i4 < rows; ++i4) {
            int n3;
            Spring spring6 = Spring.constant(0);
            for (n3 = 0; n3 < cols; ++n3) {
                spring6 = Spring.max(spring6, SwingFunctions.a(i4, n3, parent, cols).getHeight());
            }
            for (n3 = 0; n3 < cols; ++n3) {
                SpringLayout.Constraints constraints = SwingFunctions.a(i4, n3, parent, cols);
                constraints.setY(spring5);
                constraints.setHeight(spring6);
            }
            spring5 = Spring.sum(spring5, Spring.sum(spring6, spring2));
        }
        spring5 = Spring.sum(spring5, Spring.minus(spring2));
        spring3 = Spring.sum(spring3, Spring.minus(spring));
        SpringLayout.Constraints constraints = springLayout.getConstraints(parent);
        constraints.setConstraint("South", spring5);
        constraints.setConstraint("East", spring3);
    }

    private static boolean[] a(JComponent jComponent) {
        boolean[] blArray = new boolean[]{false, false};
        if (jComponent instanceof JLabel || jComponent instanceof JButton) {
            SwingFunctions.d(jComponent);
            blArray[0] = true;
            blArray[1] = true;
        } else if (jComponent instanceof JComboBox || jComponent instanceof JTextField) {
            SwingFunctions.b(jComponent);
            blArray[1] = true;
        } else if (jComponent instanceof JPanel) {
            blArray[0] = true;
            blArray[1] = true;
            for (int i2 = 0; i2 < jComponent.getComponentCount(); ++i2) {
                boolean[] blArray2 = SwingFunctions.a((JComponent)jComponent.getComponent(i2));
                blArray[0] = blArray[0] && blArray2[0];
                blArray[1] = blArray[1] && blArray2[1];
            }
            if (blArray[0] && blArray[1]) {
                SwingFunctions.d(jComponent);
            } else if (blArray[1]) {
                SwingFunctions.b(jComponent);
            } else if (blArray[0]) {
                SwingFunctions.c(jComponent);
            }
        }
        return blArray;
    }

    private static void b(JComponent jComponent) {
        Dimension dimension = jComponent.getMinimumSize();
        Dimension dimension2 = jComponent.getPreferredSize();
        Dimension dimension3 = jComponent.getMaximumSize();
        dimension2.height = dimension.height;
        dimension3.height = dimension.height;
        jComponent.setPreferredSize(dimension2);
        jComponent.setMaximumSize(dimension3);
    }

    private static void c(JComponent jComponent) {
        Dimension dimension = jComponent.getMinimumSize();
        Dimension dimension2 = jComponent.getPreferredSize();
        Dimension dimension3 = jComponent.getMaximumSize();
        dimension2.width = dimension.width;
        dimension3.width = dimension.width;
        jComponent.setPreferredSize(dimension2);
        jComponent.setMaximumSize(dimension3);
    }

    private static void d(JComponent jComponent) {
        Dimension dimension = jComponent.getMinimumSize();
        Dimension dimension2 = jComponent.getPreferredSize();
        Dimension dimension3 = jComponent.getMaximumSize();
        dimension2.width = dimension.width;
        dimension2.height = dimension.height;
        dimension3.width = dimension.width;
        dimension3.height = dimension.height;
        jComponent.setPreferredSize(dimension2);
        jComponent.setMaximumSize(dimension3);
    }

    private static SpringLayout.Constraints a(int n2, int n3, Container container, int n4) {
        SpringLayout springLayout = (SpringLayout)container.getLayout();
        Component component = container.getComponent(n2 * n4 + n3);
        return springLayout.getConstraints(component);
    }

    public static final void setMaximumHeight(JComponent component, int height) {
        Dimension dimension = component.getPreferredSize();
        Dimension dimension2 = component.getMaximumSize();
        dimension.height = height;
        dimension2.height = height;
        component.setPreferredSize(dimension);
        component.setMaximumSize(dimension2);
    }

    public static final void centerWindow(Window window) {
        Dimension dimension = window.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        window.setBounds((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
    }

    public static final void centerWindow(Window win, Window owner) {
        if (owner == null) {
            SwingFunctions.centerWindow(win);
            return;
        }
        Dimension dimension = win.getSize();
        Dimension dimension2 = owner.getSize();
        int n2 = dimension2.width - dimension.width;
        int n3 = dimension2.height - dimension.height;
        Point point = owner.getLocation();
        win.setBounds(point.x + n2 / 2, point.y + n3 / 2, dimension.width, dimension.height);
    }

    public static final int distance(Color c1, Color c2) {
        int n2 = c1.getRed() - c2.getRed();
        int n3 = c1.getBlue() - c2.getBlue();
        int n4 = c1.getGreen() - c2.getGreen();
        int n5 = c1.getAlpha() - c2.getAlpha();
        return (int)Math.sqrt(n2 * n2 + n3 * n3 + n4 * n4 + n5 * n5);
    }

    public static final byte[] encodeAttributeSet(AttributeSet set) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        StyleContext.writeAttributeSet(objectOutputStream, set);
        return byteArrayOutputStream.toByteArray();
    }

    public static final AttributeSet decodeAttributeSet(byte[] set) throws IOException {
        return SwingFunctions.decodeAttributeSet(set, null);
    }

    public static final AttributeSet decodeAttributeSet(byte[] set, MutableAttributeSet receiver) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(set);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        if (receiver == null) {
            receiver = new SimpleAttributeSet();
        }
        try {
            StyleContext.readAttributeSet(objectInputStream, receiver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getMessage());
        }
        return receiver;
    }

    public static final SimpleAttributeSet newTemporarySet() {
        SimpleAttributeSet simpleAttributeSet = null;
        simpleAttributeSet = aD.isEmpty() ? new SimpleAttributeSet() : aD.remove(0);
        aE.add(simpleAttributeSet);
        return simpleAttributeSet;
    }

    public static final void freeTemporarySet(SimpleAttributeSet set) {
        set.removeAttributes(set.getAttributeNames());
        aE.remove(set);
        aD.add(set);
    }

    public static final b[] createMinMaxInput(int min, int max, int currentmin, int currentmax) {
        return SwingFunctions.createMinMaxInput(min, max, currentmin, currentmax, false);
    }

    public static final b[] createMinMaxInput(int min, int max, int currentmin, int currentmax, boolean equal) {
        b[] bArray = new b[]{new b(currentmin, true, min, max), new b(currentmax, true, min, max)};
        bArray[0].a(new a(bArray[1], equal ? 1 : 0));
        bArray[1].a(new a(bArray[0], equal ? 4 : 3));
        return bArray;
    }

    public static final com.inet.swing.widgets.a[] createMinMaxInput(double min, double max, double currentmin, double currentmax) {
        return SwingFunctions.createMinMaxInput(min, max, currentmin, currentmax, false);
    }

    public static final com.inet.swing.widgets.a[] createMinMaxInput(double min, double max, double currentmin, double currentmax, boolean equal) {
        com.inet.swing.widgets.a[] aArray = new com.inet.swing.widgets.a[]{new com.inet.swing.widgets.a(currentmin, true, min, max), new com.inet.swing.widgets.a(currentmax, true, min, max)};
        aArray[0].a(new a(aArray[1], equal ? 1 : 0));
        aArray[1].a(new a(aArray[0], equal ? 4 : 3));
        return aArray;
    }

    public static final JComponent createNonStretchableGrid(JComponent[] components) {
        return SwingFunctions.createNonStretchableGrid(components, null);
    }

    public static final JComponent createNonStretchableGrid(JComponent[] components, float[] alignment) {
        if (alignment == null) {
            alignment = new float[]{0.0f, 1.0f};
        }
        JPanel jPanel = new JPanel(new com.inet.swing.layout.a(components.length / alignment.length, alignment.length, 10, 10));
        for (int i2 = 0; i2 < components.length; ++i2) {
            components[i2].setAlignmentX(alignment[i2 % alignment.length]);
            jPanel.add(components[i2]);
        }
        return jPanel;
    }

    public static final Point calculateOffset(Component component, Component parent) {
        Point point = new Point(component.getLocation());
        while (component.getParent() != null && component.getParent() != parent) {
            component = component.getParent();
            Point point2 = component.getLocation();
            point.x += point2.x;
            point.y += point2.y;
        }
        return point;
    }

    public static final Color createContrastedColor(Color color, Color background) {
        int n2 = color.getRed() ^ background.getRed();
        int n3 = color.getGreen() ^ background.getGreen();
        int n4 = color.getBlue() ^ background.getBlue();
        return new Color(n2, n3, n4);
    }

    public static final JComponent createHorizontalEquallyGroup(JComponent first, JComponent second) {
        SwingFunctions.aB[0] = first;
        SwingFunctions.aB[1] = second;
        return SwingFunctions.createHorizontalEquallyGroup(aB);
    }

    public static final JComponent createHorizontalEquallyGroup(JComponent first, JComponent second, JComponent third) {
        SwingFunctions.aC[0] = first;
        SwingFunctions.aC[1] = second;
        SwingFunctions.aC[1] = third;
        return SwingFunctions.createHorizontalEquallyGroup(aC);
    }

    public static final JComponent createHorizontalEquallyGroup(JComponent[] elements) {
        JPanel jPanel = new JPanel(SwingFunctions.createGridLayout(1, elements.length));
        for (int i2 = 0; i2 < elements.length; ++i2) {
            jPanel.add(elements[i2]);
        }
        return jPanel;
    }

    public static final JComponent createVerticalEquallyGroup(JComponent first, JComponent second) {
        SwingFunctions.aB[0] = first;
        SwingFunctions.aB[1] = second;
        return SwingFunctions.createVerticalEquallyGroup(aB);
    }

    public static final JComponent createVerticalEquallyGroup(JComponent first, JComponent second, JComponent third) {
        SwingFunctions.aC[0] = first;
        SwingFunctions.aC[1] = second;
        SwingFunctions.aC[2] = third;
        return SwingFunctions.createVerticalEquallyGroup(aC);
    }

    public static final JComponent createVerticalEquallyGroup(JComponent[] elements) {
        JPanel jPanel = new JPanel(SwingFunctions.createGridLayout(elements.length, 1));
        for (int i2 = 0; i2 < elements.length; ++i2) {
            jPanel.add(elements[i2]);
        }
        return jPanel;
    }

    public static final JButton createIconButton(Icon icon, int dx, int dy) {
        JButton jButton = new JButton(icon);
        SwingFunctions.setMinimumSize(jButton, icon.getIconWidth() + 2 * dx, icon.getIconHeight() + 2 * dy);
        return jButton;
    }

    @InternalApi
    public static class LocalButtonComparator
    implements Comparator<JButton> {
        private int aH;
        private int aI;
        private int aJ;
        private int aK;

        public LocalButtonComparator() {
            boolean bl;
            boolean bl2 = bl = OS.isMac() || UIManager.getBoolean("OptionPane.isYesLast");
            if (bl) {
                this.aH = 4;
                this.aI = 3;
                this.aJ = 2;
                this.aK = 1;
            } else {
                this.aH = 1;
                this.aI = 2;
                this.aJ = 3;
                this.aK = 4;
            }
        }

        @Override
        public int compare(JButton object1, JButton object2) {
            String string = object1.getName();
            String string2 = object2.getName();
            int n2 = this.j(string);
            int n3 = this.j(string2);
            if (n2 == -1 || n3 == -1) {
                return 0;
            }
            return n2 - n3;
        }

        private int j(String string) {
            if ("inet.lib.ok".equals(string)) {
                return this.aH;
            }
            if ("inet.lib.cancel".equals(string)) {
                return this.aI;
            }
            if ("inet.lib.apply".equals(string)) {
                return this.aJ;
            }
            if ("inet.lib.help".equals(string)) {
                return this.aK;
            }
            return -1;
        }
    }

    private static class a
    implements com.inet.swing.api.a {
        private c aF;
        private int aG;

        public a(c c2, int n2) {
            this.aF = c2;
            this.aG = n2;
        }

        private double a(c c2) {
            if (c2 instanceof b) {
                return ((b)c2).aq();
            }
            return ((com.inet.swing.widgets.a)c2).an();
        }

        @Override
        public com.inet.swing.log.a b(c c2) {
            double d2 = this.a(c2);
            double d3 = this.a(this.aF);
            String string = null;
            if (Double.isNaN(d2) || Double.isNaN(d3)) {
                string = "inet.lib.invalidformat";
            } else {
                switch (this.aG) {
                    case 0: {
                        if (d2 < d3) {
                            return null;
                        }
                        string = "inet.lib.notlower";
                        break;
                    }
                    case 1: {
                        if (d2 <= d3) {
                            return null;
                        }
                        string = "inet.lib.notlowerequal";
                        break;
                    }
                    case 2: {
                        if (d2 == d3) {
                            return null;
                        }
                        string = "inet.lib.notequal";
                        break;
                    }
                    case 3: {
                        if (d2 > d3) {
                            return null;
                        }
                        string = "inet.lib.notgreater";
                        break;
                    }
                    case 4: {
                        if (d2 >= d3) {
                            return null;
                        }
                        string = "inet.lib.notgreaterequal";
                    }
                }
            }
            return new com.inet.swing.log.a(2, LibConstants.MSG.getMsg(string, new Object[]{new Double(d2), new Double(d3)}));
        }
    }
}

