/*
 * Decompiled with CFR 0.152.
 */
package de.anormalmedia.sbstutorial.gui.recorder;

import de.anormalmedia.sbstutorial.gui.recorder.XMLPanel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MethodList
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final XMLPanel xmlpanel;
    private JList mlist;
    private JTextField filter;
    private Vector<String> currentVector;

    public MethodList(XMLPanel xmlpanel) {
        super(new BorderLayout());
        this.xmlpanel = xmlpanel;
        this.mlist = new JList();
        this.mlist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MethodList.this.xmlpanel.insertString(MethodList.this.mlist.getSelectedValue());
                }
            }
        });
        this.add((Component)new JScrollPane(this.mlist), "Center");
        this.filter = new JTextField();
        this.add((Component)this.filter, "North");
        this.filter.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                Vector<String> filtered = new Vector<String>();
                if (MethodList.this.currentVector != null) {
                    String ftext = MethodList.this.filter.getText();
                    for (String data : MethodList.this.currentVector) {
                        if (ftext.length() != 0 && !data.toLowerCase().contains(ftext.toLowerCase())) continue;
                        filtered.add(data);
                    }
                }
                Collections.sort(filtered);
                MethodList.this.mlist.setListData(filtered);
            }
        });
    }

    public void listMethods(AWTEvent event) {
        Vector<String> vector = new Vector<String>();
        Object source = event.getSource();
        if (source != null && source instanceof Component) {
            Method[] methods;
            Method[] methodArray = methods = source.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                Class<?>[] parameterTypes = m.getParameterTypes();
                if (!(m.getReturnType().toString().equals("void") || parameterTypes != null && parameterTypes.length != 0)) {
                    try {
                        Object invoke = null;
                        if (m.getName().startsWith("get") || m.getName().startsWith("is") || m.getName().startsWith("has")) {
                            invoke = m.invoke(source, null);
                            vector.add(String.valueOf(m.getName()) + "=\"" + (invoke == null ? "null" : invoke.toString()) + "\" ");
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        Collections.sort(vector);
        this.currentVector = new Vector();
        this.filter.setText("");
        this.currentVector.addAll(vector);
        this.mlist.setListData(vector);
    }
}

