/*
 * Decompiled with CFR 0.152.
 */
package com.inet.guilib;

import com.inet.guilib.AsyncWorker;
import com.inet.guilib.LockingGlassPane;
import com.inet.guilib.WorkerPool;
import com.inet.guilib.i18n.Msg;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class LockPane
extends LockingGlassPane
implements PropertyChangeListener {
    private static Logger logger = Logger.getLogger("com.inet.guilib.LockPane");
    private static boolean inverse;
    private static Color borderColor;
    private static Color bgColor;
    private static Color rectColor;
    private static Color msgColor;
    private static Color msgESCColor;
    private static Color barColor;
    private static Map<Component, WorkerPool> poolMap;
    private static final int PROGRESS_WIDHT = 260;
    private static final String OLD_PANE_STATE = "OLD_PANE_STATE";
    private int bW = 300;
    private int bH = 150;
    private int R = 23;
    private int w;
    private int h;
    private int index;
    private List<Shape> shapes = new ArrayList<Shape>();
    private AsyncWorker<?, ?> worker;
    private AsyncWorker.Type lastType;
    private String cancelMsg = Msg.getMsg("CancelMsg", "'" + KeyEvent.getKeyText(27) + "'");
    private WindowListener windowListener = new LockPaneWindowListener();
    private Timer timer = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (LockPane.this.getCursor().getType() != 3) {
                long minTime = LockPane.this.worker.getMinimumTime();
                if (LockPane.this.worker.getTime() >= minTime) {
                    LockPane.this.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
            if (LockPane.this.allowProgressPaint()) {
                if (!LockPane.this.shapes.isEmpty()) {
                    LockPane.this.index = (LockPane.this.index + 1) % LockPane.this.shapes.size();
                }
                LockPane.this.repaint();
            }
        }
    });
    private AWTEventListener keyListener = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent event) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "KeyListener Worker: {0} Event: {1}", new Object[]{LockPane.this.worker == null ? "NULL" : LockPane.this.worker.paramString(), event.paramString()});
            }
            if (LockPane.this.worker == null || LockPane.this.worker.isDone()) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(LockPane.this.keyListener);
                return;
            }
            KeyEvent e = (KeyEvent)event;
            Window window = SwingUtilities.windowForComponent(LockPane.this);
            if (window == null || window.isActive()) {
                boolean cancelEvent;
                boolean bl = cancelEvent = 401 == e.getID() && e.getKeyCode() == 27;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "KeyListener CANCEL event: {0} , Window: {1} ", new Object[]{cancelEvent, window});
                }
                if (cancelEvent) {
                    LockPane.this.cancelWorker(LockPane.this.worker != null && !LockPane.this.worker.isAtomic());
                }
                e.consume();
            }
        }
    };

    private LockPane() {
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){});
        this.addMouseMotionListener(new MouseMotionAdapter(){});
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "escape");
        this.getActionMap().put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "ESCAPE action Worker: {0} ", new Object[]{LockPane.this.worker == null ? "NULL" : LockPane.this.worker.paramString()});
                }
                LockPane.this.cancelWorker(LockPane.this.worker != null && !LockPane.this.worker.isAtomic());
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.allowProgressPaint()) {
            super.paintComponent(g);
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int oldW = this.w;
        int oldH = this.h;
        this.w = this.getWidth();
        this.h = this.getHeight();
        boolean createShapes = this.worker.getType() != this.lastType || this.w != oldW || this.h != oldH;
        this.lastType = this.worker.getType();
        g2.setColor(bgColor);
        g2.fillRect(0, 0, this.w, this.h);
        Rectangle r = new Rectangle(this.w / 2 - this.bW / 2, this.h / 2 - this.bH / 2, this.bW, this.bH);
        g2.setColor(rectColor);
        g2.fillRoundRect(r.x, r.y, r.width, r.height, 10, 10);
        g2.setColor(borderColor);
        g2.drawRoundRect(r.x, r.y, r.width, r.height, 10, 10);
        this.paintIndeterminate(g2, r, createShapes);
        this.paintDeterminate(g2, r);
        if (this.worker.getMessage() != null) {
            g2.setFont(g2.getFont().deriveFont(12.0f));
            String clippedMsg = LockPane.clipString(this.worker.getMessage(), 260, g2.getFontMetrics(), true);
            g2.setColor(msgColor);
            int mw = g2.getFontMetrics().stringWidth(clippedMsg);
            int deltaY = this.worker.isTypeOf(AsyncWorker.Type.DETERMINATE) ? 50 : 30;
            g2.drawString(clippedMsg, this.w / 2 - mw / 2, r.y + r.height - deltaY);
        }
        if (!this.worker.isAtomic()) {
            g2.setColor(msgESCColor);
            g2.setFont(g2.getFont().deriveFont(11.0f));
            int sw = g2.getFontMetrics().stringWidth(this.cancelMsg);
            g2.drawString(this.cancelMsg, this.w / 2 - sw / 2, r.y + r.height - 6);
        }
    }

    private void paintIndeterminate(Graphics2D g2, Rectangle r, boolean createShapes) {
        int i;
        int delta = this.worker.isTypeOf(AsyncWorker.Type.DETERMINATE) ? 50 : r.height / 2;
        Point2D.Double cx = new Point2D.Double((double)r.x + (double)r.width / 2.0, r.y + delta);
        if (createShapes) {
            this.shapes.clear();
            for (i = 10; i < 360; i += 30) {
                Point2D p0 = this.getPoint2D(cx, this.R - 10, i);
                Point2D p1 = this.getPoint2D(cx, this.R, i);
                Point2D p2 = this.getPoint2D(cx, this.R, i + 10);
                Point2D p3 = this.getPoint2D(cx, this.R - 10, i + 10);
                GeneralPath path = new GeneralPath(1, 5);
                path.moveTo((float)p0.getX(), (float)p0.getY());
                path.lineTo((float)p1.getX(), (float)p1.getY());
                path.lineTo((float)p2.getX(), (float)p2.getY());
                path.lineTo((float)p3.getX(), (float)p3.getY());
                path.closePath();
                this.shapes.add(path);
            }
        }
        for (i = 0; i < this.shapes.size(); ++i) {
            int t = (i + this.index) % this.shapes.size();
            int channel = 224 - 180 / (t + 1);
            Color c = new Color(channel, channel, channel);
            g2.setColor(c);
            g2.fill(this.shapes.get(i));
            g2.draw(this.shapes.get(i));
        }
    }

    private void paintDeterminate(Graphics2D g2, Rectangle rect) {
        if (this.worker.isTypeOf(AsyncWorker.Type.DETERMINATE)) {
            int W = 10;
            Rectangle r = new Rectangle(rect.x + 19, rect.y + rect.height - 45, rect.width - 38, 18);
            DefaultBoundedRangeModel model = this.worker.getProgressModel();
            int min = model.getMinimum();
            int max = model.getMaximum();
            int v = model.getValue();
            double proz = (double)(v - min) / (double)(max - min) * 100.0;
            g2.setColor(new Color(255, 255, 255, 100));
            g2.fillRoundRect(r.x, r.y, r.width, r.height - 1, 6, 6);
            g2.setColor(borderColor);
            g2.drawRoundRect(r.x, r.y, r.width, r.height - 1, 6, 6);
            g2.setColor(barColor);
            double stepProz = (double)(100 * W) / (double)r.width;
            if (proz > 0.0) {
                for (int i = 0; !(i >= r.width / W || i != 0 && (double)(i + 1) * stepProz > proz); ++i) {
                    g2.fillRoundRect(r.x + i * W + 2, r.y + 2, W - 2, r.height - 4, 4, 4);
                }
            }
        }
    }

    public AsyncWorker<?, ?> getWorker() {
        return this.worker;
    }

    private void cancelWorker(boolean condition) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Condition {0}, Worker: {1}", new Object[]{String.valueOf(condition), this.worker.paramString()});
        }
        if (condition) {
            this.worker.cancel(true);
        }
    }

    public static String clipString(String s, int maxWidth, FontMetrics fm, boolean appendPoints) {
        int sw = fm.stringWidth(s);
        if (sw <= maxWidth) {
            return s;
        }
        String sPoints = "...";
        int delta = appendPoints ? fm.stringWidth(sPoints) : 0;
        maxWidth -= delta;
        while (sw > maxWidth && s.length() > 0) {
            s = s.substring(0, s.length() - 1);
            sw = fm.stringWidth(s);
        }
        return appendPoints ? s + sPoints : s;
    }

    private Point2D getPoint2D(Point2D p, double radius, double alpha) {
        double angle = Math.toRadians(alpha);
        double x = p.getX() + Math.cos(angle) * radius;
        double y = p.getY() - Math.sin(angle) * radius;
        return new Point2D.Double(x, y);
    }

    private boolean allowProgressPaint() {
        return this.worker != null && !this.worker.isTypeOf(AsyncWorker.Type.OFF) && this.worker.getTime() >= (long)this.worker.getMinimumTime();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        if ("progress".equals(evt.getPropertyName())) {
            Object value;
            if (newValue instanceof List && !((List)newValue).isEmpty() && (value = ((List)newValue).get(0)) instanceof Integer) {
                this.worker.getProgressModel().setValue((Integer)value);
            }
        } else if ("unlock".equals(evt.getPropertyName())) {
            this.unlock();
        }
    }

    private void startLock() {
        Window window;
        this.cancelMsg = Msg.getMsg("CancelMsg", "'" + KeyEvent.getKeyText(27) + "'");
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "START_LOCK Worker: {0} ", new Object[]{this.worker.paramString()});
        }
        if ((window = SwingUtilities.windowForComponent(this)) != null) {
            WindowListener[] listeners;
            for (WindowListener listner : listeners = window.getWindowListeners()) {
                if (!(listner instanceof LockPaneWindowListener)) continue;
                window.removeWindowListener(listner);
            }
            window.addWindowListener(this.windowListener);
        }
        this.worker.addPropertyChangeListener(this);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Toolkit.getDefaultToolkit().addAWTEventListener(LockPane.this.keyListener, 8L);
                return null;
            }
        });
        this.w = 0;
        this.h = 0;
        this.setCursor(this.worker.getMinimumTime() <= 0 ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor());
        this.timer.start();
        this.setVisible(true);
        this.worker.execute();
    }

    private void endLock() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "END_LOCK Worker: {0} ", new Object[]{this.worker.paramString()});
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.keyListener);
        this.worker.removePropertyChangeListener(this);
        Window window = SwingUtilities.windowForComponent(this);
        if (window != null) {
            window.removeWindowListener(this.windowListener);
        }
        this.worker.getProgressModel().setValue(this.worker.getProgressModel().getMinimum());
        this.timer.stop();
    }

    private static void lock(Component c, AsyncWorker<?, ?> swingWorker) {
        LockPane lockPane;
        JRootPane rootPane = LockPane.getRootPane(c);
        if (rootPane == null) {
            throw new IllegalArgumentException("RootPane can't be determined for the component 'c': " + String.valueOf(c));
        }
        Component oldGP = rootPane.getGlassPane();
        Boolean b = oldGP.isVisible();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "<<<<<<< OLD_PANE_STATE oldGp: {0} visible {1} ", new Object[]{oldGP, b});
        }
        if (oldGP instanceof LockPane) {
            lockPane = (LockPane)oldGP;
        } else {
            lockPane = new LockPane();
            if (!(oldGP instanceof LockingGlassPane)) {
                rootPane.setGlassPane(lockPane);
                rootPane.putClientProperty(OLD_PANE_STATE, new Object[]{oldGP, b});
            }
        }
        lockPane.worker = swingWorker;
        lockPane.startLock();
    }

    private void unlock() {
        this.endLock();
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            Object[] state = (Object[])rootPane.getClientProperty(OLD_PANE_STATE);
            if (state != null) {
                rootPane.putClientProperty(OLD_PANE_STATE, null);
                Component oldGP = (Component)state[0];
                rootPane.setGlassPane(oldGP);
                oldGP.setVisible((Boolean)state[1]);
            }
            if (logger.isLoggable(Level.FINEST)) {
                if (state == null) {
                    logger.log(Level.FINEST, ">>>>>>>> OLD_PANE_STATE is NULL");
                } else {
                    logger.log(Level.FINEST, ">>>>>>>> OLD_PANE_STATE oldGp: {0} visible {1} ", new Object[]{state[0], state[1]});
                }
            }
        }
        this.setVisible(false);
    }

    public static <T, V> void call(Component c, AsyncWorker<T, V> worker) {
        LockPane.lock(c, worker);
    }

    public static <T, V> void callShort(Component c, AsyncWorker<T, V> worker) {
        worker.setType(AsyncWorker.Type.OFF);
        LockPane.call(c, worker);
    }

    public static <T, V> void callAtomic(Component c, AsyncWorker<T, V> worker) {
        worker.setAtomic(true);
        LockPane.call(c, worker);
    }

    public static <T, V> void callShortAtomic(Component c, AsyncWorker<T, V> worker) {
        worker.setAtomic(true);
        LockPane.callShort(c, worker);
    }

    public static JRootPane getRootPane(Component c) {
        JRootPane rootPane = SwingUtilities.getRootPane(c);
        if (rootPane == null && c instanceof Frame) {
            for (int i = 0; i < ((Container)c).getComponentCount() && (rootPane = SwingUtilities.getRootPane(((Container)c).getComponent(i))) == null; ++i) {
            }
        }
        return rootPane;
    }

    public static <T, V> WorkerPool callInPool(Component c, AsyncWorker<T, V> worker) {
        return LockPane.callInPool(c, true, worker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, V> WorkerPool callInPool(Component c, boolean concurrentPoolExcecution, AsyncWorker<T, V> worker) {
        WorkerPool pool;
        JRootPane root = LockPane.getRootPane(c);
        if (root == null) {
            throw new IllegalArgumentException("RootPane can't be determined for the component 'c': " + String.valueOf(c));
        }
        Map<Component, WorkerPool> map = poolMap;
        synchronized (map) {
            pool = poolMap.get(root);
            if (!concurrentPoolExcecution && pool != null && pool.isConcurrentExcecution()) {
                pool = null;
            }
            if (pool == null || !pool.addWorker(worker)) {
                pool = new WorkerPool(concurrentPoolExcecution, worker);
                poolMap.put(root, pool);
                LockPane.call(c, pool);
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Called Worker in Pool poolMapSize:{0} Worker: {1} WorkerPool: {2} ", new Object[]{poolMap.size(), worker.paramString(), pool.paramString()});
        }
        return pool;
    }

    public static <T, V> T callAndWait(Component c, final AsyncWorker<T, V> worker) throws Exception {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "START callAndWait Worker: {0} ", new Object[]{worker.paramString()});
        }
        final JDialog d = new JDialog((Frame)null, true);
        d.setUndecorated(true);
        d.setLocationRelativeTo(c);
        final PropertyChangeEvent[] resultEvent = new PropertyChangeEvent[1];
        worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("unlock".equals(evt.getPropertyName())) {
                    resultEvent[0] = evt;
                    d.dispose();
                }
            }
        });
        AWTEventListener keyListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                KeyEvent e = (KeyEvent)event;
                if (401 == e.getID() && e.getKeyCode() == 27) {
                    worker.cancel(true);
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(keyListener, 8L);
        LockPane.lock(c, worker);
        d.setVisible(true);
        Toolkit.getDefaultToolkit().removeAWTEventListener(keyListener);
        PropertyChangeEvent event = resultEvent[0];
        if (event == null || event.getOldValue() == null) {
            logger.log(Level.WARNING, "event: " + String.valueOf(event) + " for worker " + worker.paramString());
            throw new CancellationException();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "END callAndWait Worker: {0} result state {1} ", new Object[]{worker.paramString(), event.getOldValue()});
        }
        switch ((AsyncWorker.State)((Object)event.getOldValue())) {
            case SUCCESS: {
                return (T)event.getNewValue();
            }
            case EXCEPTION: {
                throw (Exception)event.getNewValue();
            }
            case CANCEL: {
                throw new CancellationException();
            }
        }
        throw new IllegalStateException();
    }

    public static void setInverse(boolean inverse) {
        LockPane.inverse = inverse;
    }

    static {
        borderColor = new Color(150, 150, 150, 230);
        bgColor = inverse ? new Color(0, 0, 0, 30) : new Color(255, 255, 255, 75);
        rectColor = inverse ? new Color(255, 255, 255, 230) : new Color(0, 0, 0, 200);
        msgColor = inverse ? Color.DARK_GRAY.brighter() : Color.LIGHT_GRAY;
        msgESCColor = inverse ? Color.DARK_GRAY.brighter().brighter() : Color.LIGHT_GRAY.darker();
        barColor = inverse ? new Color(40, 210, 43, 175) : new Color(255, 255, 255, 200);
        poolMap = Collections.synchronizedMap(new WeakHashMap());
    }

    private class LockPaneWindowListener
    extends WindowAdapter {
        private LockPaneWindowListener() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            logger.fine("Calling windowClosed");
            LockPane.this.cancelWorker(LockPane.this.worker != null && !LockPane.this.worker.isDone() && !LockPane.this.worker.isAtomic());
        }
    }
}

