/*
 * Decompiled with CFR 0.152.
 */
package de.anormalmedia.sbstutorial;

import de.anormalmedia.sbstutorial.Tutorial;
import de.anormalmedia.sbstutorial.gui.step.Step;
import de.anormalmedia.sbstutorial.gui.step.TutorialStepFrame;
import de.anormalmedia.sbstutorial.listener.EventTutorialListener;
import de.anormalmedia.sbstutorial.store.AbstractStore;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.AWTEventListenerProxy;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;

public class SBSTutorial {
    private static boolean blockSecondTutorial = false;
    private static Vector<TutorialStepFrame> runningTutorials = new Vector();
    private Window parent = null;
    private boolean suppressIntro;
    private AbstractStore store;
    private JTextPane textpane;
    private ArrayList<ResourceBundle> externalResourceBundles = new ArrayList();

    public void addExternalResourceBundle(ResourceBundle externalResourceBundle) {
        this.externalResourceBundles.add(externalResourceBundle);
    }

    public void start() throws FileNotFoundException {
        ResourceBundle languageResource = ResourceBundle.getBundle("de.anormalmedia.sbstutorial.i18n.SBSTutorial");
        if (blockSecondTutorial) {
            AWTEventListener[] eventListeners = Toolkit.getDefaultToolkit().getAWTEventListeners();
            if (eventListeners != null) {
                AWTEventListener[] aWTEventListenerArray = eventListeners;
                int n = eventListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    AWTEventListener awtel = aWTEventListenerArray[n2];
                    if (awtel instanceof AWTEventListenerProxy) {
                        AWTEventListenerProxy proxy = (AWTEventListenerProxy)awtel;
                        awtel = proxy.getListener();
                    }
                    if (awtel instanceof EventTutorialListener) {
                        String dontruntwice_msg;
                        String dontruntwice_title;
                        try {
                            dontruntwice_title = languageResource.getString("gui.error.dontruntwice.title");
                        }
                        catch (MissingResourceException mre) {
                            dontruntwice_title = "::gui.error.dontruntwice.title::";
                        }
                        try {
                            dontruntwice_msg = languageResource.getString("gui.error.dontruntwice.msg");
                        }
                        catch (Exception e) {
                            dontruntwice_msg = "::gui.error.dontruntwice.msg::";
                        }
                        JOptionPane.showMessageDialog(this.parent, dontruntwice_msg, dontruntwice_title, 0);
                        return;
                    }
                    ++n2;
                }
            }
        } else {
            Vector<TutorialStepFrame> runningCopy = new Vector<TutorialStepFrame>();
            runningCopy.addAll(runningTutorials);
            if (runningCopy.size() > 0) {
                String closerunning_msg;
                String closerunning_title;
                int activecount = 0;
                for (TutorialStepFrame frame : runningCopy) {
                    Step cstep;
                    ++activecount;
                    Tutorial tut = frame.getTutorial();
                    if (tut == null || (cstep = tut.getCurrentStep()) == null || cstep.getType() != 2) continue;
                    --activecount;
                }
                try {
                    closerunning_title = languageResource.getString("gui.error.closerunning.title");
                }
                catch (MissingResourceException mre) {
                    closerunning_title = "::gui.error.closerunning.title::";
                }
                try {
                    closerunning_msg = languageResource.getString("gui.error.closerunning.msg");
                }
                catch (Exception e) {
                    closerunning_msg = "::gui.error.closerunning.msg::";
                }
                int result = 0;
                if (activecount > 0) {
                    result = JOptionPane.showConfirmDialog(this.parent, closerunning_msg, closerunning_title, 0);
                }
                if (result == 0) {
                    for (TutorialStepFrame frame : runningCopy) {
                        frame.dispose();
                    }
                    runningCopy.clear();
                } else {
                    runningCopy.clear();
                    return;
                }
            }
        }
        Tutorial tutorial = null;
        if (this.store != null) {
            tutorial = new Tutorial(this.store, this.suppressIntro);
        }
        if (tutorial == null) {
            throw new FileNotFoundException("Tutorial not found: " + (this.store == null ? "<undefinded>" : this.store.getUrl().toString()));
        }
        for (ResourceBundle extRes : this.externalResourceBundles) {
            tutorial.addExternalResourceBundle(extRes);
        }
        EventTutorialListener eventTutorialListener = new EventTutorialListener();
        if (this.textpane == null) {
            this.textpane = new JTextPane();
            this.textpane.setEditable(false);
        }
        TutorialStepFrame tutorialStepFrame = null;
        tutorialStepFrame = this.parent instanceof Dialog ? new TutorialStepFrame(tutorial, eventTutorialListener, (Dialog)this.parent, this.textpane) : (this.parent instanceof Frame ? new TutorialStepFrame(tutorial, eventTutorialListener, (Frame)this.parent, this.textpane) : new TutorialStepFrame(tutorial, eventTutorialListener, (Frame)this.parent, this.textpane));
        runningTutorials.add(tutorialStepFrame);
        tutorial.addStepChangedListener(tutorialStepFrame);
        eventTutorialListener.startListener(tutorial);
    }

    public static void setBlockSecondTutorial(boolean blockSecondTutorial) {
        SBSTutorial.blockSecondTutorial = blockSecondTutorial;
    }

    public static void removeTutorialFrame(TutorialStepFrame frame) {
        runningTutorials.remove(frame);
    }

    public void setStore(AbstractStore store) {
        this.store = store;
    }

    public void setParentWindow(Window parent) {
        this.parent = parent;
    }

    public void setSuppressIntro(boolean suppressIntro) {
        this.suppressIntro = suppressIntro;
    }

    public void setTextpane(JTextPane textpane) {
        this.textpane = textpane;
    }
}

