/*
 * Decompiled with CFR 0.152.
 */
package de.anormalmedia.sbstutorial.store;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class AbstractStore {
    private URL url;
    private JarFile jar;

    protected void setURL(URL jarurl) {
        this.url = jarurl;
        try {
            if (this.url.toString().toLowerCase().startsWith("jar:")) {
                File tempFile = File.createTempFile("SBSTUTORIAL", String.valueOf(System.currentTimeMillis()));
                tempFile.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(tempFile);
                URLConnection uc = this.url.openConnection();
                InputStream is = uc.getInputStream();
                byte[] buf = new byte[1024];
                int i = 0;
                while ((i = is.read(buf)) != -1) {
                    fos.write(buf, 0, i);
                }
                is.close();
                fos.flush();
                fos.close();
                this.url = tempFile.toURI().toURL();
            }
            if (!this.url.toString().toLowerCase().startsWith("jar:")) {
                this.url = new URL("jar", "", -1, String.valueOf(this.url.toString()) + "!/");
            }
            URLConnection uc = this.url.openConnection();
            this.jar = ((JarURLConnection)uc).getJarFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public InputStream getResource(String resource) {
        JarEntry entry;
        if (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        if (this.jar != null && (entry = this.jar.getJarEntry(resource)) != null) {
            try {
                return this.jar.getInputStream(entry);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

