/*
 * Decompiled with CFR 0.152.
 */
package de.anormalmedia.sbstutorial.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class ComponentFlasher
implements Runnable {
    private Component component;
    private int state = 0;
    private boolean running = false;
    private Color flashColor = new Color(255, 0, 0, 80);
    private Thread runningThread;

    public void startFlasher() {
        if (!this.isRunning()) {
            this.runningThread = new Thread((Runnable)this, "TutorialFlasher");
            this.runningThread.start();
        }
    }

    public void run() {
        this.running = true;
        while (this.running) {
            this.state = 1 - this.state;
            Component copy = this.component;
            if (copy != null) {
                switch (this.state) {
                    case 0: {
                        try {
                            Graphics g = copy.getGraphics();
                            if (g == null) {
                                this.component.invalidate();
                                this.component.repaint(0, 0, this.component.getWidth(), this.component.getHeight());
                                this.component = null;
                                break;
                            }
                            g.setColor(this.flashColor);
                            int x = 0;
                            int y = 0;
                            int cw = copy.getWidth();
                            int ch = copy.getHeight();
                            if (this.component instanceof JComponent) {
                                JComponent jcomp = (JComponent)this.component;
                                Rectangle vr = jcomp.getVisibleRect().getBounds();
                                x = vr.x;
                                y = vr.y;
                                cw = vr.width;
                                ch = vr.height;
                            }
                            if (!this.component.isShowing()) break;
                            if (cw < 100 || ch < 100) {
                                g.fillRect(x, y, cw, ch);
                                break;
                            }
                            g.drawRect(x, y, cw - 1, ch - 1);
                            g.drawRect(x + 1, y + 1, cw - 3, ch - 3);
                            g.drawRect(x + 2, y + 2, cw - 5, ch - 5);
                        }
                        catch (Exception g) {}
                        break;
                    }
                    case 1: {
                        copy.invalidate();
                        copy.repaint(0, 0, copy.getWidth(), copy.getHeight());
                    }
                }
            }
            try {
                Thread.sleep(150 + 250 * this.state);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        try {
            if (this.component != null) {
                this.component.invalidate();
                this.component.repaint(0, 0, this.component.getWidth(), this.component.getHeight());
                this.component = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isRunning() {
        return this.running && this.runningThread != null && this.runningThread.isAlive();
    }

    public void stopFlasher() {
        this.running = false;
        if (this.runningThread != null && this.runningThread.isAlive()) {
            this.runningThread.interrupt();
        }
    }

    public void setComponent(Component component) {
        if (component == null) {
            this.stopFlasher();
        }
        try {
            if (this.component != null) {
                this.component.invalidate();
                this.component.repaint(0, 0, this.component.getWidth(), this.component.getHeight());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.component = component;
        if (component != null && !this.isRunning()) {
            this.startFlasher();
        }
    }

    public void setColor(Color color) {
        this.flashColor = color;
    }
}

