/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing.factory;

import com.inet.annotations.InternalApi;
import com.inet.permissions.AccessDeniedException;
import com.inet.swing.LaF;
import com.inet.swing.factory.FileChooserDefintion;
import com.inet.swing.i18n.LibConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

@InternalApi
public class DefaultFileChooserFactory {
    protected JFileChooser createFileChooser() {
        return new JFileChooser();
    }

    /*
     * WARNING - void declaration
     */
    public void openFileChooser(FileChooserDefintion defintion, Consumer<List<File>> consumer) {
        JFileChooser jFileChooser = LaF.FILECHOOSERFACTORY.createFileChooser();
        jFileChooser.setDialogTitle(defintion.getTitle());
        jFileChooser.setDialogType(defintion.isSaveDialog() ? 1 : 0);
        jFileChooser.setMultiSelectionEnabled(defintion.isMultipleSelection());
        if (defintion.isFileAllowed() && !defintion.isDirectoryAllowed()) {
            jFileChooser.setFileSelectionMode(0);
        } else if (!defintion.isFileAllowed() && defintion.isDirectoryAllowed()) {
            jFileChooser.setFileSelectionMode(1);
        } else {
            jFileChooser.setFileSelectionMode(2);
        }
        if (defintion.getPosition() != null) {
            if (defintion.getPosition().isDirectory()) {
                jFileChooser.setCurrentDirectory(defintion.getPosition());
            } else if (defintion.isSaveDialog() || defintion.getPosition().exists()) {
                jFileChooser.setSelectedFile(defintion.getPosition());
            }
        }
        if (!(defintion.isSaveDialog() || defintion.isDirectoryAllowed() && !defintion.isFileAllowed() || jFileChooser.getUI().getDefaultButton(jFileChooser) == null)) {
            boolean bl = defintion.getPosition() != null && (defintion.getPosition().isFile() && defintion.isFileAllowed() || defintion.getPosition().isDirectory() && defintion.isDirectoryAllowed());
            jFileChooser.getUI().getDefaultButton(jFileChooser).setEnabled(bl);
            jFileChooser.addPropertyChangeListener(propertyChangeEvent -> {
                if (jFileChooser.getUI().getDefaultButton(jFileChooser) != null) {
                    HashSet<File> hashSet = new HashSet<File>(Arrays.asList(jFileChooser.getSelectedFiles()));
                    if (jFileChooser.getSelectedFile() != null) {
                        hashSet.add(jFileChooser.getSelectedFile());
                    }
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    for (File file : hashSet) {
                        if (file.isFile()) {
                            ++n2;
                            continue;
                        }
                        ++n3;
                    }
                    n4 += defintion.isFileAllowed() ? n2 : 0;
                    boolean bl = defintion.getNumOfSelectedDocument() == -1 || (n4 += defintion.isDirectoryAllowed() ? n3 : 0) <= defintion.getNumOfSelectedDocument();
                    jFileChooser.getUI().getDefaultButton(jFileChooser).setEnabled(n2 > 0 && bl);
                }
            });
        }
        if (!defintion.getFileFilters().isEmpty()) {
            void var4_7;
            for (FileFilter fileFilter : jFileChooser.getChoosableFileFilters()) {
                jFileChooser.removeChoosableFileFilter(fileFilter);
            }
            Object arrayList = null;
            for (String string : defintion.getFileFilters().keySet()) {
                CharSequence[] charSequenceArray = defintion.getFileFilters().get(string).toArray(new String[0]);
                String string2 = string + " (" + (String)(charSequenceArray.length > 1 ? String.join((CharSequence)", ", charSequenceArray) : charSequenceArray[0]) + ")";
                FileFilter fileFilter = new FileFilter((String[])charSequenceArray, string2){
                    final /* synthetic */ String[] gk;
                    final /* synthetic */ String gl;
                    {
                        this.gk = stringArray;
                        this.gl = string;
                    }

                    @Override
                    public boolean accept(File f2) {
                        for (String string : this.gk) {
                            String string2 = string = string.startsWith("*.") ? string.substring(2) : string;
                            if (string.equals("*")) {
                                return true;
                            }
                            if (!f2.getName().toLowerCase().endsWith("." + string)) continue;
                            return true;
                        }
                        return f2.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return this.gl;
                    }
                };
                jFileChooser.addChoosableFileFilter(fileFilter);
                if (defintion.getSelectedFilterName() == null || !string.equals(defintion.getSelectedFilterName()) && !string2.equals(defintion.getSelectedFilterName())) continue;
                FileFilter fileFilter2 = fileFilter;
            }
            if (var4_7 != null) {
                jFileChooser.setFileFilter((FileFilter)var4_7);
            }
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        int n2 = defintion.getButtonText() != null ? jFileChooser.showDialog(defintion.getParent(), defintion.getButtonText()) : (defintion.isSaveDialog() ? jFileChooser.showSaveDialog(defintion.getParent()) : jFileChooser.showOpenDialog(defintion.getParent()));
        switch (n2) {
            case 0: {
                if (defintion.isMultipleSelection()) {
                    File[] fileArray = jFileChooser.getSelectedFiles();
                    arrayList.addAll(Arrays.asList(fileArray));
                    break;
                }
                File file = jFileChooser.getSelectedFile();
                if (!defintion.isSaveDialog() && !file.canRead()) {
                    this.a((Throwable)new AccessDeniedException(LibConstants.MSG.getMsg("int.lib.accessDeniedRead", new Object[]{file.getAbsolutePath()})));
                    consumer.accept(arrayList);
                    return;
                }
                if (defintion.isSaveDialog() && !file.getParentFile().canWrite()) {
                    this.a((Throwable)new AccessDeniedException(LibConstants.MSG.getMsg("int.lib.accessDeniedWrite", new Object[]{file.getAbsolutePath()})));
                    consumer.accept(arrayList);
                    return;
                }
                arrayList.add(file);
            }
        }
        consumer.accept(arrayList);
    }

    private void a(Throwable throwable) {
        String string = LibConstants.MSG.getMsg("int.lib.accessDenied", new Object[0]);
        LaF.DIALOGFACTORY.showErrorMessageDialog(null, throwable.getMessage(), string, 0, throwable);
    }
}

