/*
 * Decompiled with CFR 0.152.
 */
package de.anormalmedia.sbstutorial;

import de.anormalmedia.sbstutorial.gui.ComponentFlasher;
import de.anormalmedia.sbstutorial.gui.step.Step;
import de.anormalmedia.sbstutorial.listener.StepChangedListener;
import de.anormalmedia.sbstutorial.store.AbstractStore;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tutorial
implements Comparable<Tutorial> {
    private Document tutorialDoc;
    private Element root;
    private ArrayList<Step> steplist = new ArrayList();
    private Step currentStep;
    private int currentIndex = -1;
    private ComponentFlasher flasher = new ComponentFlasher();
    private List<StepChangedListener> listeners = new ArrayList<StepChangedListener>();
    private String title;
    private Dimension initialSize = new Dimension(400, 300);
    private String locvert = "bottom";
    private String lochoriz = "right";
    private Properties languageResource;
    private ArrayList<ResourceBundle> externalResourceBundles = new ArrayList();
    private boolean suppressIntro;
    private String introDescription = null;
    private Insets margin;
    private final AbstractStore store;

    public Tutorial(AbstractStore store, boolean suppressIntro) throws FileNotFoundException {
        this.store = store;
        this.suppressIntro = suppressIntro;
        this.restart(suppressIntro);
    }

    public String getIntroDescription() {
        return this.introDescription;
    }

    public String getTitle() {
        return this.title;
    }

    public Dimension getInitialSize() {
        return this.initialSize;
    }

    public String getLochoriz() {
        return this.lochoriz;
    }

    public String getLocvert() {
        return this.locvert;
    }

    public Insets getMargin() {
        return this.margin;
    }

    private void parseTutorial(InputStream xmlresource) {
        if (xmlresource == null) {
            throw new NullPointerException("The tutorial could not be started. Stream could not be opened.");
        }
        try {
            this.tutorialDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlresource);
            xmlresource.close();
            if (this.tutorialDoc != null) {
                this.root = this.tutorialDoc.getDocumentElement();
            }
            this.getTutorialData();
            if (this.root != null) {
                NodeList steps = null;
                steps = this.root.getElementsByTagName("intro");
                Node introNode = steps.item(0);
                if (introNode != null) {
                    Step introstep = new Step(introNode, this.flasher, this);
                    introstep.setType(1);
                    this.introDescription = introstep.getDescription();
                    if (!this.suppressIntro) {
                        this.steplist.add(introstep);
                    }
                }
                steps = this.root.getElementsByTagName("step");
                steps.item(0);
                int i = 0;
                while (i < steps.getLength()) {
                    this.steplist.add(new Step(steps.item(i), this.flasher, this));
                    ++i;
                }
                steps = this.root.getElementsByTagName("conclusion");
                Node conclusionNode = steps.item(0);
                if (conclusionNode != null) {
                    Step conclusionstep = new Step(conclusionNode, this.flasher, this);
                    conclusionstep.setType(2);
                    this.steplist.add(conclusionstep);
                }
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    private void getTutorialData() {
        NamedNodeMap lrattributes;
        NamedNodeMap lrattributes2;
        NamedNodeMap lrattributes3;
        NodeList titles;
        Node titleitem;
        NodeList exlanguageressources;
        Node exlanguageressourceitem;
        String languagefile;
        Node lrfileitem;
        NamedNodeMap lrattributes4;
        if (this.root == null) {
            return;
        }
        this.externalResourceBundles.clear();
        NodeList languageressources = this.root.getElementsByTagName("languageresource");
        Node languageressourceitem = languageressources.item(0);
        if (languageressourceitem != null && (lrattributes4 = languageressourceitem.getAttributes()) != null && (lrfileitem = lrattributes4.getNamedItem("file")) != null && (languagefile = lrfileitem.getTextContent().trim()) != null) {
            Locale locale = Locale.getDefault();
            this.languageResource = new Properties();
            InputStream res = this.store.getResource(String.valueOf(languagefile) + "_" + locale.getLanguage().toLowerCase() + ".properties");
            if (res != null) {
                try {
                    this.languageResource.load(res);
                }
                catch (IOException e) {
                    this.languageResource = null;
                    res = null;
                    e.printStackTrace();
                }
            }
            if (res == null && (res = this.store.getResource(String.valueOf(languagefile) + ".properties")) != null) {
                try {
                    this.languageResource.load(res);
                }
                catch (IOException e) {
                    this.languageResource = null;
                    e.printStackTrace();
                }
            }
        }
        if ((exlanguageressourceitem = (exlanguageressources = this.root.getElementsByTagName("externallanguageresource")).item(0)) != null) {
            int ex = 0;
            while (ex < exlanguageressources.getLength()) {
                String languagefile2;
                Node lrfileitem2;
                exlanguageressourceitem = exlanguageressources.item(ex);
                NamedNodeMap lrattributes5 = exlanguageressourceitem.getAttributes();
                if (lrattributes5 != null && (lrfileitem2 = lrattributes5.getNamedItem("file")) != null && (languagefile2 = lrfileitem2.getTextContent().trim()) != null) {
                    try {
                        this.externalResourceBundles.add(ResourceBundle.getBundle(languagefile2));
                    }
                    catch (MissingResourceException e) {
                        System.out.println(e.getMessage());
                    }
                }
                ++ex;
            }
        }
        if ((titleitem = (titles = this.root.getElementsByTagName("title")).item(0)) != null) {
            this.title = titleitem.getTextContent().trim();
            if (this.title.startsWith("$")) {
                this.title = this.getMsg(this.title, titleitem);
            }
        }
        int red = 255;
        int green = 0;
        int blue = 0;
        int alpha = 128;
        NodeList flashcolors = this.root.getElementsByTagName("flashcolor");
        Node flashcoloritem = flashcolors.item(0);
        if (flashcoloritem != null && (lrattributes3 = flashcoloritem.getAttributes()) != null) {
            Node lrfileitem3 = lrattributes3.getNamedItem("r");
            if (lrfileitem3 != null) {
                red = Integer.parseInt(lrfileitem3.getTextContent().trim());
            }
            if ((lrfileitem3 = lrattributes3.getNamedItem("g")) != null) {
                green = Integer.parseInt(lrfileitem3.getTextContent().trim());
            }
            if ((lrfileitem3 = lrattributes3.getNamedItem("b")) != null) {
                blue = Integer.parseInt(lrfileitem3.getTextContent().trim());
            }
            if ((lrfileitem3 = lrattributes3.getNamedItem("a")) != null) {
                alpha = Integer.parseInt(lrfileitem3.getTextContent().trim());
            }
        }
        this.flasher.setColor(new Color(red, green, blue, alpha));
        int width = 400;
        int height = 300;
        NodeList sizes = this.root.getElementsByTagName("size");
        Node sizeitem = sizes.item(0);
        if (sizeitem != null && (lrattributes2 = sizeitem.getAttributes()) != null) {
            Node lrfileitem4 = lrattributes2.getNamedItem("width");
            if (lrfileitem4 != null) {
                width = Integer.parseInt(lrfileitem4.getTextContent().trim());
            }
            if ((lrfileitem4 = lrattributes2.getNamedItem("height")) != null) {
                height = Integer.parseInt(lrfileitem4.getTextContent().trim());
            }
        }
        this.initialSize = new Dimension(width, height);
        this.margin = new Insets(0, 0, 0, 0);
        NodeList locations = this.root.getElementsByTagName("location");
        Node locationitem = locations.item(0);
        if (locationitem != null && (lrattributes = locationitem.getAttributes()) != null) {
            String tinsets;
            String[] split;
            Node ninsets;
            Node horizontal;
            Node vertical = lrattributes.getNamedItem("vertical");
            if (vertical != null) {
                this.locvert = vertical.getTextContent().trim();
            }
            if ((horizontal = lrattributes.getNamedItem("horizontal")) != null) {
                this.lochoriz = horizontal.getTextContent().trim();
            }
            if ((ninsets = lrattributes.getNamedItem("margin")) != null && (split = (tinsets = ninsets.getTextContent().trim()).split(",")).length == 4) {
                try {
                    this.margin = new Insets(Integer.parseInt(split[0].trim()), Integer.parseInt(split[1].trim()), Integer.parseInt(split[2].trim()), Integer.parseInt(split[3].trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public void nextStep() {
        if (this.steplist == null) {
            this.currentStep = null;
            this.notifyListener();
            return;
        }
        ++this.currentIndex;
        if (this.steplist.size() <= this.currentIndex) {
            this.currentStep = null;
            this.notifyListener();
            return;
        }
        this.currentStep = this.steplist.get(this.currentIndex);
        this.currentStep.setStarted();
        this.notifyListener();
    }

    public void notifyListener() {
        for (StepChangedListener li : this.listeners) {
            li.stepChanged(this.currentStep);
        }
    }

    public void stop() {
        this.currentIndex = -1;
        this.currentStep = null;
        this.flasher.stopFlasher();
        this.notifyListener();
    }

    public void restart(boolean suppressIntroFlag) {
        this.flasher.stopFlasher();
        this.currentIndex = -1;
        this.steplist.clear();
        this.suppressIntro = suppressIntroFlag;
        this.parseTutorial(this.store.getResource("tutorial.xml"));
    }

    public Step getCurrentStep() {
        return this.currentStep;
    }

    public void addStepChangedListener(StepChangedListener li) {
        this.listeners.add(li);
    }

    public String getMsg(String key, Node textnode) {
        if (key == null) {
            return null;
        }
        if (key.startsWith("$")) {
            key = key.substring(1);
        }
        if (this.languageResource == null) {
            return "::" + key + "::";
        }
        String text = null;
        Object obj = this.languageResource.get(key);
        if (obj != null) {
            text = obj.toString();
        }
        if (text == null && this.externalResourceBundles.size() > 0) {
            for (ResourceBundle extRes : this.externalResourceBundles) {
                try {
                    text = extRes.getString(key);
                    if (text == null) continue;
                    break;
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
        }
        if (text == null) {
            return "::" + key + "::";
        }
        if (textnode != null) {
            NodeList childNodes = textnode.getChildNodes();
            int count = 0;
            int i = 0;
            while (i < childNodes.getLength()) {
                Node item = childNodes.item(i);
                if (item.getNodeName().equalsIgnoreCase("param")) {
                    String content = this.getNodeContent(item).trim();
                    if (content.startsWith("$")) {
                        content = this.getMsg(content, item);
                    }
                    text = text.replaceAll("\\{" + count + "\\}", content);
                    ++count;
                }
                ++i;
            }
        }
        return text;
    }

    public String getNodeContent(Node node) {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node item = childNodes.item(i);
            if (item.getNodeType() == 3) {
                return item.getNodeValue();
            }
            ++i;
        }
        return node.getTextContent();
    }

    @Override
    public int compareTo(Tutorial o) {
        return (this.getTitle() == null ? "" : this.getTitle()).compareTo(o == null ? "" : o.getTitle());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tutorial) {
            return ((Tutorial)obj).getTitle().equals(this.getTitle());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.getTitle();
    }

    public void addExternalResourceBundle(ResourceBundle externalResourceBundle) {
        this.externalResourceBundles.add(externalResourceBundle);
    }

    public AbstractStore getStore() {
        return this.store;
    }
}

