/*
 * Decompiled with CFR 0.152.
 */
package de.anormalmedia.sbstutorial.gui.recorder;

import de.anormalmedia.sbstutorial.gui.recorder.ComponentTree;
import de.anormalmedia.sbstutorial.gui.recorder.MethodList;
import de.anormalmedia.sbstutorial.gui.recorder.ResourcePane;
import de.anormalmedia.sbstutorial.gui.recorder.XMLPanel;
import de.anormalmedia.sbstutorial.gui.selector.TutorialSelector;
import de.anormalmedia.sbstutorial.gui.step.TutorialStepFrame;
import de.anormalmedia.sbstutorial.interfaces.IEventNotifier;
import de.anormalmedia.sbstutorial.listener.EventRecorderListener;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.TextEvent;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class EventRecorder
extends JFrame
implements IEventNotifier {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private Vector<Class<?>> eventclasses = new Vector();
    private Vector<String> cols = new Vector();
    private Vector<AWTEvent> events = new Vector();
    private EventRecorderListener eventRecorderListener;
    private XMLPanel xmlpanel;
    private MethodList methodList;
    private ComponentTree componentTree;
    private ResourcePane resourcepane;
    private JButton xmlbut;
    private JToggleButton btrec;

    public EventRecorder() {
        super("EventRecorder");
        this.setDefaultCloseOperation(2);
        JPanel content = (JPanel)this.getContentPane();
        content.setLayout(new BorderLayout());
        this.table = new JTable();
        this.cols.add("Event");
        this.cols.add("Component name");
        this.cols.add("Component class");
        this.cols.add("Event details");
        EventModel model = new EventModel(this.events, this.cols);
        this.table.setModel(model);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    EventRecorder.this.xmlbut.doClick();
                } else if (e.getClickCount() == 1 && EventRecorder.this.table.getSelectedRowCount() == 1) {
                    AWTEvent curevent = (AWTEvent)EventRecorder.this.events.get(EventRecorder.this.table.getSelectedRow());
                    EventRecorder.this.methodList.listMethods(curevent);
                    EventRecorder.this.componentTree.listComponents(curevent);
                }
            }
        });
        JPanel xmlAndDetails = new JPanel(new BorderLayout());
        final JSplitPane dsp = new JSplitPane(1);
        xmlAndDetails.add((Component)dsp, "Center");
        final JSplitPane sp = new JSplitPane(0);
        sp.setTopComponent(new JScrollPane(this.table));
        sp.setBottomComponent(xmlAndDetails);
        content.add((Component)sp, "Center");
        this.xmlpanel = new XMLPanel();
        dsp.setLeftComponent(this.xmlpanel);
        JTabbedPane tp = new JTabbedPane();
        this.methodList = new MethodList(this.xmlpanel);
        tp.add("Component Method List", this.methodList);
        this.componentTree = new ComponentTree();
        tp.add("Component Parent Tree", this.componentTree);
        this.resourcepane = new ResourcePane(this.xmlpanel);
        tp.add("Language Resources", this.resourcepane);
        dsp.setRightComponent(tp);
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        this.addButtons(tb);
        content.add((Component)tb, "North");
        this.eventRecorderListener = new EventRecorderListener();
        this.eventRecorderListener.startListener(this);
        this.setSize(800, 600);
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                sp.setDividerLocation(0.6);
                dsp.setDividerLocation(0.7);
            }
        });
    }

    private void addButtons(JToolBar tb) {
        this.btrec = new JToggleButton("Record");
        this.btrec.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent ae) {
                EventRecorder.this.eventRecorderListener.eventDispatched(new KeyEvent((Component)ae.getSource(), 402, System.currentTimeMillis(), 0, 122, '\u0000'));
            }
        });
        tb.add(this.btrec);
        this.xmlbut = new JButton("insert xml");
        this.xmlbut.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent ae) {
                if (EventRecorder.this.table.getSelectedRowCount() == 1) {
                    AWTEvent curevent = (AWTEvent)EventRecorder.this.events.get(EventRecorder.this.table.getSelectedRow());
                    EventRecorder.this.xmlpanel.insertEvent(curevent);
                }
            }
        });
        tb.add(this.xmlbut);
        JButton but = new JButton("clear");
        but.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent ae) {
                EventRecorder.this.events.clear();
                DefaultTableModel model = (DefaultTableModel)EventRecorder.this.table.getModel();
                model.fireTableDataChanged();
            }
        });
        tb.add(but);
        HashMap<String, Class> defaults = new HashMap<String, Class>();
        defaults.put(MouseEvent.class.getSimpleName(), MouseEvent.class);
        defaults.put(KeyEvent.class.getSimpleName(), KeyEvent.class);
        defaults.put(FocusEvent.class.getSimpleName(), FocusEvent.class);
        defaults.put(WindowEvent.class.getSimpleName(), WindowEvent.class);
        defaults.put(ActionEvent.class.getSimpleName(), ActionEvent.class);
        defaults.put(ItemEvent.class.getSimpleName(), ItemEvent.class);
        defaults.put(TextEvent.class.getSimpleName(), TextEvent.class);
        defaults.put(MouseWheelEvent.class.getSimpleName(), MouseWheelEvent.class);
        TreeMap<String, Class<MouseWheelEvent>> bts = new TreeMap<String, Class<MouseWheelEvent>>();
        bts.put(MouseEvent.class.getSimpleName(), MouseEvent.class);
        bts.put(KeyEvent.class.getSimpleName(), KeyEvent.class);
        bts.put(ComponentEvent.class.getSimpleName(), ComponentEvent.class);
        bts.put(FocusEvent.class.getSimpleName(), FocusEvent.class);
        bts.put(WindowEvent.class.getSimpleName(), WindowEvent.class);
        bts.put(ActionEvent.class.getSimpleName(), ActionEvent.class);
        bts.put(ItemEvent.class.getSimpleName(), ItemEvent.class);
        bts.put(TextEvent.class.getSimpleName(), TextEvent.class);
        bts.put(InputMethodEvent.class.getSimpleName(), InputMethodEvent.class);
        bts.put(InvocationEvent.class.getSimpleName(), InvocationEvent.class);
        bts.put(MouseWheelEvent.class.getSimpleName(), MouseWheelEvent.class);
        for (final Map.Entry e : bts.entrySet()) {
            JToggleButton bt = new JToggleButton(((String)e.getKey()).replace("Event", ""));
            bt.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent ae) {
                    if (((JToggleButton)ae.getSource()).isSelected()) {
                        if (!EventRecorder.this.eventclasses.contains(e.getValue())) {
                            EventRecorder.this.eventclasses.add((Class)e.getValue());
                        }
                    } else {
                        EventRecorder.this.eventclasses.remove(e.getValue());
                    }
                }
            });
            if (defaults.containsKey(e.getKey())) {
                bt.doClick();
            }
            tb.add(bt);
        }
    }

    public void eventOccurred(AWTEvent event) {
        KeyEvent kevent;
        if (event instanceof KeyEvent && (kevent = (KeyEvent)event).getID() == 402 && kevent.getKeyCode() == 122) {
            this.btrec.setSelected(this.eventRecorderListener.isStarted());
            return;
        }
        if (!this.eventclasses.contains(event.getClass())) {
            return;
        }
        Object source = event.getSource();
        if (source != null) {
            Window windowAncestor;
            if (source instanceof TutorialStepFrame || source instanceof EventRecorder || source instanceof TutorialSelector) {
                return;
            }
            if (source instanceof Component && (windowAncestor = SwingUtilities.getWindowAncestor((Component)source)) != null && (windowAncestor instanceof TutorialStepFrame || windowAncestor instanceof EventRecorder || windowAncestor instanceof TutorialSelector)) {
                return;
            }
        }
        this.events.add(event);
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.fireTableRowsInserted(model.getRowCount() - 1, model.getRowCount() - 1);
        this.table.getSelectionModel().setSelectionInterval(model.getRowCount() - 1, model.getRowCount() - 1);
        this.table.scrollRectToVisible(new Rectangle(0, this.table.getHeight(), 0, this.table.getHeight()));
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setSize(400, 300);
        f.setVisible(true);
        new EventRecorder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        public EventModel(Vector<AWTEvent> events, Vector<String> cols) {
            super(events, cols);
        }

        @Override
        public Object getValueAt(int row, int column) {
            AWTEvent e = (AWTEvent)this.dataVector.get(row);
            Object source = e.getSource();
            switch (column) {
                case 0: {
                    return e.paramString();
                }
                case 1: {
                    return source == null ? "<no source>" : (!(source instanceof Component) ? "<no comp>" : (((Component)source).getName() == null ? "<no name>" : ((Component)source).getName()));
                }
                case 2: {
                    return source == null ? "<no source>" : source.getClass().getName();
                }
                case 3: {
                    return e.toString();
                }
            }
            return super.getValueAt(row, column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column > 2;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
        }
    }
}

