/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing.widgets;

import com.inet.annotations.InternalApi;
import com.inet.lib.util.PreferencesUtils;
import com.inet.swing.IconCache;
import com.inet.swing.InetTitleLine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

@InternalApi
public class ExpandableComponent
extends JPanel {
    private static final String hQ = PreferencesUtils.getRelativePrefPath(ExpandableComponent.class) + "/expandablecomponent";
    private static final Preferences hR = PreferencesUtils.isUserReadable((String)hQ) ? PreferencesUtils.userRoot().node(hQ) : null;
    private static final boolean hS = PreferencesUtils.isUserWriteable((String)hQ);
    private static final Icon hT = IconCache.getIcon("navi_down.gif");
    private static final Icon hU = IconCache.getIcon("navi_right.gif");
    private JLabel bT;
    private JPanel hV;
    private Component hW;
    private Component hX;
    private String cK;
    private boolean hY;
    private MouseListener hZ = this.getMouseHandler();

    public ExpandableComponent() {
        this((String)null, true);
    }

    public ExpandableComponent(boolean expanded) {
        this((String)null, expanded);
    }

    public ExpandableComponent(String key) {
        this(key, true);
    }

    public ExpandableComponent(String key, boolean expanded) {
        super.setLayout(new a(5, 10));
        this.cK = key;
        this.hY = key == null || hR == null ? expanded : hR.getBoolean(key, expanded);
        this.bT = new JLabel(this.getIcon());
        this.hV = new JPanel(new BorderLayout(5, 10));
        this.hX = Box.createHorizontalStrut(this.bT.getPreferredSize().width);
        this.add((Component)this.hV, "North");
        this.hV.add((Component)this.bT, "West");
        this.add(this.hX, "West");
        this.bT.addMouseListener(this.getMouseHandler());
        this.bT.setCursor(Cursor.getPredefinedCursor(12));
    }

    private Icon getIcon() {
        return this.isExpanded() ? hT : hU;
    }

    public void addTitle(Component comp) {
        if (comp instanceof InetTitleLine) {
            JLabel jLabel = ((InetTitleLine)comp).getTextLabel();
            jLabel.addMouseListener(this.getMouseHandler());
            jLabel.setCursor(Cursor.getPredefinedCursor(12));
        }
        this.add(comp, "North");
    }

    public Component getTitle() {
        return ((BorderLayout)this.hV.getLayout()).getLayoutComponent("Center");
    }

    public JLabel getExpandLabel() {
        return this.bT;
    }

    public void addContent(Component comp) {
        this.add(comp, "Center");
    }

    public Component getContent() {
        return this.hW;
    }

    public void setExpanded(boolean b2) {
        if (this.hY != b2) {
            this.hY = b2;
            this.hX.setVisible(b2);
            if (this.hW != null) {
                this.hW.setVisible(b2);
            }
            this.bT.setIcon(this.getIcon());
            this.revalidate();
            this.repaint();
        }
    }

    public MouseListener getMouseHandler() {
        if (this.hZ == null) {
            this.hZ = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e2) {
                    ExpandableComponent.this.setExpanded(!ExpandableComponent.this.isExpanded());
                    if (ExpandableComponent.this.cK != null && hR != null && hS) {
                        hR.putBoolean(ExpandableComponent.this.cK, ExpandableComponent.this.isExpanded());
                    }
                }
            };
        }
        return this.hZ;
    }

    public boolean isExpanded() {
        return this.hY;
    }

    @Override
    public final void setLayout(LayoutManager mgr) {
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
    }

    private class a
    extends BorderLayout {
        public a(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            if (constraints instanceof String) {
                if (constraints.equals("North")) {
                    if (comp == ExpandableComponent.this.hV) {
                        super.addLayoutComponent(comp, constraints);
                    } else {
                        ExpandableComponent.this.hV.add(comp, "Center");
                    }
                } else if (constraints.equals("Center")) {
                    ExpandableComponent.this.hW = comp;
                    super.addLayoutComponent(comp, constraints);
                    comp.setVisible(ExpandableComponent.this.isExpanded());
                } else if (constraints.equals("West")) {
                    ExpandableComponent.this.hX = comp;
                    super.addLayoutComponent(comp, constraints);
                    comp.setVisible(ExpandableComponent.this.isExpanded());
                }
            }
        }
    }
}

