/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing;

import com.inet.annotations.InternalApi;
import com.inet.swing.IconCache;
import com.inet.swing.SwingFunctions;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

@InternalApi
public final class InetLookAndFeel {
    public static final int ILNF_MARGIN = 10;
    public static final int ILNF_GAP = 10;
    public static final int ILNF_GAPDEPENDENT = 20;
    public static final Color ILNF_GRADIENTCOLOR = new Color(155, 175, 220);
    public static final Color ILNF_DEFAULTBACKGROUND;
    public static final Color ILNF_BUTTON_DISABLED_COLOR;
    public static final Color ILNF_BUTTON_COLOR;
    public static final Color ILNF_BUTTON_ROLLOVER_COLOR;
    public static final Color ILNF_BUTTON_FOCUSED_COLOR;
    public static final Color ILNF_BUTTON_PRESSED_COLOR;

    public static void paintTitleGradient(Graphics g2, int x, int y, int w, int h2) {
        Graphics2D graphics2D = (Graphics2D)g2;
        InetLookAndFeel.paintGradient(g2, ILNF_GRADIENTCOLOR, x, y, w, h2);
        graphics2D.setPaint(new GradientPaint((int)((double)x - 0.2 * (double)w), y, Color.WHITE, (int)((double)x + 1.1 * (double)w), y, new Color(255, 255, 255, 0)));
        graphics2D.fillRect(x, y, w, h2);
        ImageIcon imageIcon = IconCache.getIcon("title_image.png");
        graphics2D.drawImage(imageIcon.getImage(), x + w - imageIcon.getIconWidth(), y, null);
    }

    public static void paintGradient(Graphics g2, Color color, int x, int y, int w, int h2) {
        Graphics2D graphics2D = (Graphics2D)g2;
        graphics2D.setPaint(new GradientPaint(x, (int)((double)y - 0.1 * (double)h2), Color.WHITE, x, (int)((double)y + 1.2 * (double)h2), color));
        graphics2D.fillRect(x, y, w, h2);
        graphics2D.setPaint(new GradientPaint(x, (int)((double)y + 0.65 * (double)h2), color, x, (int)((double)y + 1.3 * (double)h2), Color.WHITE));
        graphics2D.fillRect(x, (int)((double)y + 0.65 * (double)h2), w, (int)((double)h2 - 0.65 * (double)h2));
    }

    public static void paintGradient(Graphics g2, Color color1, Color color2, int x, int y, int w, int h2) {
        Graphics2D graphics2D = (Graphics2D)g2;
        graphics2D.setPaint(new GradientPaint(x, (int)((double)y - 0.1 * (double)h2), color2, x, (int)((double)y + 1.2 * (double)h2), color1));
        graphics2D.fillRect(x, y, w, h2);
        graphics2D.setPaint(new GradientPaint(x, (int)((double)y + 0.65 * (double)h2), color1, x, (int)((double)y + 1.3 * (double)h2), color2));
        graphics2D.fillRect(x, (int)((double)y + 0.65 * (double)h2), w, (int)((double)h2 - 0.65 * (double)h2));
    }

    public static Image getImage(String key) {
        if (key == null || key.length() == 0) {
            return null;
        }
        URL uRL = InetLookAndFeel.class.getResource("/com/inet/lib/images/" + key);
        return Toolkit.getDefaultToolkit().getImage(uRL);
    }

    public static JButton createRolloverButton(Action action) {
        JButton jButton = new JButton(action);
        jButton.setRolloverEnabled(true);
        jButton.setBorder(SwingFunctions.createRolloverBorder());
        jButton.setFocusPainted(false);
        return jButton;
    }

    public static JButton createScrollButton(final Action action) {
        JButton jButton = InetLookAndFeel.createRolloverButton(action);
        jButton.addMouseListener(new MouseAdapter(){
            private boolean V = false;
            private Timer W = null;

            @Override
            public void mousePressed(MouseEvent e2) {
                if (this.V) {
                    return;
                }
                this.V = true;
                this.W = new Timer(100, action);
                this.W.start();
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (this.W != null) {
                    this.W.stop();
                }
                this.V = false;
            }
        });
        return jButton;
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            final Frame frame = new Frame();
            frame.addNotify();
            ILNF_DEFAULTBACKGROUND = frame.getBackground();
            if (!EventQueue.isDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        frame.dispose();
                    }
                });
            } else {
                frame.dispose();
            }
        } else {
            ILNF_DEFAULTBACKGROUND = Color.LIGHT_GRAY;
        }
        ILNF_BUTTON_DISABLED_COLOR = new Color(185, 185, 185);
        ILNF_BUTTON_COLOR = new Color(155, 175, 220);
        ILNF_BUTTON_ROLLOVER_COLOR = new Color(247, 211, 146);
        ILNF_BUTTON_FOCUSED_COLOR = new Color(117, 140, 193);
        ILNF_BUTTON_PRESSED_COLOR = new Color(230, 183, 94);
    }
}

