/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.loader;

import com.inet.annotations.InternalApi;
import com.inet.shared.loader.c;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.CertPath;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.SwingUtilities;

@InternalApi
public class AsynURLClassLoader
extends SecureClassLoader {
    private static final AllPermission k = new AllPermission();
    private static final RuntimePermission l = new RuntimePermission("modifyThreadGroup");
    private static final RuntimePermission m = new RuntimePermission("modifyThread");
    private static final RuntimePermission n = new RuntimePermission("setContextClassLoader");
    private ArrayList<String> o;
    private boolean p;
    private URL q;
    private final Properties r = new Properties();
    private boolean s;
    private boolean t;
    private final ConcurrentHashMap<String, InetAddress[]> u = new ConcurrentHashMap();
    private final String v;
    private final ConcurrentHashMap<URL, JarFile> w = new ConcurrentHashMap();
    private final Hashtable<String, URL> x = new Hashtable();
    private final long y = System.nanoTime();
    private final ProtectionDomain z;
    private final PermissionCollection A;
    private final HashSet<String> B = new HashSet();
    private final boolean C;
    private final com.inet.shared.loader.a D;
    private final ClassLoader E;

    public AsynURLClassLoader(String packageListFile, com.inet.shared.loader.a asyncProgressListener) {
        super(AsynURLClassLoader.g());
        this.D = asyncProgressListener;
        try {
            CodeSigner[] codeSignerArray;
            Class<?> clazz = this.getClass();
            InputStream inputStream = clazz.getResourceAsStream(packageListFile);
            if (inputStream == null) {
                System.err.println("packages.lst not found.");
            } else {
                this.r.load(inputStream);
            }
            this.z = clazz.getProtectionDomain();
            this.A = new Permissions();
            Object object = this.z.getPermissions().elements();
            while (object.hasMoreElements()) {
                this.A.add(object.nextElement());
            }
            this.A.add(new PropertyPermission("*", "read,write"));
            while (clazz != null) {
                object = clazz.getName();
                this.B.add(((String)object).substring(0, ((String)object).lastIndexOf(46)));
                if (clazz == AsynURLClassLoader.class) break;
                clazz = clazz.getSuperclass();
            }
            this.C = (codeSignerArray = ((CodeSource)(object = this.z.getCodeSource())).getCodeSigners()) == null || codeSignerArray.length == 0;
            this.p = Boolean.getBoolean("jnlp.classloader.debug");
            String string = ((CodeSource)object).getLocation().getHost();
            if (string != null) {
                this.e(string);
            }
            this.v = InetAddress.getLocalHost().getHostName();
            this.setContextClassLoader();
            try {
                this.a(asyncProgressListener);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.E = this.getParent();
            if (this.p) {
                System.out.println("Permissions: " + String.valueOf(this.A));
            }
        }
        catch (Exception exception) {
            ExceptionInInitializerError exceptionInInitializerError = new ExceptionInInitializerError(exception);
            throw exceptionInInitializerError;
        }
    }

    private static ClassLoader g() {
        ClassLoader classLoader = AsynURLClassLoader.class.getClassLoader();
        if (classLoader == null) {
            classLoader = AsynURLClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public void setContextClassLoader() {
        if (this.p) {
            System.out.println(this.i() + " start setContextClassLoader");
        }
        this.a(Thread.currentThread());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AsynURLClassLoader.this.a(Thread.currentThread());
            }
        });
        Thread[] threadArray = new Thread[Thread.activeCount() * 2];
        int n = Thread.enumerate(threadArray);
        if (this.p) {
            System.out.println(this.i() + " setContextClassLoader thread counts: " + n + " " + threadArray.length);
        }
        for (Thread thread : threadArray) {
            if (thread == null) continue;
            this.a(thread);
        }
        if (this.p) {
            System.out.println(this.i() + " end setContextClassLoader");
        }
    }

    private void a(Thread thread) {
        thread.setContextClassLoader(this);
        if (this.p) {
            System.out.println("setContextClassLoader:" + thread.getName());
        }
    }

    private void a(com.inet.shared.loader.a a2) {
        c.b(a2);
    }

    public void setDebug(boolean debug) {
        this.p = debug;
    }

    public void setPreLoadedJarFiles(ArrayList<String> preLoadedJarFiles) {
        this.o = preLoadedJarFiles;
    }

    public void setBaseURL(URL base) {
        if (base == null) {
            throw new NullPointerException("Base URL is null.");
        }
        boolean bl = this.q == null;
        this.q = base;
        if (bl) {
            this.h();
        }
    }

    private void h() {
        this.t = true;
        Thread thread = new Thread((Runnable)new a(), "Asyn ClassLoader");
        thread.setPriority(5);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUrl(URL url) {
        if (!url.getPath().endsWith(".jar") && !url.getPath().endsWith(".zip")) {
            return;
        }
        Hashtable<String, URL> hashtable = this.x;
        synchronized (hashtable) {
            this.x.put(url.toString(), url);
            this.s = true;
            if (!this.t) {
                this.h();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getUrls() {
        Hashtable<String, URL> hashtable = this.x;
        synchronized (hashtable) {
            return this.x.values().toArray(new URL[this.x.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackage(String packageName, String jarFile) {
        Hashtable<String, URL> hashtable = this.x;
        synchronized (hashtable) {
            this.r.setProperty(packageName, jarFile);
            this.s = true;
            if (!this.t) {
                this.h();
            }
        }
        if (this.p) {
            System.out.println("adding package: " + packageName + " for jar file " + jarFile);
        }
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        try {
            Object object;
            Object object2;
            Object object3;
            String string;
            int n = className.lastIndexOf(46);
            String string2 = string = n < 0 ? "" : className.substring(0, className.lastIndexOf(46));
            if (this.B.contains(string)) {
                try {
                    return this.getClass().getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            String string3 = className.replace('.', '/').concat(".class");
            String string4 = this.r.getProperty(string);
            if (string4 == null) {
                object3 = this.w.entrySet();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    JarFile jarFile = (JarFile)object.getValue();
                    JarEntry jarEntry = (JarEntry)jarFile.getEntry(string3);
                    if (jarEntry == null) continue;
                    return this.a((URL)object.getKey(), jarFile, jarEntry, className);
                }
                string4 = this.b(string);
                if (string4 == null) {
                    return super.findClass(className);
                }
            }
            if ((object = (JarEntry)((JarFile)(object2 = this.c((URL)(object3 = this.d(string4))))).getEntry(string3)) == null) {
                throw new ClassNotFoundException(className + " in " + string4);
            }
            return this.a((URL)object3, (JarFile)object2, (JarEntry)object, className);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(className, iOException);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            try {
                clazz = this.E.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    protected URL findResource(String fileName) {
        try {
            int n = fileName.lastIndexOf(47);
            String string = n < 0 ? "" : fileName.substring(0, fileName.lastIndexOf(47)).replace('/', '.');
            String string2 = this.b(string);
            if (string2 == null) {
                return this.c(fileName);
            }
            URL uRL = this.d(string2);
            JarFile jarFile = this.c(uRL);
            JarEntry jarEntry = (JarEntry)jarFile.getEntry(fileName);
            if (jarEntry == null) {
                return this.c(fileName);
            }
            return this.a(String.valueOf(uRL) + "!/" + fileName, jarFile);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    private URL a(String string, JarFile jarFile) throws MalformedURLException {
        return new URL("jar", "", -1, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String b(String string) {
        String string2;
        int n;
        String string3 = this.r.getProperty(string);
        if (string3 == null && (n = string.lastIndexOf(46)) > 0 && (string3 = this.b(string2 = string.substring(0, n))) != null) {
            Hashtable<String, URL> hashtable = this.x;
            synchronized (hashtable) {
                this.r.setProperty(string, string3);
            }
            if (this.p) {
                System.out.println("determined package: " + string + " for jar file " + string3);
            }
        }
        return string3;
    }

    private URL c(String string) throws MalformedURLException {
        Set<Map.Entry<URL, JarFile>> set = this.w.entrySet();
        for (Map.Entry<URL, JarFile> entry : set) {
            JarFile jarFile = entry.getValue();
            JarEntry jarEntry = (JarEntry)jarFile.getEntry(string);
            if (jarEntry == null) continue;
            return this.a(String.valueOf(entry.getKey()) + "!/" + string, jarFile);
        }
        return super.findResource(string);
    }

    @Override
    protected Enumeration<URL> findResources(final String name) throws IOException {
        return new Enumeration<URL>(){
            private URL G;
            private Enumeration<URL> H;
            private Enumeration<URL> I;
            {
                this.H = AsynURLClassLoader.super.findResources(name);
                this.I = AsynURLClassLoader.this.w.keys();
            }

            @Override
            public boolean hasMoreElements() {
                if (this.G != null) {
                    return true;
                }
                if (this.H != null) {
                    if (this.H.hasMoreElements()) {
                        this.G = this.H.nextElement();
                        return true;
                    }
                    this.H = null;
                }
                while (this.I.hasMoreElements()) {
                    URL uRL = this.I.nextElement();
                    JarFile jarFile = AsynURLClassLoader.this.w.get(uRL);
                    JarEntry jarEntry = (JarEntry)jarFile.getEntry(name);
                    if (jarEntry == null) continue;
                    try {
                        this.G = AsynURLClassLoader.this.a(String.valueOf(uRL) + "!/" + name, jarFile);
                        return true;
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                }
                return false;
            }

            public URL j() {
                if (this.hasMoreElements()) {
                    URL uRL = this.G;
                    this.G = null;
                    return uRL;
                }
                throw new NoSuchElementException();
            }

            @Override
            public /* synthetic */ Object nextElement() {
                return this.j();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL d(String string) throws MalformedURLException {
        Hashtable<String, URL> hashtable = this.x;
        synchronized (hashtable) {
            URL uRL = this.x.get(string);
            if (uRL == null) {
                uRL = new URL(this.q, string);
                String string2 = uRL.toString();
                URL uRL2 = this.x.get(string2);
                if (uRL2 == null) {
                    this.x.put(string2, uRL);
                } else {
                    uRL = uRL2;
                }
                this.x.put(string, uRL);
            }
            return uRL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarFile c(URL uRL) throws IOException {
        URL uRL2 = uRL;
        synchronized (uRL2) {
            JarFile jarFile = this.w.get(uRL);
            if (jarFile == null) {
                try {
                    uRL = new URL(uRL, "");
                    if (this.D != null) {
                        this.D.d(uRL);
                    }
                    if (this.p) {
                        new Exception(String.valueOf(uRL) + ": " + this.i() + "  " + Thread.activeCount()).printStackTrace(System.out);
                    }
                    URL uRL3 = new URL("jar", "", -1, String.valueOf(uRL) + "!/");
                    URLConnection uRLConnection = uRL3.openConnection();
                    jarFile = ((JarURLConnection)uRLConnection).getJarFile();
                    this.w.put(uRL, jarFile);
                    if (this.D != null) {
                        this.D.e(uRL);
                    }
                }
                finally {
                    System.out.println(String.valueOf(uRL) + ": " + this.i() + "  " + Thread.activeCount());
                }
            }
            return jarFile;
        }
    }

    private double i() {
        return (double)(System.nanoTime() - this.y) / 1000000.0;
    }

    private Class<?> a(URL uRL, JarFile jarFile, JarEntry jarEntry, String string) throws IOException {
        this.a(uRL, jarFile, string);
        byte[] byArray = this.a(jarFile, jarEntry);
        CodeSigner[] codeSignerArray = jarEntry.getCodeSigners();
        if (codeSignerArray == null && this.p) {
            System.out.println("Signers is null: " + string + " " + String.valueOf(jarFile.getManifest()));
        }
        CodeSource codeSource = new CodeSource(uRL, codeSignerArray);
        if (this.p) {
            System.out.println(string + ": " + this.i() + "  " + Thread.activeCount() + " " + String.valueOf(codeSignerArray));
        }
        try {
            return this.defineClass(string, byArray, 0, byArray.length, codeSource);
        }
        catch (LinkageError linkageError) {
            if (linkageError.getClass() == LinkageError.class) {
                Class<?> clazz;
                if (this.p) {
                    linkageError.printStackTrace(System.out);
                }
                if ((clazz = this.findLoadedClass(string)) != null) {
                    return clazz;
                }
            }
            throw linkageError;
        }
    }

    private byte[] a(JarFile jarFile, JarEntry jarEntry) throws IOException {
        InputStream inputStream = jarFile.getInputStream(jarEntry);
        byte[] byArray = new byte[(int)jarEntry.getSize()];
        new DataInputStream(inputStream).readFully(byArray);
        inputStream.close();
        return byArray;
    }

    private void a(final URL uRL, final JarFile jarFile, final String string) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    int n = string.lastIndexOf(46);
                    String string2 = n < 0 ? "" : string.substring(0, n);
                    Package package_ = AsynURLClassLoader.this.getPackage(string2);
                    Manifest manifest = jarFile.getManifest();
                    if (package_ != null) {
                        if (package_.isSealed()) {
                            if (!package_.isSealed(uRL)) {
                                throw new SecurityException("sealing violation: package " + string2 + " is sealed");
                            }
                        } else if (manifest != null && AsynURLClassLoader.this.a(string2, manifest)) {
                            throw new SecurityException("sealing violation: can't seal package " + string2 + ": already loaded");
                        }
                    } else if (manifest != null) {
                        AsynURLClassLoader.this.a(string2, manifest, uRL);
                    } else {
                        if (AsynURLClassLoader.this.p) {
                            System.out.println("Manifest is null: " + String.valueOf(uRL) + " " + String.valueOf(jarFile));
                        }
                        AsynURLClassLoader.this.definePackage(string2, null, null, null, null, null, null, null);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            IOException iOException = new IOException(throwable.getMessage());
            iOException.initCause(privilegedActionException);
            throw iOException;
        }
    }

    protected Package a(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string9)) {
            uRL2 = uRL;
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL2);
    }

    private boolean a(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        String string;
        Object object;
        try {
            boolean bl = this.C ? (object = codesource.getCodeSigners()) != null && ((CodeSigner[])object).length > 0 : this.a(codesource, this.z.getCodeSource());
            if (this.p) {
                System.out.println("Permissions: " + bl + " for " + String.valueOf(codesource.getLocation()));
            }
            if (bl) {
                return this.A;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        PermissionCollection permissionCollection = super.getPermissions(codesource);
        object = codesource.getLocation();
        if ("file".equals(((URL)object).getProtocol())) {
            permissionCollection.add(k);
        }
        if ((string = ((URL)object).getHost()) != null) {
            permissionCollection.add(new SocketPermission(string, "connect,accept"));
            InetAddress[] inetAddressArray = this.e(string);
            for (InetAddress inetAddress : inetAddressArray) {
                permissionCollection.add(new SocketPermission(inetAddress.getHostAddress(), "connect,accept"));
            }
            permissionCollection.add(new SocketPermission(this.v, "resolve"));
            try {
                Class<?> clazz = Class.forName("java.net.URLPermission");
                Constructor constructor = clazz.getConstructor(String.class);
                String string2 = ((URL)object).getProtocol();
                int n = ((URL)object).getPort() != -1 ? ((URL)object).getPort() : ((URL)object).getDefaultPort();
                permissionCollection.add((Permission)constructor.newInstance(string2 + "://" + string + ":" + n + "/-"));
                permissionCollection.add((Permission)constructor.newInstance(string2 + "://" + string + ":" + n));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        permissionCollection.add(l);
        permissionCollection.add(m);
        permissionCollection.add(n);
        if (this.p) {
            System.out.println("Permissions: " + String.valueOf(object) + " " + String.valueOf(permissionCollection));
        }
        return permissionCollection;
    }

    private InetAddress[] e(String string) {
        try {
            InetAddress[] inetAddressArray = this.u.get(string);
            if (inetAddressArray == null) {
                inetAddressArray = InetAddress.getAllByName(string);
                this.u.put(string, inetAddressArray);
            }
            return inetAddressArray;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return new InetAddress[0];
        }
    }

    private boolean a(CodeSource codeSource, CodeSource codeSource2) {
        CodeSigner[] codeSignerArray = codeSource.getCodeSigners();
        CodeSigner[] codeSignerArray2 = codeSource2.getCodeSigners();
        if (codeSignerArray == null) {
            if (this.p) {
                System.out.println("matchCerts: signers1 is null");
            }
            return false;
        }
        if (codeSignerArray2 == null) {
            if (this.p) {
                System.out.println("matchCerts: signers2 is null");
            }
            return false;
        }
        if (codeSignerArray.length != codeSignerArray2.length) {
            if (this.p) {
                System.out.println("matchCerts: length");
            }
            return false;
        }
        for (int i = 0; i < codeSignerArray.length; ++i) {
            CertPath certPath = codeSignerArray[i].getSignerCertPath();
            boolean bl = false;
            for (int j = 0; j < codeSignerArray2.length; ++j) {
                if (!certPath.equals(codeSignerArray2[j].getSignerCertPath())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            if (this.p) {
                System.out.println("matchCerts: no match: " + String.valueOf(certPath));
            }
            return false;
        }
        return true;
    }

    class a
    implements Runnable {
        a() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            if (AsynURLClassLoader.this.p) {
                System.out.println("BackgroundLoader run");
            }
            if (AsynURLClassLoader.this.D != null) {
                AsynURLClassLoader.this.D.a(AsynURLClassLoader.this.o == null ? 0 : AsynURLClassLoader.this.o.size());
            }
            if (AsynURLClassLoader.this.o != null) {
                for (String string : AsynURLClassLoader.this.o) {
                    try {
                        URL uRL = AsynURLClassLoader.this.d(string);
                        AsynURLClassLoader.this.c(uRL);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.out);
                    }
                }
            }
            while (true) {
                Hashtable<String, URL> hashtable = AsynURLClassLoader.this.x;
                // MONITORENTER : hashtable
                String[] stringArray = AsynURLClassLoader.this.r.values().toArray(new String[AsynURLClassLoader.this.r.size()]);
                // MONITOREXIT : hashtable
                for (String string : stringArray) {
                    try {
                        AsynURLClassLoader.this.d(string);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.out);
                    }
                }
                for (URL uRL : AsynURLClassLoader.this.getUrls()) {
                    try {
                        AsynURLClassLoader.this.c(uRL);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.out);
                    }
                }
                Hashtable<String, URL> hashtable2 = AsynURLClassLoader.this.x;
                // MONITORENTER : hashtable2
                if (!AsynURLClassLoader.this.s) {
                    AsynURLClassLoader.this.t = false;
                    // MONITOREXIT : hashtable2
                    if (AsynURLClassLoader.this.D == null) return;
                    AsynURLClassLoader.this.D.k();
                    return;
                }
                AsynURLClassLoader.this.s = false;
                // MONITOREXIT : hashtable2
            }
        }
    }
}

