/*
 * Decompiled with CFR 0.152.
 */
package com.inet.guilib.i18n;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Msg {
    private static HashMap<Locale, ResourceBundle> bundleCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle getResourceBundle(Locale locale) {
        HashMap<Locale, ResourceBundle> hashMap = bundleCache;
        synchronized (hashMap) {
            ResourceBundle bundle = bundleCache.get(locale);
            if (bundle != null) {
                return bundle;
            }
            try {
                bundle = ResourceBundle.getBundle("com.inet.guilib.i18n.LanguageResources", locale);
                bundleCache.put(locale, bundle);
                return bundle;
            }
            catch (MissingResourceException e) {
                return null;
            }
        }
    }

    public static String getMsg(String msgID) {
        Object msg;
        try {
            msg = Msg.getResourceBundle(Locale.getDefault()).getString(msgID);
        }
        catch (Throwable e) {
            msg = "$" + msgID + "$";
        }
        return msg;
    }

    public static boolean hasMsg(String msgID) {
        try {
            Msg.getResourceBundle(Locale.getDefault()).getString(msgID);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static String getMsg(Locale locale, String msgID) {
        Object msg;
        try {
            msg = Msg.getResourceBundle(locale).getString(msgID);
        }
        catch (Throwable e) {
            msg = "$" + msgID + "$";
        }
        return msg;
    }

    public static String getMsg(String msgID, Object ... msgParameter) {
        return Msg.getMsg(Locale.getDefault(), msgID, msgParameter);
    }

    public static String getMsg(Locale locale, String msgID, Object ... msgParameter) {
        ResourceBundle bundle = null;
        try {
            bundle = Msg.getResourceBundle(locale);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Msg.getMsg(bundle, msgID, msgParameter);
    }

    private static String getMsg(ResourceBundle bundle, String msgID, Object ... msgParameter) {
        Object msg;
        if (bundle != null) {
            msg = bundle.getString(msgID);
        } else {
            StringBuilder msgBuf = new StringBuilder();
            msgBuf.append(msgID);
            msgBuf.append('(');
            for (int i = 0; i < msgParameter.length; ++i) {
                if (i > 0) {
                    msgBuf.append(',');
                }
                msgBuf.append('{');
                msgBuf.append(i);
                msgBuf.append('}');
            }
            msgBuf.append(')');
            msg = "$" + MessageFormat.format(msgBuf.toString(), msgParameter) + "$";
        }
        try {
            msg = MessageFormat.format((String)msg, msgParameter);
        }
        catch (Throwable t) {
            StringBuilder msgBuf = new StringBuilder();
            msgBuf.append('$').append(t.toString()).append('_').append(msgID).append('(');
            for (int i = 0; i < msgParameter.length; ++i) {
                if (i > 0) {
                    msgBuf.append(',');
                }
                msgBuf.append(msgParameter[i]);
            }
            msgBuf.append(')').append('$');
            msg = msgBuf.toString();
        }
        return msg;
    }
}

