/*
 * Decompiled with CFR 0.152.
 */
package com.inet.guilib;

import com.inet.guilib.AsyncCallback;
import com.inet.guilib.AsyncWorker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SwingWorker;

public class WorkerPool
extends AsyncCallback<Object, Object>
implements PropertyChangeListener {
    private static ExecutorService internalPoolExecutor;
    private static Logger logger;
    public static final boolean DEFAULT_POOL_EXECUTION_TYPE = true;
    private List<AsyncWorker<?, ?>> pool = Collections.synchronizedList(new LinkedList());
    private AtomicBoolean alive = new AtomicBoolean(true);
    private boolean concurrentExcecution;
    private boolean cancelByException;

    public WorkerPool(AsyncWorker<?, ?> ... ar) {
        this(true, ar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerPool(boolean concurrentExecution, AsyncWorker<?, ?> ... ar) {
        this.concurrentExcecution = concurrentExecution;
        if (ar != null) {
            for (AsyncWorker<?, ?> w : ar) {
                this.addWorker(w);
            }
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("unlock".equals(evt.getPropertyName()) && evt.getOldValue() == AsyncWorker.State.CANCEL) {
                    WorkerPool.this.cancel();
                }
            }
        });
        Logger logger = WorkerPool.logger;
        synchronized (logger) {
            if (internalPoolExecutor == null) {
                internalPoolExecutor = new ThreadPoolExecutor(10, 10, 10L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
            }
        }
    }

    @Override
    public final Void call() throws Exception {
        return this.isConcurrentExcecution() ? this.executeConcurrently() : this.executeSubsequently();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Void executeConcurrently() throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "START Call WorkerPool (concurently) : {0} ", new Object[]{this.paramString()});
        }
        while (this.alive.get()) {
            block8: for (AsyncWorker w : this.pool.toArray(new AsyncWorker[0])) {
                switch (w.getState()) {
                    case PENDING: {
                        internalPoolExecutor.execute(w);
                        continue block8;
                    }
                    case DONE: {
                        this.pool.remove(w);
                        if (!logger.isLoggable(Level.FINEST)) continue block8;
                        logger.log(Level.FINEST, "remove Worker: {0} from WorkerPool: {1} ", new Object[]{w.paramString(), this});
                        continue block8;
                    }
                }
            }
            if (this.pool.isEmpty()) {
                this.alive.set(false);
                continue;
            }
            WorkerPool workerPool = this;
            synchronized (workerPool) {
                this.wait(100L);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "END Call WorkerPool (concurently) : {0} ", new Object[]{this.paramString()});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Void executeSubsequently() throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "START Call WorkerPool (subsequently) : {0} ", new Object[]{this.paramString()});
        }
        while (this.alive.get()) {
            if (!this.pool.isEmpty()) {
                AsyncWorker<?, ?> w = this.pool.get(0);
                switch (w.getState()) {
                    case PENDING: {
                        internalPoolExecutor.execute(w);
                        break;
                    }
                    case DONE: {
                        this.pool.remove(w);
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "remove Worker: {0} from WorkerPool: {1} ", new Object[]{w.paramString(), this});
                        }
                        if (this.pool.isEmpty()) break;
                        internalPoolExecutor.execute(this.pool.get(0));
                        break;
                    }
                }
            }
            if (this.pool.isEmpty()) {
                this.alive.set(false);
                continue;
            }
            WorkerPool workerPool = this;
            synchronized (workerPool) {
                this.wait(100L);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "END Call WorkerPool (subsequently) : {0} ", new Object[]{this.paramString()});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWorker(AsyncWorker<?, ?> worker) {
        if (worker.getState() != SwingWorker.StateValue.PENDING) {
            throw new IllegalStateException("worker already executed! ");
        }
        AtomicBoolean atomicBoolean = this.alive;
        synchronized (atomicBoolean) {
            if (this.alive.get() && !this.isDone()) {
                this.pool.add(worker);
                worker.addPropertyChangeListener(this);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "add Worker: {0} to WorkerPool: {1} ", new Object[]{worker.paramString(), this});
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PropertyChange name={0} oldValue={1} newValue={2} WorkerPool: {3} ", new Object[]{evt.getPropertyName(), evt.getOldValue(), evt.getNewValue(), this});
        }
        if ("unlock".equals(evt.getPropertyName()) && this.isCancelByException() && evt.getOldValue() == AsyncWorker.State.EXCEPTION) {
            this.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "cancel WorkerPool: {0} ", new Object[]{this});
        }
        List<AsyncWorker<?, ?>> list = this.pool;
        synchronized (list) {
            for (AsyncWorker w : this.pool.toArray(new AsyncWorker[0])) {
                if (w.getState() == SwingWorker.StateValue.STARTED) {
                    w.cancel(true);
                }
                this.pool.remove(w);
            }
        }
    }

    public boolean isConcurrentExcecution() {
        return this.concurrentExcecution;
    }

    public boolean isCancelByException() {
        return this.cancelByException;
    }

    public void setCancelByException(boolean cancelByException) {
        this.cancelByException = cancelByException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessage() {
        AsyncWorker<?, ?> current = this.getCurrentAsyncWorker();
        if (current != null) {
            return current.getMessage();
        }
        List<AsyncWorker<?, ?>> list = this.pool;
        synchronized (list) {
            StringBuilder b = new StringBuilder();
            if (!this.pool.isEmpty()) {
                for (AsyncWorker<?, ?> w : this.pool) {
                    String msg = w.getMessage();
                    if (msg == null || msg.length() == 0) continue;
                    if (b.length() > 0) {
                        b.append(", ");
                    }
                    b.append(msg);
                }
                if (b.length() > 0) {
                    return b.toString();
                }
            }
        }
        return super.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultBoundedRangeModel getProgressModel() {
        AsyncWorker<?, ?> current = this.getCurrentAsyncWorker();
        if (current != null) {
            return current.getProgressModel();
        }
        DefaultBoundedRangeModel superModel = super.getProgressModel();
        List<AsyncWorker<?, ?>> list = this.pool;
        synchronized (list) {
            superModel.setMinimum(0);
            superModel.setMaximum(100);
            if (!this.pool.isEmpty()) {
                double progress = 0.0;
                for (AsyncWorker<?, ?> w : this.pool) {
                    DefaultBoundedRangeModel m = w.getProgressModel();
                    progress += (double)(m.getValue() - m.getMinimum()) / (double)(m.getMaximum() - m.getMinimum());
                }
                superModel.setValue((int)Math.round((progress /= (double)this.pool.size()) * 100.0));
            } else {
                superModel.setValue(0);
            }
        }
        return superModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncWorker.Type getType() {
        AsyncWorker<?, ?> current = this.getCurrentAsyncWorker();
        if (current != null) {
            return current.getType();
        }
        AsyncWorker.Type type = super.getType();
        if (type == AsyncWorker.Type.DETERMINATE) {
            return AsyncWorker.Type.DETERMINATE;
        }
        List<AsyncWorker<?, ?>> list = this.pool;
        synchronized (list) {
            if (!this.pool.isEmpty()) {
                for (AsyncWorker<?, ?> w : this.pool) {
                    if (w.getType() == AsyncWorker.Type.DETERMINATE) {
                        return AsyncWorker.Type.DETERMINATE;
                    }
                    if (w.getType() != AsyncWorker.Type.INDETERMINATE) continue;
                    type = AsyncWorker.Type.INDETERMINATE;
                }
            }
        }
        return super.getType();
    }

    @Override
    public boolean isAtomic() {
        AsyncWorker<?, ?> current = this.getCurrentAsyncWorker();
        if (current != null) {
            return current.isAtomic();
        }
        return super.isAtomic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncWorker<?, ?> getCurrentAsyncWorker() {
        if (!this.isConcurrentExcecution()) {
            List<AsyncWorker<?, ?>> list = this.pool;
            synchronized (list) {
                if (!this.pool.isEmpty()) {
                    AsyncWorker<?, ?> current = this.pool.get(0);
                    return current;
                }
            }
        }
        return null;
    }

    static {
        logger = Logger.getLogger("com.inet.guilib.WorkerPool");
    }
}

