/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing.search;

import com.inet.annotations.InternalApi;
import com.inet.swing.IconCache;
import com.inet.swing.i18n.LibConstants;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

@InternalApi
public class SearchTextField
extends JTextField {
    public static final String KEY_ENTER = "key_enter";
    private Icon hc = IconCache.getIcon("searchdelete.png");
    private MouseInputAdapter hd = new a();

    public SearchTextField() {
        this.addMouseListener(this.hd);
        this.addMouseMotionListener(this.hd);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e2) {
            }

            @Override
            public void keyReleased(KeyEvent e2) {
                if (e2.getKeyCode() == 10) {
                    SearchTextField.this.firePropertyChange(SearchTextField.KEY_ENTER, false, true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SearchTextField.this.firePropertyChange("filter_enter_event", false, true);
                        }
                    });
                }
            }

            @Override
            public void keyPressed(KeyEvent e2) {
            }
        });
        this.setName("SearchTextField");
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e2) {
                SearchTextField.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent e2) {
                SearchTextField.this.repaint();
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.getInputMap(2).put(keyStroke, "Find");
        this.getActionMap().put("Find", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (!SearchTextField.this.requestFocusInWindow()) {
                    SearchTextField.this.requestFocus();
                }
                SearchTextField.this.selectAll();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        int n2 = this.getWidth() - this.getInsets().right;
        int n3 = (this.getHeight() - this.hc.getIconHeight()) / 2;
        if (this.isEnabled() && this.getText().length() > 0) {
            this.hc.paintIcon(this, g2, n2, n3);
        }
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        if (!this.hasFocus() && this.getText().length() == 0) {
            Font font = g2.getFont();
            font = font.deriveFont(2);
            int n2 = g2.getFontMetrics().getHeight();
            g2.setColor(Color.gray);
            Graphics2D graphics2D = (Graphics2D)g2;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setFont(font);
            g2.drawString(LibConstants.MSG.getMsg("Search.search", new Object[0]), this.getInsets().left, n2);
        }
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets.right += this.hc.getIconWidth() + 2;
        return insets;
    }

    private boolean a(Point point) {
        return this.getWidth() - point.x <= this.getInsets().right;
    }

    private class a
    extends MouseInputAdapter {
        private a() {
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (SearchTextField.this.a(e2.getPoint())) {
                SearchTextField.this.setText("");
            }
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            if (SearchTextField.this.a(e2.getPoint())) {
                SearchTextField.this.setCursor(Cursor.getDefaultCursor());
            }
            SearchTextField.this.setCursor(SearchTextField.this.a(e2.getPoint()) ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(2));
        }
    }
}

