/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing.control;

import com.inet.annotations.InternalApi;
import com.inet.logging.LogManager;
import com.inet.swing.control.Control;
import com.inet.swing.control.Initializable;
import com.inet.swing.control.Message;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;

@InternalApi
public abstract class ControlManager
implements PropertyChangeListener {
    public static final String PROPERTY_SELECTED = "SELECTED";
    public static final String PROPERTY_STATUS = "STATUS";
    public static final String PROPERTY_CLOSE = "CLOSE";
    public static final String PROPERTY_ADD = "ADD";
    public static final String PROPERTY_REMOVE = "REMOVE";
    public static final String PROPERTY_COMMIT = "COMMIT";
    public static final String PROPERTY_ROLLBACK = "ROLLBACK";
    public static final String PROPERTY_VERIFY = "VERIFY";
    public static final String PROPERTY_HELP = "HELP";
    public static final String PROPERTY_APPLY = "APPLY";
    public static final String PROPERTY_ENABLE = "ENABLE";
    public static final String VALUE_FIRE = "FIRE";
    public static final String VALUE_ENABLE = "ENABLE";
    public static final String VALUE_DISABLE = "DISABLE";
    private ArrayList<Control> fu = new ArrayList();
    private int fv = -1;
    private PropertyChangeSupport fw = new PropertyChangeSupport(this);

    protected ControlManager() {
    }

    protected ControlManager(Control[] controls) {
        for (int i2 = 0; i2 < controls.length; ++i2) {
            this.addSilent(controls[i2]);
        }
        this.fv = 0;
    }

    public final int getControlCount() {
        return this.fu.size();
    }

    public final Control getControl(int index) {
        Control control = this.fu.get(index);
        return control;
    }

    public final Control getControl(String name) {
        for (int i2 = 0; i2 < this.getControlCount(); ++i2) {
            Control control = this.getControl(i2);
            if (!control.getName().equals(name)) continue;
            if (control instanceof Initializable) {
                ((Initializable)((Object)control)).init();
            }
            return control;
        }
        return null;
    }

    public final int indexOf(Control control) {
        return this.fu.indexOf(control);
    }

    public final boolean contains(Control control) {
        return this.indexOf(control) != -1;
    }

    public final Control getSelected() {
        if (this.fv == -1) {
            return null;
        }
        return this.getControl(this.fv);
    }

    public final void setSelected(Control control) {
        int n2 = this.fu.indexOf(control);
        if (n2 != -1) {
            this.fv = n2;
            control.select();
            this.firePropertyChange(PROPERTY_SELECTED, control);
        }
    }

    protected final void addSilent(Control control) {
        this.addSilent(this.fu.size(), control);
    }

    protected final void addSilent(int index, Control control) {
        this.fu.add(index, control);
        control.addPropertyChangeListener(this);
    }

    protected final Control removeSilent(Control control) {
        if (this.fu.remove(control)) {
            control.removePropertyChangeListener(this);
            return control;
        }
        return null;
    }

    public final void add(Control control) {
        if (this.indexOf(control) != -1) {
            return;
        }
        this.addSilent(control);
        this.firePropertyChange(PROPERTY_ADD, control);
    }

    public final void add(int index, Control control) {
        if (this.indexOf(control) != -1) {
            return;
        }
        this.addSilent(index, control);
        this.firePropertyChange(PROPERTY_ADD, control, new Integer(index));
    }

    public final Control remove(Control control) {
        if (this.indexOf(control) == -1) {
            return null;
        }
        try {
            Control control2 = this.removeSilent(control);
            return control2;
        }
        finally {
            this.firePropertyChange(PROPERTY_REMOVE, control);
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.fw.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.fw.removePropertyChangeListener(listener);
    }

    public void removeAllListenerReferences() {
        PropertyChangeListener[] propertyChangeListenerArray = this.fw.getPropertyChangeListeners();
        for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray) {
            this.fw.removePropertyChangeListener(propertyChangeListener);
        }
        for (Control control : this.fu) {
            control.removePropertyChangeListener(this);
        }
        this.fu.clear();
    }

    private Object a(String string, Object object) {
        if ((string.equals(PROPERTY_SELECTED) || string.equals(PROPERTY_ADD) || string.equals(PROPERTY_REMOVE)) && object instanceof String) {
            String string2 = (String)object;
            return this.getControl(string2);
        }
        return object;
    }

    public final void firePropertyChange(String propertyName, Object value) {
        if (propertyName.equals(PROPERTY_STATUS) && value instanceof Message) {
            Message message = (Message)value;
            if (message.getType() == 1) {
                this.firePropertyChange(PROPERTY_COMMIT, VALUE_DISABLE);
            } else {
                this.firePropertyChange(PROPERTY_COMMIT, "ENABLE");
            }
        }
        this.fw.firePropertyChange(propertyName, null, this.a(propertyName, value));
    }

    public final void firePropertyChange(String propertyName, Object value, Object info) {
        this.fw.firePropertyChange(propertyName, info, this.a(propertyName, value));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evtReceived) {
        Object object;
        Object object2;
        Object object3;
        if (evtReceived.getPropertyName().equals(PROPERTY_SELECTED)) {
            object3 = evtReceived.getNewValue();
            if (object3 instanceof String) {
                object2 = (String)object3;
                object = this.getControl((String)object2);
                if (object != null) {
                    this.setSelected((Control)object);
                    return;
                }
                LogManager.getApplicationLogger().debug((Object)("Control not found: " + (String)object2));
            } else if (object3 instanceof Control) {
                if (this.indexOf((Control)object3) != -1) {
                    this.setSelected((Control)object3);
                    return;
                }
                LogManager.getApplicationLogger().debug((Object)("Control index not found: " + String.valueOf(object3)));
            }
        }
        if (evtReceived.getPropertyName().equals(PROPERTY_COMMIT) && evtReceived.getNewValue().equals(VALUE_FIRE)) {
            if (this.commit()) {
                this.firePropertyChange(PROPERTY_CLOSE, VALUE_FIRE);
            }
            return;
        }
        if (evtReceived.getPropertyName().equals(PROPERTY_ROLLBACK)) {
            if (evtReceived.getNewValue().equals(VALUE_FIRE) && this.rollback()) {
                this.firePropertyChange(PROPERTY_CLOSE, VALUE_FIRE);
            }
            return;
        }
        if (evtReceived.getPropertyName().equals(PROPERTY_HELP)) {
            if (evtReceived.getNewValue().equals(VALUE_FIRE)) {
                object3 = this.help();
                this.firePropertyChange(PROPERTY_HELP, object3, evtReceived.getOldValue());
            }
            return;
        }
        if (evtReceived.getPropertyName().equals(PROPERTY_APPLY) && evtReceived.getNewValue().equals(VALUE_FIRE)) {
            if (this.apply()) {
                this.firePropertyChange(PROPERTY_APPLY, VALUE_FIRE);
            }
            return;
        }
        if (evtReceived.getPropertyName().equals(PROPERTY_VERIFY)) {
            object3 = (Control)evtReceived.getNewValue();
            object2 = object3 != null ? object3.verify(false) : this.verify(false);
            if (object2 != null && ((Message)object2).getType() != -1) {
                this.firePropertyChange(PROPERTY_STATUS, object2);
            } else {
                this.firePropertyChange(PROPERTY_STATUS, Message.NONE);
            }
        }
        if (evtReceived.getPropertyName().equals("ENABLE")) {
            object3 = evtReceived.getNewValue();
            boolean bl = (Boolean)evtReceived.getOldValue();
            if (object3 instanceof String) {
                object = (String)object3;
                Control control = this.getControl((String)object);
                if (control != null) {
                    control.setControlEnabled(bl);
                    return;
                }
            } else if (object3 instanceof Control && this.indexOf((Control)object3) != -1) {
                ((Control)object3).setControlEnabled(bl);
                return;
            }
        }
        object3 = new PropertyChangeEvent(this, evtReceived.getPropertyName(), null, this.a(evtReceived.getPropertyName(), evtReceived.getNewValue()));
        this.fw.firePropertyChange((PropertyChangeEvent)object3);
    }

    public abstract boolean commit();

    public abstract boolean rollback();

    public abstract String help();

    public abstract Message verify(boolean var1);

    public abstract boolean apply();
}

