/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing.configuration.view;

import com.inet.annotations.InternalApi;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.help.swing.HelpManager;
import com.inet.swing.LaF;
import com.inet.swing.SwingFunctions;
import com.inet.swing.configuration.util.DataFactory;
import com.inet.swing.configuration.util.GUIUtils;
import com.inet.swing.configuration.view.ConfigurationFilter;
import com.inet.swing.configuration.view.a;
import com.inet.swing.configuration.view.b;
import com.inet.swing.configuration.view.f;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@InternalApi
public class CategoryViewImpl {
    private final String dx;
    private ConfigurationFilter bD;
    private final a dy;
    private JDialog dz;
    private WindowAdapter dA;
    private AbstractAction dB = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (!CategoryViewImpl.this.dE.isEnabled()) {
                return;
            }
            if (CategoryViewImpl.this.hasChanges()) {
                if (LaF.DIALOGFACTORY.showConfirmDialog(CategoryViewImpl.this.dz, GUIUtils.MSG.getMsg("message.confirm.cancel", new Object[0]), GUIUtils.MSG.getMsg("message.confirm.cancel.title", new Object[0]), 0) == 0) {
                    CategoryViewImpl.this.dz.dispose();
                }
            } else {
                CategoryViewImpl.this.dz.dispose();
            }
        }
    };
    private f dC = new f();
    private JButton dD;
    private JButton dE;
    private JButton dF;
    private DataFactory bi;
    private b dG;

    public CategoryViewImpl(final Configuration config, ConfigCategory category, b configPanel, Window frame, ConfigurationFilter filter) {
        this.dG = configPanel;
        this.dx = category.getHelpKey();
        this.bD = filter;
        this.bi = new DataFactory(config, category.getKey(), new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                if (e2 != null) {
                    if (e2.getSource() instanceof Boolean) {
                        boolean bl = (Boolean)e2.getSource();
                        boolean bl2 = ConfigurationManager.isWriteable((int)config.getScope());
                        CategoryViewImpl.this.dD.setEnabled(bl && bl2);
                        CategoryViewImpl.this.dF.setEnabled(bl && bl2);
                        CategoryViewImpl.this.dE.setEnabled(bl);
                    }
                } else {
                    this.N();
                }
            }

            private void N() {
                if (CategoryViewImpl.this.dz == null) {
                    return;
                }
                Rectangle rectangle = CategoryViewImpl.this.dz.getBounds();
                GraphicsConfiguration graphicsConfiguration = CategoryViewImpl.this.dz.getGraphicsConfiguration();
                Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
                Rectangle rectangle2 = graphicsConfiguration.getBounds();
                rectangle2.x += insets.left;
                rectangle2.y += insets.top;
                rectangle2.width -= insets.left + insets.right;
                rectangle2.height -= insets.top + insets.bottom;
                Dimension dimension = CategoryViewImpl.this.dz.getPreferredSize();
                rectangle.height = dimension.height;
                rectangle.height = Math.min(rectangle.height, rectangle2.height);
                int n2 = rectangle2.y + rectangle2.height;
                int n3 = rectangle.y + rectangle.height;
                int n4 = n2 - n3;
                if (n4 < 0) {
                    rectangle.y = n2 - rectangle.height;
                }
                CategoryViewImpl.this.dz.setBounds(rectangle);
            }
        });
        this.dy = new a(this.bi, filter);
        boolean bl = !ConfigurationManager.isWriteable((int)config.getScope());
        JPanel jPanel = new JPanel();
        jPanel.setName("CategoryViewImpl_pnlWrapper");
        jPanel.setLayout(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add(this.c(bl), "Center");
        Object object = category.getDisplayName();
        this.dy.add((Component)jPanel, "South");
        if (bl) {
            object = (String)object + "  (" + GUIUtils.MSG.getMsg("config.category.header.readonly", new Object[0]) + ")";
        }
        Image image = GUIUtils.getIconForUrl(ConfigStructure.getCategoryIcon((String)category.getKey())).getImage();
        this.dz = LaF.DIALOGFACTORY.createDialog(frame, (String)object, Dialog.ModalityType.DOCUMENT_MODAL);
        this.dz.setIconImage(image.getScaledInstance(16, 16, 16));
        this.dz.setDefaultCloseOperation(0);
        this.dz.setName("CategoryViewImpl_jDialog");
        this.dz.setContentPane(this.dy);
        this.dz.getRootPane().setDefaultButton(this.dF);
        this.dz.pack();
        this.dz.setMinimumSize(new Dimension(this.dz.getWidth() + 200, 10));
        this.dz.pack();
        this.bi.propertyVisibilityChanged();
        this.dy.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "escape");
        this.dy.getActionMap().put("escape", this.dB);
        this.dy.getInputMap(2).put(KeyStroke.getKeyStroke(112, 0), "help");
        this.dy.getActionMap().put("help", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                HelpManager.showHelp(CategoryViewImpl.this.dx, CategoryViewImpl.this.dz);
            }
        });
        this.dA = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                if (!CategoryViewImpl.this.dE.isEnabled()) {
                    return;
                }
                if (CategoryViewImpl.this.hasChanges()) {
                    if (LaF.DIALOGFACTORY.showConfirmDialog(CategoryViewImpl.this.dz, GUIUtils.MSG.getMsg("message.confirm.cancel", new Object[0]), GUIUtils.MSG.getMsg("message.confirm.cancel.title", new Object[0]), 0) == 0) {
                        CategoryViewImpl.this.dz.dispose();
                    }
                } else {
                    CategoryViewImpl.this.dz.dispose();
                }
            }
        };
        this.dz.addWindowListener(this.dA);
        this.bi.checkConditions();
        List<ConfigValidationMsg> list = this.bi.validate();
        if (list != null) {
            this.a(list, true);
        }
    }

    public void save(boolean closeAfterwards) {
        HashMap<String, String> hashMap = this.bi.getChangedValues();
        if (hashMap.size() > 0) {
            List<ConfigValidationMsg> list = this.bi.validate();
            if (list != null && this.a(list, false)) {
                return;
            }
            boolean bl = this.bi.save(hashMap);
            this.dC.r(GUIUtils.MSG.getMsg("message.successful.saved", new Object[0]));
            if (!closeAfterwards) {
                this.bi.reset();
                this.dy.M();
                this.bi.setTrackVisibilityChange(true);
                this.bi.checkConditions();
                this.bi.setTrackVisibilityChange(false);
            }
            if (bl) {
                this.dG.O();
            }
        }
        if (closeAfterwards) {
            this.hide();
        } else {
            this.dy.d(null);
        }
    }

    public boolean hasChanges() {
        return this.bi.getChangedValues().size() > 0;
    }

    public void hide() {
        this.dz.setVisible(false);
    }

    public void show() {
        this.dz.setLocationRelativeTo(this.dz.getOwner());
        this.dz.setVisible(true);
    }

    private boolean a(List<ConfigValidationMsg> list, boolean bl) {
        ArrayList<ConfigValidationMsg> arrayList = new ArrayList<ConfigValidationMsg>();
        ArrayList<ConfigValidationMsg> arrayList2 = new ArrayList<ConfigValidationMsg>();
        ArrayList<ConfigValidationMsg> arrayList3 = new ArrayList<ConfigValidationMsg>();
        for (ConfigValidationMsg configValidationMsg : list) {
            switch (configValidationMsg.getType()) {
                case Invalid: {
                    arrayList.add(configValidationMsg);
                    break;
                }
                case Confirmation: {
                    arrayList2.add(configValidationMsg);
                    break;
                }
                case Restart: {
                    if (bl) break;
                    arrayList3.add(configValidationMsg);
                    break;
                }
                default: {
                    if (bl) break;
                    throw new UnsupportedOperationException("Not supported ValidationType: " + configValidationMsg.getType().name());
                }
            }
        }
        if (!arrayList.isEmpty()) {
            this.dy.d(arrayList);
        } else {
            if (!arrayList3.isEmpty()) {
                LaF.DIALOGFACTORY.showErrorMessageDialog(this.dz, GUIUtils.MSG.getMsg("restartMessage.message", new Object[0]), GUIUtils.MSG.getMsg("restartMessage.title", new Object[0]), 1, null);
                return false;
            }
            if (!arrayList2.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    private Component c(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setName("CategoryViewImpl_pnlButton");
        if (this.bD.isConfigurationManagerVisible()) {
            jPanel.setBorder(BorderFactory.createCompoundBorder(LaF.getBorder(1), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        } else {
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        jPanel.setOpaque(false);
        TableLayout tableLayout = new TableLayout((double[][])new double[][]{{-2.0, -1.0, -2.0, -2.0, -2.0, -2.0}, {-2.0}});
        tableLayout.setHGap(10);
        tableLayout.setVGap(10);
        jPanel.setLayout((LayoutManager)tableLayout);
        jPanel.add((Component)this.dC, "1,0");
        this.dF = LaF.BUTTONFACTORY.createPlainButton(GUIUtils.MSG.getMsg("accept", new Object[0]));
        this.dF.setName("inet.lib.ok");
        this.dF.setEnabled(!bl);
        this.dF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CategoryViewImpl.this.save(true);
            }
        });
        this.dE = LaF.BUTTONFACTORY.createPlainButton(GUIUtils.MSG.getMsg("cancel", new Object[0]));
        this.dE.setName("inet.lib.cancel");
        this.dE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (CategoryViewImpl.this.hasChanges()) {
                    if (LaF.DIALOGFACTORY.showConfirmDialog(CategoryViewImpl.this.dz, GUIUtils.MSG.getMsg("message.confirm.cancel", new Object[0]), GUIUtils.MSG.getMsg("message.confirm.cancel.title", new Object[0]), 0) == 0) {
                        CategoryViewImpl.this.dz.dispose();
                    }
                } else {
                    CategoryViewImpl.this.dz.dispose();
                }
            }
        });
        this.dD = LaF.BUTTONFACTORY.createPlainButton(GUIUtils.MSG.getMsg("apply", new Object[0]));
        this.dD.setName("inet.lib.apply");
        this.dD.setEnabled(!bl);
        this.dD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CategoryViewImpl.this.save(false);
            }
        });
        JButton jButton = LaF.BUTTONFACTORY.createPlainButton(GUIUtils.MSG.getMsg("help", new Object[0]));
        jButton.setName("inet.lib.help");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                HelpManager.showHelp(CategoryViewImpl.this.dx, CategoryViewImpl.this.dz);
            }
        });
        jPanel.add((Component)jButton, "0,0");
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.dF);
        arrayList.add(this.dE);
        arrayList.add(this.dD);
        JButton[] jButtonArray = arrayList.toArray(new JButton[arrayList.size()]);
        SwingFunctions.sortButtons(jButtonArray);
        for (int i2 = 0; i2 < jButtonArray.length; ++i2) {
            jPanel.add((Component)jButtonArray[i2], i2 + 2 + ",0");
        }
        return jPanel;
    }
}

