/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing.configuration.util;

import com.inet.annotations.InternalApi;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.TempConfiguration;
import com.inet.config.provider.ConfigurationProvider;
import com.inet.config.provider.DefaultConfigurationProvider;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.json.Json;
import com.inet.swing.configuration.renderer.Renderer;
import com.inet.swing.configuration.renderer.e;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@InternalApi
public class DataFactory {
    private HashMap<String, Renderer> cv = new HashMap();
    private ConfigStructure bE;
    private String cw;
    private List<ConfigPropertyGroup> cx;
    private HashMap<String, List<ConfigProperty>> cy = new HashMap();
    private HashMap<String, List<ConfigProperty>> cz = new HashMap();
    private ArrayList<a> cA;
    private boolean cB;
    private DefaultConfigurationProvider cC;
    private Properties cD = new Properties();
    private ChangeListener cE;
    private HashMap<ConfigPropertyGroup, e> cF = new HashMap();
    private AtomicInteger cG = new AtomicInteger(0);
    private boolean cH = false;
    private AtomicInteger cI = new AtomicInteger(0);

    public DataFactory(Configuration config, String categoryKey, ChangeListener changeListener) {
        this.cw = categoryKey;
        this.cE = changeListener;
        this.cB = ConfigurationManager.isWriteable((int)config.getScope());
        this.cC = new DefaultConfigurationProvider();
        this.bE = new ConfigStructure(config, Locale.getDefault(), true, this.cD, (ConfigurationProvider)this.cC);
        this.reset();
    }

    public List<ConfigPropertyGroup> getPropertyGroups() {
        return this.cx;
    }

    public List<ConfigProperty> getProperties(String groupKey) {
        return this.cy.get(groupKey);
    }

    public void setInlineProperies(String key, ConfigProperty[] properties) {
        this.cz.remove(key);
        if (properties != null) {
            this.cz.put(key, Arrays.asList(properties));
        }
    }

    public HashMap<String, Object> getCurrentInlineValues(String key) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (ConfigProperty configProperty : this.cz.get(key)) {
            hashMap.put(configProperty.getKey(), configProperty.getValue());
        }
        return hashMap;
    }

    public boolean isWritable() {
        return this.cB;
    }

    public List<LocalizedKey> getSelectValues(String key, String filter) {
        return this.bE.getSelectValues(key, filter);
    }

    public void registerRenderer(Renderer renderer, String key) {
        this.cv.put(key, renderer);
    }

    public Renderer getRenderer(String propertyKey) {
        return this.cv.get(propertyKey);
    }

    public void registerGroupLabel(e groupLabel, ConfigPropertyGroup propertyGroup) {
        this.cF.put(propertyGroup, groupLabel);
    }

    public List<ConfigValidationMsg> action(String actionKey) {
        return this.bE.action(actionKey);
    }

    public HashMap<String, String> getChangedValues() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<a> arrayList = this.G();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            a a2 = arrayList.get(i2);
            a a3 = this.cA.get(i2);
            if (a2.cL.equals(a3.cL)) continue;
            hashMap.put(a2.cK, a2.cL);
        }
        return hashMap;
    }

    public HashMap<String, String> getAllValues() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<a> arrayList = this.G();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            a a2 = arrayList.get(i2);
            hashMap.put(a2.cK, a2.cL);
        }
        return hashMap;
    }

    public void reset() {
        this.cy.clear();
        this.cD.clear();
        this.cx = this.bE.getPropertyGroups(this.cw);
        for (ConfigPropertyGroup configPropertyGroup : this.cx) {
            String string = configPropertyGroup.getKey();
            List list = this.bE.getProperties(string);
            this.cy.put(string, list);
        }
        this.cA = this.G();
    }

    private ArrayList<a> G() {
        ArrayList<a> arrayList = new ArrayList<a>();
        for (Map.Entry<String, List<ConfigProperty>> entry : this.cy.entrySet()) {
            for (ConfigProperty configProperty : entry.getValue()) {
                a a2 = new a();
                a2.cK = configProperty.getKey();
                a2.cL = this.a(configProperty.getValue(), false);
                arrayList.add(a2);
            }
        }
        return arrayList;
    }

    private String a(Object object, boolean bl) {
        if (object == null) {
            return "null";
        }
        if (object.getClass().isArray()) {
            return this.c(object);
        }
        if (object instanceof Collection) {
            return this.b(object);
        }
        if (bl) {
            return new Json().toJson(object);
        }
        return object.toString();
    }

    private String b(Object object) {
        return new Json().toJson(object);
    }

    private String c(Object object) {
        StringBuilder stringBuilder = new StringBuilder("[");
        Object[] objectArray = (Object[])object;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            Object object2 = objectArray[i2];
            stringBuilder.append(this.a(object2, true));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public List<ConfigValidationMsg> validate() {
        HashMap<String, String> hashMap = this.getAllValues();
        if (hashMap.size() > 0) {
            this.cD.clear();
            this.cD.putAll((Map<?, ?>)hashMap);
            List list = this.bE.validate(this.cw);
            if (list != null && list.size() > 0) {
                return list;
            }
        }
        return null;
    }

    public boolean save(HashMap<String, String> changedValues) {
        if (changedValues.size() > 0) {
            ConfigStructure.SaveState saveState = this.bE.save();
            return saveState == ConfigStructure.SaveState.RELOAD;
        }
        return false;
    }

    public ConfigProperty getProperty(String key) {
        if (key != null) {
            for (ConfigPropertyGroup object : this.getPropertyGroups()) {
                for (ConfigProperty configProperty : this.getProperties(object.getKey())) {
                    if (!key.equals(configProperty.getKey())) continue;
                    return configProperty;
                }
            }
            for (List list : this.cz.values()) {
                for (ConfigProperty configProperty : list) {
                    if (!key.equals(configProperty.getKey())) continue;
                    return configProperty;
                }
            }
        }
        return null;
    }

    private ConfigPropertyGroup k(String string) {
        if (string != null) {
            for (ConfigPropertyGroup configPropertyGroup : this.getPropertyGroups()) {
                if (!string.equals(configPropertyGroup.getKey())) continue;
                return configPropertyGroup;
            }
        }
        return null;
    }

    private ConfigAction l(String string) {
        if (string != null) {
            for (ConfigPropertyGroup configPropertyGroup : this.getPropertyGroups()) {
                ConfigAction configAction = configPropertyGroup.getAction();
                if (configAction == null || !string.equals(configAction.getKey())) continue;
                return configAction;
            }
        }
        return null;
    }

    public void checkConditions() {
        HashMap<String, String> hashMap = this.getAllValues();
        this.cD.clear();
        this.cD.putAll((Map<?, ?>)hashMap);
        ConfigStructureSettings configStructureSettings = this.bE.getSettings();
        List list = this.bE.getConditions(this.cw);
        block13: for (ConfigConditionAction configConditionAction : list) {
            ConfigAction configAction;
            ConfigAction configAction2;
            Object object;
            String string = configConditionAction.getKey();
            ConfigProperty configProperty = this.getProperty(string);
            if (configProperty != null) {
                object = this.cv.get(configProperty.getKey());
                if (object == null) continue;
                configAction2 = configConditionAction.getCondition();
                switch (configConditionAction.getAction()) {
                    case Enable: {
                        if (!this.cB) break;
                        object.setEnabled(configStructureSettings.isEnabled(string, list));
                        break;
                    }
                    case Visible: {
                        object.setVisible(configStructureSettings.isVisible(string, list));
                        break;
                    }
                    case SetValue: {
                        if (!configStructureSettings.evalCondition((ConfigCondition)configAction2)) break;
                        configProperty.setValue((Object)configConditionAction.getValue());
                        object.refreshValue();
                        break;
                    }
                }
                continue;
            }
            object = this.k(string);
            if (object != null) {
                switch (configConditionAction.getAction()) {
                    case Enable: {
                        Renderer renderer;
                        Renderer renderer2;
                        if (!this.cB) continue block13;
                        boolean bl = configStructureSettings.isEnabled(string, list);
                        for (ConfigProperty configProperty2 : this.getProperties(object.getKey())) {
                            renderer2 = this.cv.get(configProperty2.getKey());
                            if (renderer2 == null) continue;
                            renderer2.setEnabled(bl);
                        }
                        this.cF.get(object).setEnabled(bl);
                        configAction = object.getAction();
                        if (configAction == null || (renderer = this.cv.get(configAction.getKey())) == null) continue block13;
                        renderer.setEnabled(bl);
                        break;
                    }
                    case Visible: {
                        Renderer renderer;
                        Renderer renderer2;
                        boolean bl = configStructureSettings.isVisible(string, list);
                        for (ConfigProperty configProperty3 : this.getProperties(object.getKey())) {
                            renderer2 = this.cv.get(configProperty3.getKey());
                            if (renderer2 == null) continue;
                            renderer2.setVisible(bl);
                        }
                        this.cF.get(object).setVisible(bl);
                        configAction = object.getAction();
                        if (configAction == null || (renderer = this.cv.get(configAction.getKey())) == null) continue block13;
                        renderer.setVisible(bl);
                        break;
                    }
                }
                continue;
            }
            configAction2 = this.l(string);
            if (configAction2 == null || (configAction = this.cv.get(configAction2.getKey())) == null) continue;
            switch (configConditionAction.getAction()) {
                case Enable: {
                    if (!this.cB) break;
                    configAction.setEnabled(configStructureSettings.isEnabled(string, list));
                    break;
                }
                case Visible: {
                    configAction.setVisible(configStructureSettings.isVisible(string, list));
                    break;
                }
            }
        }
    }

    public void setTrackVisibilityChange(boolean trackVisibilityChange) {
        this.cH = trackVisibilityChange;
        if (!trackVisibilityChange && this.cI.get() > 0) {
            this.propertyVisibilityChanged();
            this.cI.set(0);
        }
    }

    public void propertyVisibilityChanged() {
        if (this.cH) {
            this.cI.incrementAndGet();
            return;
        }
        this.cE.stateChanged(null);
    }

    public void setDialogBlocked(boolean b2) {
        boolean bl = (b2 ? this.cG.incrementAndGet() : this.cG.decrementAndGet()) == 0;
        this.cE.stateChanged(new ChangeEvent(bl));
    }

    public String requestTrialLicense(Properties properties) {
        TempConfiguration tempConfiguration = new TempConfiguration("");
        Locale locale = ClientLocale.getThreadLocale();
        ConfigStructureSettings configStructureSettings = new ConfigStructureSettings((Configuration)tempConfiguration, locale, properties);
        CoreSystemStructureProvider.requestTrialLicense((ConfigStructureSettings)configStructureSettings);
        return configStructureSettings.getLicenseKey();
    }

    private class a {
        private String cK;
        private String cL;

        private a() {
        }
    }
}

