/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing.configuration.renderer;

import com.inet.annotations.InternalApi;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.swing.configuration.renderer.Renderer;
import com.inet.swing.configuration.util.DataFactory;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

@InternalApi
public abstract class BaseRenderer<X extends Serializable>
extends JPanel
implements Renderer {
    public static final String RENDERER_TYPE = "RendererPanel";
    private String bn;
    private JPanel bj = new JPanel((LayoutManager)new TableLayout(new double[]{-1.0}, new double[]{-2.0}));
    private DataFactory bi;

    public BaseRenderer(String propertyKey, DataFactory dataFactory) {
        this.bn = propertyKey;
        this.setName(propertyKey);
        this.putClientProperty(RENDERER_TYPE, this.getClass().getSimpleName());
        this.bi = dataFactory;
        this.setOpaque(false);
        this.bj.setOpaque(false);
        this.bj.setVisible(false);
        dataFactory.registerRenderer(this, propertyKey);
    }

    public String getPropertyKey() {
        return this.bn;
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isVisible()) {
            return new Dimension(0, 0);
        }
        return super.getPreferredSize();
    }

    @Override
    public final JComponent renderComponent() {
        JComponent jComponent = this.renderComponent0();
        jComponent.setOpaque(false);
        jComponent = this.renderErrorContainer(jComponent);
        jComponent.setOpaque(false);
        this.setToolTipText(this.createToolTipText());
        return jComponent;
    }

    public String createToolTipText() {
        boolean bl;
        String string = this.getProperty().getTooltip();
        boolean bl2 = bl = string != null && string.trim().length() > 0;
        if (!bl) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        if (bl) {
            stringBuilder.append(string);
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    protected JComponent renderErrorContainer(JComponent comp) {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.bj, "North");
        jPanel.add((Component)comp, "Center");
        return jPanel;
    }

    protected void valueChangedConfirmed() {
        this.bi.checkConditions();
    }

    protected abstract JComponent renderComponent0();

    @Override
    public List<JLabel> getLabelElements() {
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        if (this.getLabelElement() != null) {
            arrayList.add(this.getLabelElement());
        }
        return arrayList;
    }

    public JLabel getLabelElement() {
        return null;
    }

    protected final ConfigProperty getProperty() {
        return this.bi.getProperty(this.bn);
    }

    protected final DataFactory getDataFactory() {
        return this.bi;
    }

    public void setValue(X value) {
        this.getProperty().setValue(value);
    }

    @Override
    public void setVisible(boolean aFlag) {
        boolean bl = super.isVisible();
        super.setVisible(aFlag);
        if (bl != aFlag) {
            this.bi.propertyVisibilityChanged();
        }
    }
}

