/*
 * Decompiled with CFR 0.152.
 */
package com.inet.help.swing;

import com.inet.annotations.InternalApi;
import com.inet.editor.BaseEditor;
import com.inet.editor.handler.HyperlinkHandler;
import com.inet.help.swing.HelpWindowCtrl;
import com.inet.help.swing.f;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.HelpAdminBackdoor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;

@InternalApi
public class HelpPagePanel
extends JPanel
implements HyperlinkListener {
    private HelpWindowCtrl c;
    public static final String INTERNAL_LINK_PROTOCOL = "dhelp";
    public static final String INTERNAL_LINK_BASE_PATH = "/internal";
    private BaseEditor d;
    private URL e;
    private BaseEditor.TextLoadListener f;
    private ProgressMonitor g;
    private JTextField h;

    public HelpPagePanel(HelpWindowCtrl helpWindowCtrl) {
        super(new BorderLayout());
        Properties properties = System.getProperties();
        if ("true".equalsIgnoreCase(properties.getProperty("runIDE"))) {
            this.h = new JTextField("");
            this.h.setEditable(false);
            this.add((Component)this.h, "North");
        }
        try {
            this.e = new URL(INTERNAL_LINK_PROTOCOL, "localhost", 564, INTERNAL_LINK_BASE_PATH, new HelpResourceStreamHandler(this.h));
        }
        catch (MalformedURLException malformedURLException) {
            HelpWindowCtrl.LOGGER.error((Throwable)malformedURLException);
        }
        this.c = helpWindowCtrl;
        this.d = new BaseEditor(true, false, false, true);
        this.d.getEditor().setCaret(new DefaultCaret(){

            @Override
            protected void adjustVisibility(Rectangle nloc) {
                if (HelpPagePanel.this.d.hasFocus()) {
                    super.adjustVisibility(nloc);
                }
            }
        });
        this.d.setCustomHyperlinkHandler(new HyperlinkHandler(){

            public boolean processExited(HyperlinkEvent e2) {
                return false;
            }

            public boolean processEntered(HyperlinkEvent e2) {
                return false;
            }

            public boolean processActivated(HyperlinkEvent e2) {
                try {
                    HelpPagePanel.this.c.selectedLinkOnPage(e2);
                }
                catch (Exception exception) {
                    HelpWindowCtrl.LOGGER.error((Throwable)exception);
                    return false;
                }
                return true;
            }
        });
        this.add((Component)this.d, "Center");
    }

    public void setCurrentPage(String helpPageContent, final f scrollToOnFinish) {
        this.d.setBase(this.e);
        if (this.g != null) {
            this.g.close();
        }
        if (helpPageContent.length() > 60000) {
            int n2 = helpPageContent.length() / 10000;
            final Timer timer = new Timer(n2, new ActionListener(){
                private float j = 0.0f;

                @Override
                public void actionPerformed(ActionEvent e2) {
                    this.j += this.j < 50.0f ? 2.0f : (100.0f - this.j) / 25.0f;
                    HelpPagePanel.this.g.setProgress((int)this.j);
                }
            });
            this.g = new ProgressMonitor(this, HelpWindowCtrl.MSG.getMsg(this.c.getLanguage(), "HelpActions.Loading", new Object[0]), "", 0, 100){

                @Override
                public void close() {
                    super.close();
                    timer.stop();
                    HelpPagePanel.this.g = null;
                }
            };
            this.g.setMillisToDecideToPopup(250);
            this.g.setMillisToPopup(250);
            timer.start();
        }
        if (this.f != null) {
            this.d.removeTextLoadListener(this.f);
        }
        this.f = new BaseEditor.TextLoadListener(){

            public void notifyTextLoaded(Document arg0) {
                if (scrollToOnFinish != null) {
                    HelpPagePanel.this.scrollToElement(scrollToOnFinish);
                }
                if (HelpPagePanel.this.g != null) {
                    HelpPagePanel.this.g.setProgress(95);
                    HelpPagePanel.this.g.close();
                }
            }
        };
        this.d.addTextLoadListener(this.f);
        this.d.setText(helpPageContent, true);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e2) {
        if (e2.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.c.selectedLinkOnPage(e2);
            }
            catch (Exception exception) {
                HelpWindowCtrl.LOGGER.error((Throwable)exception);
            }
        }
    }

    public void scrollToElement(f scrollAction) {
        final JTextPane jTextPane = this.d.getEditor();
        HTMLDocument hTMLDocument = (HTMLDocument)jTextPane.getDocument();
        final Rectangle rectangle = scrollAction.a(hTMLDocument, jTextPane, this);
        if (rectangle != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jTextPane.scrollRectToVisible(rectangle);
                }
            });
        }
    }

    @InternalApi
    public static class HelpResourceStreamHandler
    extends URLStreamHandler {
        private JTextField o;

        public HelpResourceStreamHandler() {
        }

        public HelpResourceStreamHandler(@Nullable JTextField textField) {
            this();
            this.o = textField;
        }

        @Override
        @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Caller must check this")
        protected URLConnection openConnection(URL u) throws IOException {
            URL uRL;
            String string = u.getPath();
            if (this.o != null) {
                this.o.setText(string);
            }
            if ((uRL = ((HelpAdminBackdoor)ServerPluginManager.getInstance().getSingleInstance(HelpAdminBackdoor.class)).getResource(string)) == null) {
                throw new IOException("Cannot find resource: " + string);
            }
            return uRL.openConnection();
        }
    }
}

