/*
 * Decompiled with CFR 0.152.
 */
package com.inet.help.swing;

import com.inet.annotations.InternalApi;
import com.inet.help.swing.HelpWindowCtrl;
import com.inet.plugin.ServerPluginManager;
import java.awt.Component;
import java.util.Locale;
import javax.swing.ImageIcon;

@InternalApi
public class HelpManager {
    private static HelpWindowCtrl c;
    public static ImageIcon icon;
    public static Locale helpLocale;

    private HelpManager() {
    }

    public static void showHelp(String helpPageKey, Component comp) {
        HelpManager.showHelp(helpPageKey, comp, Locale.getDefault());
    }

    public static void showHelp(String helpPageKey, Component comp, Locale language) {
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        if (serverPluginManager.getState() != ServerPluginManager.ServerPluginManagerState.INIT) {
            HelpWindowCtrl.LOGGER.info((Object)"Help: PluginManager not init");
            return;
        }
        if (!serverPluginManager.isPluginLoaded("help")) {
            HelpWindowCtrl.LOGGER.info((Object)"Help: help plugin not loaded");
            return;
        }
        try {
            if (c == null || language != helpLocale) {
                helpLocale = language;
                HelpManager.c();
            }
            c.showHelp(helpPageKey, comp);
        }
        catch (Throwable throwable) {
            HelpWindowCtrl.LOGGER.error(throwable);
            throw throwable;
        }
    }

    private static void c() {
        c = new HelpWindowCtrl(helpLocale);
    }

    static {
        helpLocale = Locale.ENGLISH;
    }
}

