/*
 * Decompiled with CFR 0.152.
 */
package de.anormalmedia.sbstutorial.gui.selector;

import de.anormalmedia.sbstutorial.SBSTutorial;
import de.anormalmedia.sbstutorial.Tutorial;
import de.anormalmedia.sbstutorial.gui.ComponentFinder;
import de.anormalmedia.sbstutorial.store.FileStore;
import de.anormalmedia.sbstutorial.store.URLStore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TutorialSelector
extends JDialog
implements ListSelectionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private ResourceBundle languageResource;
    private Window parent;
    private String filepath;
    private URL jarpath;
    private JButton btStart;
    private JButton btCancel;
    private JButton btHelp;
    private JTextField tfPath;
    private JList tuts;
    private final JTextPane textpane;
    private ArrayList<ResourceBundle> externalResourceBundles = new ArrayList();
    private final HashMap<String, URL> additionalEntries;

    public TutorialSelector(JDialog parent, String filepath, JTextPane textpane) {
        super(parent);
        this.parent = parent;
        this.filepath = filepath;
        this.additionalEntries = null;
        this.jarpath = null;
        if (textpane == null) {
            textpane = new JTextPane();
            textpane.setEditable(false);
        }
        this.textpane = textpane;
        this.initGui();
    }

    public TutorialSelector(JFrame parent, String filepath, JTextPane textpane) {
        super(parent);
        this.parent = parent;
        this.filepath = filepath;
        this.jarpath = null;
        this.additionalEntries = null;
        if (textpane == null) {
            textpane = new JTextPane();
            textpane.setEditable(false);
        }
        this.textpane = textpane;
        this.initGui();
    }

    public TutorialSelector(JFrame parent, URL jarpath, JTextPane textpane) {
        super(parent);
        this.parent = parent;
        this.filepath = null;
        this.additionalEntries = null;
        this.jarpath = jarpath;
        if (textpane == null) {
            textpane = new JTextPane();
        }
        this.textpane = textpane;
        this.initGui();
    }

    public TutorialSelector(JDialog parent, URL jarpath, JTextPane textpane) {
        super(parent);
        this.parent = parent;
        this.filepath = null;
        this.additionalEntries = null;
        this.jarpath = jarpath;
        if (textpane == null) {
            textpane = new JTextPane();
        }
        this.textpane = textpane;
        this.initGui();
    }

    public TutorialSelector(JDialog parent, String filepath, JTextPane textpane, LinkedHashMap<String, URL> additionalEntries) {
        super(parent);
        this.parent = parent;
        this.filepath = filepath;
        this.additionalEntries = additionalEntries;
        this.jarpath = null;
        if (textpane == null) {
            textpane = new JTextPane();
            textpane.setEditable(false);
        }
        this.textpane = textpane;
        this.initGui();
    }

    public TutorialSelector(JFrame parent, String filepath, JTextPane textpane, LinkedHashMap<String, URL> additionalEntries) {
        super(parent);
        this.parent = parent;
        this.filepath = filepath;
        this.additionalEntries = additionalEntries;
        this.jarpath = null;
        if (textpane == null) {
            textpane = new JTextPane();
            textpane.setEditable(false);
        }
        this.textpane = textpane;
        this.initGui();
    }

    public TutorialSelector(JFrame parent, URL jarpath, JTextPane textpane, LinkedHashMap<String, URL> additionalEntries) {
        super(parent);
        this.parent = parent;
        this.additionalEntries = additionalEntries;
        this.filepath = null;
        this.jarpath = jarpath;
        if (textpane == null) {
            textpane = new JTextPane();
        }
        this.textpane = textpane;
        this.initGui();
    }

    public TutorialSelector(JDialog parent, URL jarpath, JTextPane textpane, LinkedHashMap<String, URL> additionalEntries) {
        super(parent);
        this.parent = parent;
        this.additionalEntries = additionalEntries;
        this.filepath = null;
        this.jarpath = jarpath;
        if (textpane == null) {
            textpane = new JTextPane();
        }
        this.textpane = textpane;
        this.initGui();
    }

    private void initGui() {
        this.languageResource = ResourceBundle.getBundle("de.anormalmedia.sbstutorial.i18n.TutorialSelector");
        this.setTitle(this.getLabelText("gui.frame.title"));
        this.setModal(true);
        this.setName("de.anormalmedia.sbstutorial.TutorialSelector");
        this.setDefaultCloseOperation(2);
        JPanel content = (JPanel)this.getContentPane();
        content.setLayout(new BorderLayout());
        content.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        content.getActionMap().put("cancel", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                TutorialSelector.this.dispose();
            }
        });
        JPanel roopathpane = new JPanel(new BorderLayout(5, 5));
        roopathpane.setBorder(new EmptyBorder(5, 5, 5, 5));
        content.add((Component)roopathpane, "North");
        JLabel lblPath = new JLabel(this.getLabelText("gui.path.title"));
        roopathpane.add((Component)lblPath, "West");
        this.tfPath = new JTextField(this.filepath != null ? this.filepath : this.getLabelText("gui.path.jarfile"), 30);
        this.tfPath.setEditable(false);
        roopathpane.add((Component)this.tfPath, "Center");
        JButton btPath = new JButton(this.getLabelText("gui.path.browse"));
        btPath.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                File selectedFile;
                File currentPath = new File(TutorialSelector.this.filepath != null ? TutorialSelector.this.filepath : ".");
                JFileChooser fc = new JFileChooser(currentPath);
                fc.setCurrentDirectory(currentPath);
                fc.setAcceptAllFileFilterUsed(false);
                fc.setFileSelectionMode(1);
                int result = fc.showOpenDialog(TutorialSelector.this);
                if (result == 0 && (selectedFile = fc.getSelectedFile()) != null && selectedFile.exists() && selectedFile.isDirectory()) {
                    TutorialSelector.this.textpane.setText("");
                    TutorialSelector.this.filepath = selectedFile.getAbsolutePath();
                    TutorialSelector.this.tfPath.setText(TutorialSelector.this.filepath);
                    TutorialSelector.this.tuts.setModel(new TutorialListModel(TutorialSelector.this.filepath));
                    TutorialSelector.this.markFirstIndex();
                }
            }
        });
        roopathpane.add((Component)btPath, "East");
        JPanel selection = new JPanel();
        selection.setBorder(new EmptyBorder(10, 10, 10, 10));
        selection.setLayout(new BorderLayout());
        selection.add((Component)new JLabel(this.getLabelText("gui.selection.title")), "North");
        TutorialListModel tutorialListModel = null;
        tutorialListModel = this.filepath != null ? new TutorialListModel(this.filepath) : (this.jarpath != null ? new TutorialListModel(this.jarpath) : new TutorialListModel("."));
        if (this.additionalEntries != null) {
            this.addEntries(this.additionalEntries, tutorialListModel);
        }
        this.tuts = new JList(tutorialListModel);
        this.tuts.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component listCellRendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (listCellRendererComponent instanceof JLabel) {
                    String strVal;
                    JLabel lbl = (JLabel)listCellRendererComponent;
                    if (value instanceof String && (strVal = (String)value).matches("^\\d{3,3}\\s.*")) {
                        lbl.setText(strVal.substring(4));
                    }
                }
                return listCellRendererComponent;
            }
        });
        this.tuts.addListSelectionListener(this);
        this.tuts.addMouseListener(this);
        selection.add((Component)new JScrollPane(this.tuts), "Center");
        JPanel preview = new JPanel();
        preview.setBorder(new EmptyBorder(10, 10, 10, 10));
        preview.setLayout(new BorderLayout());
        preview.add((Component)new JLabel(this.getLabelText("gui.preview.title")), "North");
        this.textpane.setContentType("text/html");
        this.textpane.setPreferredSize(new Dimension(300, 300));
        preview.add((Component)new JScrollPane(this.textpane), "Center");
        JSplitPane sp = new JSplitPane(1);
        sp.setLeftComponent(selection);
        sp.setRightComponent(preview);
        content.add((Component)sp, "Center");
        JPanel buttons = new JPanel(new FlowLayout(2));
        content.add((Component)buttons, "South");
        this.btStart = new JButton(this.getLabelText("gui.button.start"));
        this.btStart.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                Object selectedValue = ((TutorialListModel)TutorialSelector.this.tuts.getModel()).getTutorialAt(TutorialSelector.this.tuts.getSelectedIndex());
                if (selectedValue != null && selectedValue instanceof Tutorial) {
                    try {
                        SBSTutorial sbsTutorial = new SBSTutorial();
                        sbsTutorial.setStore(((Tutorial)selectedValue).getStore());
                        sbsTutorial.setParentWindow(TutorialSelector.this.parent);
                        sbsTutorial.setSuppressIntro(true);
                        sbsTutorial.setTextpane(TutorialSelector.this.textpane);
                        sbsTutorial.start();
                        TutorialSelector.this.dispose();
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.btStart.setEnabled(false);
        this.btCancel = new JButton(this.getLabelText("gui.button.cancel"));
        this.btCancel.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                TutorialSelector.this.dispose();
            }
        });
        this.btHelp = new JButton(this.getLabelText("gui.button.help"));
        this.btHelp.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                final JDialog helpdialog = new JDialog((Dialog)TutorialSelector.this, TutorialSelector.this.getLabelText("gui.button.help"));
                helpdialog.setModal(true);
                JPanel helpcontent = (JPanel)helpdialog.getContentPane();
                helpcontent.setLayout(new BorderLayout());
                helpcontent.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancelhelp");
                helpcontent.getActionMap().put("cancelhelp", new AbstractAction(){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent e) {
                        helpdialog.dispose();
                    }
                });
                JTextPane tp = new JTextPane();
                tp.setContentType("text/html");
                tp.setText(TutorialSelector.this.getLabelText("gui.help"));
                tp.setEditable(false);
                tp.setCaretPosition(0);
                helpcontent.add((Component)new JScrollPane(tp), "Center");
                helpdialog.setSize(400, 300);
                helpdialog.setLocationRelativeTo(TutorialSelector.this);
                helpdialog.setVisible(true);
            }
        });
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") == -1) {
            buttons.add(this.btHelp);
            buttons.add(this.btCancel);
            buttons.add(this.btStart);
        } else {
            buttons.add(this.btStart);
            buttons.add(this.btCancel);
            buttons.add(this.btHelp);
        }
        this.pack();
        if (this.parent != null) {
            this.setLocationRelativeTo(this.parent);
        }
        this.markFirstIndex();
        this.setVisible(true);
    }

    public void addExternalResourceBundle(ResourceBundle externalResourceBundle) {
        this.externalResourceBundles.add(externalResourceBundle);
    }

    private void markFirstIndex() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (TutorialSelector.this.tuts.getModel().getSize() > 0) {
                    TutorialSelector.this.tuts.setSelectedIndex(0);
                }
            }
        });
    }

    private String getLabelText(String key) {
        if (this.languageResource == null) {
            return key;
        }
        String value = this.languageResource.getString(key);
        if (value == null) {
            return key;
        }
        return value;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        JList list = (JList)e.getSource();
        final TutorialListModel model = (TutorialListModel)this.tuts.getModel();
        final int index = list.getSelectedIndex();
        Object selectedValue = null;
        URL localTutUrl = null;
        if (index >= 0) {
            selectedValue = model.getTutorialAt(index);
            localTutUrl = model.getUrlAt(index);
        }
        final URL tuturl = localTutUrl;
        this.btStart.setEnabled(selectedValue != null);
        if (selectedValue instanceof Tutorial) {
            Tutorial tutorial = (Tutorial)selectedValue;
            String introDescription = tutorial.getIntroDescription();
            if (introDescription != null) {
                String baseURL = tutorial.getStore().getUrl().toString().substring(0, tutorial.getStore().getUrl().toString().lastIndexOf(47) + 1);
                introDescription = introDescription.replace("<head>", "<head><base href=\"" + baseURL + "\" />");
                this.textpane.setText(introDescription);
            } else {
                this.textpane.setText(this.getLabelText("gui.preview.nointro"));
            }
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
            new Thread(new Runnable(){

                public void run() {
                    String introDescription;
                    Tutorial tutorial;
                    block7: {
                        tutorial = new Tutorial(new URLStore(tuturl), false);
                        model.setTutorialAt(index, tutorial);
                        introDescription = tutorial.getIntroDescription();
                        if (TutorialSelector.this.textpane.isShowing()) break block7;
                        SwingUtilities.invokeLater(new Runnable(model, index){
                            private final /* synthetic */ TutorialListModel val$model;
                            private final /* synthetic */ int val$index;
                            {
                                this.val$model = tutorialListModel;
                                this.val$index = n;
                            }

                            public void run() {
                                TutorialSelector.this.tuts.setEnabled(true);
                                Object selectedValue = this.val$model.getTutorialAt(this.val$index);
                                TutorialSelector.this.btStart.setEnabled(selectedValue != null);
                                TutorialSelector.this.setCursor(Cursor.getDefaultCursor());
                            }
                        });
                        return;
                    }
                    try {
                        try {
                            if (introDescription != null) {
                                String baseURL = tutorial.getStore().getUrl().toString().substring(0, tutorial.getStore().getUrl().toString().lastIndexOf(47) + 1);
                                introDescription = introDescription.replace("<head>", "<head><base href=\"" + baseURL + "\" />");
                                TutorialSelector.this.textpane.setText(introDescription);
                            } else {
                                TutorialSelector.this.textpane.setText(TutorialSelector.this.getLabelText("gui.preview.nointro"));
                            }
                        }
                        catch (Exception e1) {
                            TutorialSelector.this.textpane.setText(TutorialSelector.this.getLabelText("gui.preview.nointro"));
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }).start();
        }
    }

    private void addEntries(HashMap<String, URL> additionalEntries, TutorialListModel model) {
        for (Map.Entry<String, URL> entry : additionalEntries.entrySet()) {
            model.insertAdditionalUrl(entry.getKey(), entry.getValue());
        }
    }

    public static void closeAllSelectors() {
        ArrayList<Window> allWindows = ComponentFinder.getAllWindows();
        if (allWindows != null) {
            for (Window wind : allWindows) {
                if (!(wind instanceof TutorialSelector)) continue;
                TutorialSelector ts = (TutorialSelector)wind;
                ts.dispose();
            }
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setSize(800, 600);
        frame.setLocation(100, 100);
        frame.setVisible(true);
        LinkedHashMap<String, URL> additionalEntries = new LinkedHashMap<String, URL>();
        try {
            additionalEntries.put("anormal media", new URL("http://anormal-media.de"));
            additionalEntries.put("anormal tracker", new URL("http://anormal-tracker.de"));
            additionalEntries.put("bla", new URL("file:D:\\Work\\jnlp\\How_to_create_a_Datasource.tut"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            new TutorialSelector(frame, new URL("file:D:/Work/jnlp/jnlpDesigner/jnlp/Designer.jar"), null, additionalEntries);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        new TutorialSelector(frame, "D:\\Work\\jnlp\\", null, additionalEntries);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.btStart.doClick();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private class TutorialListModel
    extends DefaultListModel {
        private static final long serialVersionUID = 1L;
        private Map<String, Tutorial> data = new HashMap<String, Tutorial>();
        private List<String> titles = new ArrayList<String>();
        private Map<String, URL> urls = new HashMap<String, URL>();

        public TutorialListModel(String filepath) {
            File[] files;
            File path = new File(filepath);
            if (path.isDirectory() && path.exists() && (files = path.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".tut");
                }
            })) != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    try {
                        Tutorial tutorial = new Tutorial(new FileStore(f), false);
                        for (ResourceBundle extRes : TutorialSelector.this.externalResourceBundles) {
                            tutorial.addExternalResourceBundle(extRes);
                        }
                        this.data.put(tutorial.toString(), tutorial);
                        this.titles.add(tutorial.toString());
                        this.urls.put(tutorial.toString(), null);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            Collections.sort(this.titles);
        }

        public TutorialListModel(URL jarpath) {
            JarURLConnection jarUrlCon = null;
            try {
                JarFile jar;
                if (jarpath.toString().toLowerCase().startsWith("jar:")) {
                    URLConnection uc = jarpath.openConnection();
                    jarUrlCon = (JarURLConnection)uc;
                    jar = jarUrlCon.getJarFile();
                } else {
                    try {
                        URL jarUrl = new URL("jar", "", -1, String.valueOf(jarpath.toString()) + "!/");
                        URLConnection uc = jarUrl.openConnection();
                        jarUrlCon = (JarURLConnection)uc;
                        jar = jarUrlCon.getJarFile();
                    }
                    catch (IOException e1) {
                        URL jarUrl = new URL("jar", "", -1, String.valueOf(URLDecoder.decode(jarpath.toString(), "UTF-8")) + "!/");
                        URLConnection uc = jarUrl.openConnection();
                        jarUrlCon = (JarURLConnection)uc;
                        jar = jarUrlCon.getJarFile();
                    }
                }
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry next = entries.nextElement();
                    if (!next.getName().endsWith(".tut")) continue;
                    try {
                        URL tutJarUrl = null;
                        try {
                            tutJarUrl = new URL("jar", "", -1, jarUrlCon.getJarFileURL() + "!/" + next.getName());
                        }
                        catch (IOException e1) {
                            tutJarUrl = new URL("jar", "", -1, String.valueOf(URLDecoder.decode(jarUrlCon.getJarFileURL().toString(), "UTF-8")) + "!/" + next.getName());
                        }
                        Tutorial tutorial = new Tutorial(new URLStore(tutJarUrl), false);
                        for (ResourceBundle extRes : TutorialSelector.this.externalResourceBundles) {
                            tutorial.addExternalResourceBundle(extRes);
                        }
                        this.data.put(tutorial.toString(), tutorial);
                        this.titles.add(tutorial.toString());
                        this.urls.put(tutorial.toString(), null);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            Collections.sort(this.titles);
        }

        public Object getTutorialAt(int index) {
            if (index < 0 || index > this.titles.size() - 1) {
                return null;
            }
            String titleKey = this.titles.get(index);
            if (titleKey == null) {
                return null;
            }
            return this.data.get(titleKey);
        }

        public URL getUrlAt(int index) {
            return this.urls.get(this.titles.get(index));
        }

        public Object getElementAt(int index) {
            return this.titles.get(index);
        }

        public int getSize() {
            return this.titles.size();
        }

        public void insertAdditionalUrl(String tit, URL url) {
            for (Tutorial tut : this.data.values()) {
                String valPath;
                if (tut == null) continue;
                URL val = tut.getStore().getUrl();
                String path = url.getPath();
                int lastIndexOf = path.lastIndexOf(47);
                if (lastIndexOf != -1) {
                    path = path.substring(lastIndexOf + 1);
                }
                if ((valPath = val.getPath()).endsWith("!/")) {
                    valPath = valPath.substring(0, valPath.length() - 2);
                }
                if (!valPath.endsWith(path)) continue;
                return;
            }
            for (URL val : this.urls.values()) {
                if (val == null) continue;
                String path = url.getPath();
                int lastIndexOf = path.lastIndexOf(47);
                if (lastIndexOf != -1) {
                    path = path.substring(lastIndexOf + 1);
                }
                if (!val.getPath().endsWith(path)) continue;
                return;
            }
            boolean canInstantiate = true;
            URLConnection conn = null;
            try {
                conn = url.openConnection();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (conn instanceof JarURLConnection) {
                JarURLConnection jarCon = (JarURLConnection)conn;
                URL jarFileURL = jarCon.getJarFileURL();
                if (jarFileURL.getProtocol().startsWith("http")) {
                    canInstantiate = false;
                }
            } else if (url.getProtocol().startsWith("http")) {
                canInstantiate = false;
            }
            Tutorial tutorial = null;
            if (canInstantiate) {
                try {
                    tutorial = new Tutorial(new URLStore(url), false);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (tutorial != null) {
                for (ResourceBundle extRes : TutorialSelector.this.externalResourceBundles) {
                    tutorial.addExternalResourceBundle(extRes);
                }
                this.data.put(tutorial.toString(), tutorial);
                this.titles.add(tutorial.toString());
                this.urls.put(tutorial.toString(), null);
            } else {
                String tutTitle = tit;
                if ((tutTitle = tutTitle.replace('_', ' ')).toLowerCase().endsWith(".tut")) {
                    tutTitle = tutTitle.substring(0, tutTitle.length() - 4);
                }
                StringTokenizer tokenizer = new StringTokenizer(tutTitle, " ");
                StringBuilder b = new StringBuilder();
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (b.length() > 0) {
                        b.append(' ');
                    }
                    if (token.length() > 0) {
                        b.append(Character.toTitleCase(token.charAt(0)));
                    }
                    if (token.length() <= 1) continue;
                    b.append(token.substring(1));
                }
                tutTitle = b.toString();
                this.titles.add(tutTitle);
                this.data.put(tutTitle, null);
                this.urls.put(tutTitle, url);
            }
            Collections.sort(this.titles);
        }

        public void setTutorialAt(int index, Tutorial tutorial) {
            this.urls.put(this.titles.get(index), null);
            this.data.put(this.titles.get(index), tutorial);
        }
    }
}

