/*
 * Decompiled with CFR 0.152.
 */
package de.anormalmedia.sbstutorial.gui.recorder;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTree
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTree mtree = new JTree(new DefaultTreeModel(null));
    private DefaultMutableTreeNode lastchild;

    public ComponentTree() {
        super(new BorderLayout());
        this.add((Component)new JScrollPane(this.mtree), "Center");
    }

    public void listComponents(AWTEvent event) {
        DefaultMutableTreeNode child = null;
        this.lastchild = null;
        ArrayList<Component> comps = new ArrayList<Component>();
        Object source = event.getSource();
        if (source != null && source instanceof Component) {
            comps.add((Component)source);
            this.findParentComponent((Component)source, comps);
            for (Component cmp : comps) {
                DefaultMutableTreeNode tn = new DefaultMutableTreeNode(cmp);
                if (this.lastchild == null) {
                    this.lastchild = tn;
                }
                if (child != null) {
                    tn.add(child);
                }
                child = tn;
            }
        }
        this.mtree.setModel(new DefaultTreeModel(child));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)ComponentTree.this.lastchild.getParent();
                if (defaultMutableTreeNode != null) {
                    ComponentTree.this.mtree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
                }
            }
        });
    }

    private void findParentComponent(Component source, ArrayList<Component> comps) {
        if (!source.isShowing()) {
            return;
        }
        Container cparent = source.getParent();
        if (cparent != null) {
            comps.add(cparent);
            this.findParentComponent(cparent, comps);
        }
    }
}

