/*
 * Decompiled with CFR 0.152.
 */
package de.anormalmedia.sbstutorial.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentFinder {
    public static Component findComponent(String classname, String name) {
        try {
            Class<?> loadClass = ComponentFinder.class.getClassLoader().loadClass(classname);
            ArrayList<Window> windows = ComponentFinder.getAllWindows();
            for (Window f : windows) {
                Component cmp = ComponentFinder.getCmp(f, loadClass, name);
                if (cmp == null) continue;
                return cmp;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ArrayList<Window> getAllWindows() {
        Frame[] frames;
        ArrayList<Window> windows = new ArrayList<Window>();
        Frame[] frameArray = frames = Frame.getFrames();
        int n = frames.length;
        int n2 = 0;
        while (n2 < n) {
            Frame f = frameArray[n2];
            ComponentFinder.getOwnedWindows(f, windows);
            ++n2;
        }
        return windows;
    }

    private static ArrayList<Window> getOwnedWindows(Window pw, ArrayList<Window> windows) {
        windows.add(0, pw);
        Window[] ownedWindows = pw.getOwnedWindows();
        if (ownedWindows != null) {
            Window[] windowArray = ownedWindows;
            int n = ownedWindows.length;
            int n2 = 0;
            while (n2 < n) {
                Window w = windowArray[n2];
                ComponentFinder.getOwnedWindows(w, windows);
                ++n2;
            }
        }
        return windows;
    }

    public static Class<?> getAwtSwingClass(Class<?> currClass) {
        Class<?> theclass = currClass;
        do {
            String classname;
            if (!(classname = theclass.toString()).startsWith("class javax.swing.") && !classname.startsWith("class java.awt.")) continue;
            return theclass;
        } while ((theclass = theclass.getSuperclass()) != null);
        return currClass;
    }

    private static Component getCmp(Component parent, Class<?> loadClass, String name) {
        if (ComponentFinder.getAwtSwingClass(parent.getClass()).equals(loadClass) && (parent.getName() != null && parent.getName().matches(name) || parent.getName() == null && name.equals("null")) && parent.isShowing()) {
            return parent;
        }
        if (parent instanceof Container) {
            Component[] componentArray = ((Container)parent).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component cmp = componentArray[n2];
                Component deepcmp = ComponentFinder.getCmp(cmp, loadClass, name);
                if (deepcmp != null) {
                    return deepcmp;
                }
                ++n2;
            }
        }
        return null;
    }
}

