/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.datasources.server.data;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.id.GUID;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.plugins.datasources.DatasourcesServerPlugin;
import com.inet.report.plugins.datasources.server.data.datasource.DatasourceValueHolder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class GetDatasourceResponseData {
    private GUID uuid;
    private String title;
    private Map<String, List<DatasourceValueHolder>> data = new LinkedHashMap<String, List<DatasourceValueHolder>>();
    private Map<String, String> localization = new HashMap<String, String>();
    private Boolean readonly;

    public GetDatasourceResponseData(DataSourceConfiguration configuration, String title) {
        this.uuid = configuration.getUID();
        this.readonly = DatasourcesServerPlugin.isRestricted(configuration);
        this.title = title;
    }

    public void addLocalization(LocalizedKey entry) {
        if (entry.getDisplayName() == null || entry.getDisplayName().length() == 0) {
            entry.setLabel(DatasourcesServerPlugin.CONFIG_MSG.getMsg(entry.getKey(), new Object[0]));
        }
        this.localization.put(entry.getKey(), entry.getDisplayName().trim());
    }

    public void addDatasourceSetting(@Nonnull String categoryKey, @Nullable DatasourceValueHolder setting) {
        if (setting == null) {
            return;
        }
        List list = this.data.computeIfAbsent(categoryKey, k2 -> new LinkedList());
        Objects.requireNonNull(list);
        list.add(setting);
    }

    public GUID getUuid() {
        return this.uuid;
    }

    public Boolean getReadonly() {
        return this.readonly;
    }

    public Map<String, List<DatasourceValueHolder>> getData() {
        return this.data;
    }

    public Map<String, String> getLocalization() {
        return this.localization;
    }

    public String getTitle() {
        return this.title;
    }
}

