/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.datasources.backup;

import com.inet.classloader.I18nMessages;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.plugin.ApplicationDescription;
import com.inet.report.ReportException;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.shared.utils.Version;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public class a
implements BackupTask {
    public static final I18nMessages MSG = new I18nMessages("com.inet.report.plugins.datasources.backup.LanguageResources", a.class);

    public String getKey() {
        return "report.datasources";
    }

    public String getTitle() {
        return MSG.getMsg("backup.task.datasources.title", new Object[0]);
    }

    public String getDescription() {
        return MSG.getMsg("backup.task.datasources.description", new Object[0]);
    }

    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/report/plugins/datasources/client/images/datasources_32.png");
    }

    public void execute(Path taskPath, BackupRunningStatus runningStatus, BackupContentInformation contentInformation, ProgressUpdater progressUpdater) throws Throwable {
        progressUpdater.updateProgress(0);
        this.a(taskPath, "system.xml", 1, contentInformation);
        progressUpdater.updateProgress(33);
        this.a(taskPath, "user.xml", 2, contentInformation);
        progressUpdater.updateProgress(66);
        this.a(taskPath, "application.xml", 7, contentInformation);
        progressUpdater.updateProgress(100);
    }

    private void a(Path path, String string, int n, BackupContentInformation backupContentInformation) throws ReportException {
        DataSourceConfiguration[] dataSourceConfigurationArray = DataSourceConfigurationManager.getDataSourceConfigurations((int)n);
        if (dataSourceConfigurationArray.length > 0) {
            File file = path.resolve(string).toFile();
            DataSourceConfigurationManager.exportDataSourceConfigurations((DataSourceConfiguration[])dataSourceConfigurationArray, (File)file);
        }
        backupContentInformation.addTaskDetails(this.getKey(), MSG.getMsg("backup.task.datasources.taskdetail", new Object[]{dataSourceConfigurationArray.length, n}));
    }

    public void restore(Path taskPath, BackupRunningStatus runningStatus, ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        progressUpdater.updateProgress(0);
        this.a(taskPath, "application.xml", 7);
        progressUpdater.updateProgress(33);
        this.a(taskPath, "user.xml", 2);
        progressUpdater.updateProgress(66);
        this.a(taskPath, "system.xml", 1);
        progressUpdater.updateProgress(100);
    }

    private void a(Path path, String string, int n) throws Exception {
        File file = path.resolve(string).toFile();
        if (file.exists()) {
            try {
                DataSourceConfigurationManager.forceImportDataSourceConfigurations((int)n, (File)file);
            }
            catch (SecurityException securityException) {
                if (DataSourceConfigurationManager.isWriteable((int)n)) {
                    throw securityException;
                }
                throw new SecurityException(MSG.getMsg("backup.task.datasources.writeProtected", new Object[]{n}), securityException);
            }
        }
    }

    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("8.3")) && ApplicationDescription.get().getVersion().isHigherOrEquals(backupVersion);
    }
}

