/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.datasources.server.webapi.model;

import com.inet.annotations.JsonData;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.widget.DriverStyleSheetFactory;
import com.inet.report.plugins.datasources.DatasourcesServerPlugin;
import com.inet.report.plugins.datasources.server.data.DatasourceListEntry;
import com.inet.report.plugins.datasources.server.utils.a;
import com.inet.usersandgroups.UsersAndGroups;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@JsonData
@Schema(description="Detailed information about a datasource")
public class DatasourceWebAPIEntry {
    @Schema(description="The title of the datasource")
    private String title;
    @Schema(description="The alias name of the datasource")
    private String alias;
    @Schema(description="The unique identifier of the datasource")
    private GUID uuid;
    @Schema(description="The set of permission GUIDs associated with this datasource")
    private Set<GUID> permissions;
    @Schema(description="The type of the datasource")
    private String type;
    @Schema(description="Whether the datasource is read-only")
    private Boolean readonly = Boolean.FALSE;
    @Schema(description="Additional configuration information for the datasource")
    private Map<String, String> additionalInformation;

    public static DatasourceWebAPIEntry fromDatasource(DataSourceConfiguration configuration) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(configuration.getDriverSpecificProperties()));
        a.a(arrayList);
        for (String string : arrayList) {
            String string2 = configuration.getProperty(string);
            if (string2 == null || string2.trim().length() == 0) continue;
            hashMap.put(string, string2);
        }
        DatasourceWebAPIEntry datasourceWebAPIEntry = new DatasourceWebAPIEntry();
        datasourceWebAPIEntry.title = datasourceWebAPIEntry.alias = configuration.getConfigurationName();
        datasourceWebAPIEntry.uuid = configuration.getUID();
        datasourceWebAPIEntry.type = DatasourceListEntry.getDriverDisplayName(configuration, DriverStyleSheetFactory.getInstance((Locale)ClientLocale.getThreadLocale()));
        datasourceWebAPIEntry.additionalInformation = hashMap;
        datasourceWebAPIEntry.readonly = DatasourcesServerPlugin.isRestricted(configuration);
        if (ServerPluginManager.getInstance().isPluginLoaded("usersandgroupsmanager") && SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER) && !DatasourcesServerPlugin.isRestricted(configuration).booleanValue() && (configuration.getScope() == 7 || configuration.getScope() == 0)) {
            datasourceWebAPIEntry.permissions = configuration.getAllowedUserGroups();
        }
        return datasourceWebAPIEntry;
    }
}

