/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.datasources.server.webapi.guid;

import com.inet.id.GUID;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.plugin.webapi.api.handler.RequestHandlerWithGUIDPathToken;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.plugins.datasources.server.data.datasource.DatasourceData;
import com.inet.report.plugins.datasources.server.webapi.guid.b;
import com.inet.report.plugins.datasources.server.webapi.model.DatasourceWebAPIEntry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nullable;

@Tag(name="Datasources", description="Operations for managing datasources")
public class a
extends RequestHandlerWithGUIDPathToken<Void, DatasourceWebAPIEntry> {
    public a() {
        super(new String[]{"datasource"});
        this.registerRequestHandler((RequestHandlerBase)new b());
    }

    public String getHelpPageKey() {
        return "datasources.api.guid";
    }

    @Operation(summary="Get datasource details by GUID", description="Retrieves detailed information about a specific datasource identified by its GUID")
    @ApiResponse(responseCode="200", description="Successfully retrieved datasource details", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatasourceWebAPIEntry.class))})
    public DatasourceWebAPIEntry a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Void void_, @Parameter(description="GUID of the datasource to retrieve", required=true) @Nullable GUID gUID, boolean bl) throws IOException {
        DatasourceData datasourceData = new DatasourceData();
        datasourceData.setDatasourceId(gUID);
        DataSourceConfiguration dataSourceConfiguration = datasourceData.asTempDatasourceConfiguration(null);
        return DatasourceWebAPIEntry.fromDatasource(dataSourceConfiguration);
    }

    @Operation(summary="Get datasource details by GUID", description="Retrieves detailed information about a specific datasource identified by its GUID")
    @ApiResponse(responseCode="200", description="Successfully retrieved datasource details", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatasourceWebAPIEntry.class))})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Parameter(description="GUID of the datasource to retrieve", required=true) @Nullable Object object2, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (Void)object, (GUID)object2, bl);
    }
}

