/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.datasources.server.webapi;

import com.inet.lib.json.JsonException;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.report.plugins.datasources.server.base.d;
import com.inet.report.plugins.datasources.server.data.GetDatasourceListRequestData;
import com.inet.report.plugins.datasources.server.data.GetDatasourceListResponseData;
import com.inet.report.plugins.datasources.server.webapi.model.DatasourceWebAPIListEntry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Tag(name="Datasources", description="Operations for managing datasources")
public class c
extends RequestHandler<Void, List<DatasourceWebAPIListEntry>> {
    public c() {
        super(new String[]{"list"});
    }

    public String getHelpPageKey() {
        return "datasources.api.list";
    }

    @Operation(summary="List all available datasources", description="Returns a list of all datasources that are available to the current user")
    @ApiResponse(responseCode="200", description="Successfully retrieved datasource list", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=DatasourceWebAPIListEntry.class)))})
    public List<DatasourceWebAPIListEntry> b(@Nullable HttpServletRequest httpServletRequest, @Nullable HttpServletResponse httpServletResponse, @Nullable Void void_, boolean bl) throws IOException {
        d d2 = new d();
        GetDatasourceListRequestData getDatasourceListRequestData = new GetDatasourceListRequestData();
        try {
            getDatasourceListRequestData = (GetDatasourceListRequestData)d2.a(httpServletRequest);
        }
        catch (JsonException | EOFException throwable) {
            // empty catch block
        }
        GetDatasourceListResponseData getDatasourceListResponseData = d2.a(getDatasourceListRequestData);
        return getDatasourceListResponseData.getDataEntries().stream().map(datasourceListEntry -> DatasourceWebAPIListEntry.from(datasourceListEntry)).collect(Collectors.toList());
    }

    @Operation(summary="List all available datasources", description="Returns a list of all datasources that are available to the current user")
    @ApiResponse(responseCode="200", description="Successfully retrieved datasource list", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=DatasourceWebAPIListEntry.class)))})
    public /* synthetic */ Object handle(@Nullable HttpServletRequest httpServletRequest, @Nullable HttpServletResponse httpServletResponse, @Nullable Object object, boolean bl) throws IOException {
        return this.b(httpServletRequest, httpServletResponse, (Void)object, bl);
    }
}

