/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.mongodb;

import com.inet.annotations.InternalApi;
import com.inet.lib.util.StringFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.database.sql.SqlSyntax;
import com.inet.report.mongodb.a;
import com.inet.report.mongodb.c;
import com.inet.shared.utils.WeakValueMap;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;

@InternalApi
public class MongoDbDataFactory
extends BaseDataFactory {
    private static final WeakValueMap<String, a> c = new WeakValueMap(new ConcurrentHashMap());
    private static String d;

    @Nonnull
    public String getVersion() {
        if (d == null) {
            try {
                Class<MongoClient> clazz = MongoClient.class;
                String string = "/" + clazz.getName().replace('.', '/') + ".class";
                String string2 = clazz.getResource(string).toString();
                String string3 = string2.replace(string, "/META-INF/MANIFEST.MF");
                try (InputStream inputStream = new URL(string3).openStream();){
                    Manifest manifest = new Manifest(inputStream);
                    Attributes attributes = manifest.getMainAttributes();
                    d = attributes.getValue("Build-Version");
                }
            }
            catch (IOException iOException) {
                BaseUtils.error((Object)iOException);
            }
            if (d == null) {
                d = "";
            }
        }
        return d;
    }

    public boolean supportsCommands() {
        return true;
    }

    public SqlSyntax getSqlSyntax() {
        return new Database(){

            public String getValidateMessage(String query) {
                try {
                    BasicDBObject basicDBObject = BasicDBObject.parse((String)query);
                    String string = (String)basicDBObject.remove((Object)"find");
                    if (string == null) {
                        return "MongoDB command is not safe. \"find\" is missing!";
                    }
                }
                catch (Exception exception) {
                    return StringFunctions.getUserFriendlyErrorMessage((Throwable)exception);
                }
                return null;
            }
        };
    }

    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(Datasource ds, String catalog) throws ReportException {
        HashMap<String, TableSourceInfo> hashMap = new HashMap<String, TableSourceInfo>();
        a a2 = this.b(ds.getDataSourceConfiguration());
        for (String string : a2.b()) {
            MongoDatabase mongoDatabase = a2.a(string);
            for (String string2 : mongoDatabase.listCollectionNames()) {
                String string3 = string + "." + string2;
                hashMap.put(string3, new TableSourceInfo(null, string, string2, 0));
            }
        }
        return hashMap;
    }

    public List<ColumnInfo> getColumns(TableSource ts) throws ReportException {
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
        a a2 = this.b(ts.getDatasource().getDataSourceConfiguration());
        Document document = (Document)this.a(a2, ts).first();
        if (document == null) {
            throw new ReportException("Can not request table meta information from an empty collection", 0);
        }
        for (Map.Entry entry : document.entrySet()) {
            Object v = entry.getValue();
            int n = v instanceof Number ? 6 : 11;
            arrayList.add(new ColumnInfo((String)entry.getKey(), n));
        }
        return arrayList;
    }

    public TableData getTableSourceData(TableSource ts) throws ReportException {
        a a2 = this.b(ts.getDatasource().getDataSourceConfiguration());
        FindIterable<Document> findIterable = this.a(a2, ts);
        c c2 = com.inet.report.mongodb.c.a(findIterable, a2);
        return new TableData((ResultSet)((Object)c2));
    }

    private FindIterable<Document> a(@Nonnull a a2, TableSource tableSource) throws ReportException {
        String string;
        int n;
        BsonDocument bsonDocument;
        String string2;
        String string3;
        switch (tableSource.getType()) {
            case 3: {
                string3 = tableSource.getSqlWithPromptFieldValues();
                BasicDBObject basicDBObject = BasicDBObject.parse((String)string3);
                string2 = (String)basicDBObject.remove((Object)"find");
                if (string2 == null) {
                    throw new IllegalStateException("No \"find\": in command: " + string3);
                }
                bsonDocument = null;
                try {
                    bsonDocument = (Bson)basicDBObject.get("filter");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (bsonDocument != null) break;
                bsonDocument = basicDBObject;
                break;
            }
            case 1: {
                string2 = tableSource.getDatabaseIdentifier();
                bsonDocument = new BsonDocument();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported TableSource type: " + tableSource.getType());
            }
        }
        if ((n = string2.indexOf(46)) > 0) {
            string = string2.substring(0, n);
            if (a2.b(string)) {
                string3 = string2.substring(n + 1);
            } else {
                string = null;
                string3 = string2;
            }
        } else {
            string = null;
            string3 = string2;
        }
        BaseUtils.info((Object)("MongoDB find: Database: " + string + ", Collection: " + string3 + ", Filter: " + String.valueOf(bsonDocument)));
        MongoDatabase mongoDatabase = this.a(a2, string);
        MongoCollection mongoCollection = mongoDatabase.getCollection(string3);
        return mongoCollection.find((Bson)bsonDocument);
    }

    @Nonnull
    private String a(DataSourceConfiguration dataSourceConfiguration) {
        Objects.requireNonNull(dataSourceConfiguration, "DataSourceConfiguration is null");
        Object object = dataSourceConfiguration.getProperty("uri");
        String string = dataSourceConfiguration.getUser();
        String string2 = dataSourceConfiguration.getPassword();
        if (!StringFunctions.isEmpty((String)string)) {
            int n = ((String)object).indexOf("://") + 3;
            int n2 = ((String)object).indexOf("@", n);
            int n3 = ((String)object).indexOf("/", n);
            if (n2 > 0 && (n2 < n3 || n3 < 0)) {
                object = ((String)object).substring(0, n) + string + ":" + string2 + ((String)object).substring(n2);
            } else if (n > 3) {
                object = ((String)object).substring(0, n) + string + ":" + string2 + "@" + ((String)object).substring(n);
            }
        }
        return object;
    }

    @Nonnull
    private a b(DataSourceConfiguration dataSourceConfiguration) throws ReportException {
        String string = this.a(dataSourceConfiguration);
        a a2 = (a)c.get((Object)string);
        if (a2 == null) {
            a2 = new a(string);
            c.put((Object)string, (Object)a2);
        }
        return a2;
    }

    private MongoDatabase a(@Nonnull a a2, @Nullable String string) throws ReportException {
        if (StringFunctions.isEmpty((String)string)) {
            string = a2.a();
        }
        if (StringFunctions.isEmpty((String)string)) {
            throw new ReportException("No database name was declared in the MongDB URI and table source", 0);
        }
        return a2.a(string);
    }
}

