/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.dataimport.server.handler;

import com.inet.field.Field;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.dataimport.server.data.DataImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.data.ExamplesResponseData;
import com.inet.helpdesk.plugins.dataimport.server.data.UserImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.handler.AbstractDataImportHandler;
import com.inet.helpdesk.plugins.dataimport.server.handler.FieldDescription;
import com.inet.helpdesk.usersandgroups.HDFieldLocator;
import com.inet.http.servlet.ClientLocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class GetUserExamplesHandler
extends AbstractDataImportHandler<UserImportEntry, ExamplesResponseData> {
    public String getMethodName() {
        return "dataimport_getuserexamples";
    }

    @Override
    public ExamplesResponseData invoke(DataImportConnector importConnector, UserImportEntry data) throws ServerDataException {
        final List<com.inet.helpdesk.shared.model.Field> userFields = Arrays.asList(DataImportConnector.USER_IMPORT_FIELDS);
        ArrayList<ArrayList<DataImportEntry.MappingEntry>> examples = new ArrayList<ArrayList<DataImportEntry.MappingEntry>>();
        ExamplesResponseData response = new ExamplesResponseData();
        UserImportConfigInfo uici = this.convertUserImport(data);
        List samples = importConnector.getExamples(uici);
        if (samples != null) {
            Collections.sort(samples, new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> o1, Map<String, String> o2) {
                    return o2.size() - o1.size();
                }
            });
            if (samples.size() > 6) {
                samples = samples.subList(0, 6);
            }
            for (Map sample : samples) {
                ArrayList<DataImportEntry.MappingEntry> entry = new ArrayList<DataImportEntry.MappingEntry>();
                Set sampleKeys = sample.keySet();
                TreeSet<String> keys = new TreeSet<String>(new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        int index1 = this.calcIndex(o1);
                        int index2 = this.calcIndex(o2);
                        return index1 - index2;
                    }

                    private int calcIndex(String fieldKey) {
                        if ("SecondUsername".equals(fieldKey)) {
                            return 1;
                        }
                        com.inet.helpdesk.shared.model.Field fi = com.inet.helpdesk.shared.model.Field.valueOfKey((String)fieldKey, (String)"USERDATA");
                        int index = userFields.indexOf(fi) > -1 ? userFields.indexOf(fi) : DataImportConnector.USER_IMPORT_FIELDS.length;
                        return index > 0 ? ++index : index;
                    }
                });
                keys.addAll(sampleKeys);
                Iterator<String> iterator = keys.iterator();
                while (iterator.hasNext()) {
                    String key;
                    String label = key = iterator.next();
                    com.inet.helpdesk.shared.model.Field f = com.inet.helpdesk.shared.model.Field.valueOfKey((String)key, (String)"USERDATA");
                    if (f != null) {
                        Field apiField = HDFieldLocator.getFieldForOldDbField((com.inet.helpdesk.shared.model.Field)f);
                        if (apiField != null) {
                            label = apiField.getLabel();
                        }
                    } else if ("Supervisor".equals(key)) {
                        label = "de".equals(ClientLocale.getThreadLocale().getLanguage()) ? "Supervisor von" : "Supervisor of";
                    } else if ("SecondUsername".equals(key)) {
                        label = "de".equals(ClientLocale.getThreadLocale().getLanguage()) ? "Alternatives Login" : "Alternative login";
                    }
                    entry.add(new DataImportEntry.MappingEntry(new FieldDescription(key, label), (String)sample.get(key)));
                }
                entry.add(new DataImportEntry.MappingEntry(new FieldDescription("IMAGE", "IMAGE"), (String)sample.get("IMAGE")));
                examples.add(entry);
            }
        }
        response.setExamples(examples);
        return response;
    }
}

