/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.dataimport.server.handler;

import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.config.DeviceImportConfigInfoMap;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.model.dataimport.ConnectionEntry;
import com.inet.helpdesk.plugins.dataimport.HelpDeskDataImportPlugin;
import com.inet.helpdesk.plugins.dataimport.server.data.DataImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.data.ExecuteRequestData;
import com.inet.helpdesk.plugins.dataimport.server.handler.AbstractDataImportHandler;
import java.io.IOException;
import java.util.Map;

public class ExecuteImportHandler
extends AbstractDataImportHandler<ExecuteRequestData, Void> {
    public String getMethodName() {
        return "dataimport_executeimport";
    }

    @Override
    public Void invoke(DataImportConnector importConnector, ExecuteRequestData data) throws IOException, ServerDataException {
        block5: {
            ConnectionEntry connEntry;
            String id;
            block6: {
                id = data.getId();
                connEntry = data.getConnection();
                if (id == null || id.isEmpty() || connEntry == null) {
                    HelpDeskDataImportPlugin.LOGGER.warn((Object)"No id or connection set. Import can not be started.");
                    return null;
                }
                if (data.getType() != DataImportEntry.TYPE.DEVICE) break block6;
                DeviceImportConfigInfoMap deviceImports = importConnector.getDeviceImports();
                for (Map.Entry entry : deviceImports.entrySet()) {
                    String name = (String)entry.getKey();
                    Object currentID = ((DeviceImportConfigInfo)entry.getValue()).getUid();
                    if (currentID == null) {
                        currentID = DataImportEntry.TYPE.DEVICE.name() + "." + (String)entry.getKey();
                    }
                    if (!id.equals(currentID)) continue;
                    importConnector.startDeviceImport((DeviceImportConfigInfo)entry.getValue(), name, connEntry);
                    break block5;
                }
                break block5;
            }
            if (data.getType() != DataImportEntry.TYPE.USER) break block5;
            UserImportConfigInfoMap userImports = importConnector.getUserImports();
            for (Map.Entry entry : userImports.entrySet()) {
                Object currentID = ((UserImportConfigInfo)entry.getValue()).getUid();
                if (currentID == null) {
                    currentID = DataImportEntry.TYPE.USER.name() + "." + (String)entry.getKey();
                }
                if (!id.equals(currentID)) continue;
                importConnector.startUserImport((UserImportConfigInfo)entry.getValue(), (String)currentID, connEntry);
                break;
            }
        }
        return null;
    }
}

