/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.dataimport.server.handler;

import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.config.DeviceImportConfigInfoMap;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.dataimport.server.data.DataImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.data.DeleteRequestData;
import com.inet.helpdesk.plugins.dataimport.server.handler.AbstractDataImportHandler;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.search.SearchResult;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class DeleteImportHandler
extends AbstractDataImportHandler<DeleteRequestData, Void> {
    public String getMethodName() {
        return "dataimport_deleteimport";
    }

    @Override
    public Void invoke(DataImportConnector importConnector, DeleteRequestData data) throws IOException, ServerDataException {
        if (data.getType() == DataImportEntry.TYPE.DEVICE) {
            DeviceImportConfigInfoMap deviceImports = importConnector.getDeviceImports();
            String id = data.getId();
            if (id != null) {
                Iterator iterator = deviceImports.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    DeviceImportConfigInfo value = (DeviceImportConfigInfo)entry.getValue();
                    Object currentID = value.getUid();
                    if (currentID == null) {
                        currentID = DataImportEntry.TYPE.DEVICE.name() + "." + (String)entry.getKey();
                    }
                    if (!id.equals(currentID)) continue;
                    iterator.remove();
                    break;
                }
                importConnector.saveDeviceImports(deviceImports);
            }
        } else if (data.getType() == DataImportEntry.TYPE.USER) {
            UserImportConfigInfoMap userImports = importConnector.getUserImports();
            String id = data.getId();
            if (id != null) {
                Iterator iterator = userImports.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    UserImportConfigInfo value = (UserImportConfigInfo)entry.getValue();
                    Object currentID = value.getUid();
                    if (currentID == null) {
                        currentID = DataImportEntry.TYPE.USER.name() + "." + (String)entry.getKey();
                    }
                    if (!id.equals(currentID)) continue;
                    iterator.remove();
                    break;
                }
                importConnector.saveUserImports(userImports);
                this.removeReferencesToImportInUsers(id);
            }
        }
        return null;
    }

    private void removeReferencesToImportInUsers(String id) {
        IndexSearchEngine engine = UserManager.getInstance().getSearchEngine();
        SearchResult userIds = engine.search(new SearchCommand("importname", SearchCondition.SearchTermOperator.Equals, (Object)id));
        userIds.getEntries().forEach(entry -> {
            MutableUserData userData = new MutableUserData();
            userData.put((UserField)HDUsersAndGroups.FIELD_IMPORT_NAME, (Object)"");
            UserManager.getInstance().updateUserData((GUID)entry.getId(), userData);
        });
    }
}

