/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.dataimport.server.handler;

import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.config.DeviceImportConfigInfoMap;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.dataimport.HelpDeskDataImportPlugin;
import com.inet.helpdesk.plugins.dataimport.server.data.DataImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.data.DeviceImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.data.SaveDataResponseData;
import com.inet.helpdesk.plugins.dataimport.server.handler.AbstractDataImportHandler;
import com.inet.helpdesk.plugins.dataimport.server.handler.DeviceImportHelper;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class SaveDeviceImportHandler
extends AbstractDataImportHandler<DeviceImportEntry, SaveDataResponseData> {
    public String getMethodName() {
        return "dataimport_savedeviceimport";
    }

    @Override
    public SaveDataResponseData invoke(DataImportConnector importConnector, DeviceImportEntry data) throws IOException, ServerDataException {
        if (data.getName() == null || data.getName().isEmpty()) {
            throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("save.dataimport.noname", new Object[0]));
        }
        if (data.getDeviceType() == null) {
            throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("save.dataimport.nodevice", new Object[0]));
        }
        if (data.getConnection() == null) {
            throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("save.dataimport.noconnection", new Object[0]));
        }
        if (StringFunctions.isEmpty((String)data.getTable())) {
            throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("save.dataimport.nodevicetable", new Object[0]));
        }
        if (DataImportConnector.ConnectionType.database.equals((Object)data.getConnection().getConnectionType()) && StringFunctions.isEmpty((String)data.getUniqueKey())) {
            throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("save.dataimport.nokeycolum", new Object[0]));
        }
        if (data.getUsername() == null && !data.isIgnoreUser()) {
            throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("save.dataimport.nousernamecolumn", new Object[0]));
        }
        if (this.hasInvalidSchedule(data.getSchedule())) {
            throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("save.dataimport.schedule.invalid", new Object[]{data.getName()}));
        }
        DeviceImportConfigInfoMap deviceImports = importConnector.getDeviceImports();
        String id = data.getId();
        for (String name : deviceImports.keySet()) {
            if (!name.equals(data.getName()) || id != null && id.equals(((DeviceImportConfigInfo)deviceImports.get((Object)name)).getUid())) continue;
            throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("save.deviceimport.nameexists", new Object[]{data.getName()}));
        }
        DeviceImportConfigInfo dici = DeviceImportHelper.convertDeviceImport(data);
        if (this.hasNoNameColumn(dici)) {
            throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("save.dataimport.nonamecolumn", new Object[0]));
        }
        if (id != null) {
            Iterator iterator = deviceImports.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Object currentID = ((DeviceImportConfigInfo)entry.getValue()).getUid();
                if (currentID == null) {
                    currentID = DataImportEntry.TYPE.DEVICE.name() + "." + (String)entry.getKey();
                }
                if (!id.equals(currentID)) continue;
                iterator.remove();
                break;
            }
        }
        deviceImports.put((Object)data.getName(), (Object)dici);
        importConnector.saveDeviceImports(deviceImports);
        return new SaveDataResponseData(dici.getUid());
    }

    private boolean hasNoNameColumn(DeviceImportConfigInfo data) {
        Map userSelectedMapping = data.getUserSelectedMapping();
        return StringFunctions.isEmpty((String)((String)userSelectedMapping.get("name")));
    }
}

