/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.dataimport.server.handler;

import com.inet.field.Field;
import com.inet.helpdesk.config.FieldMappingEntry;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.model.dataimport.ConnectionEntry;
import com.inet.helpdesk.core.model.dataimport.DataImportSchedule;
import com.inet.helpdesk.plugins.dataimport.HelpDeskDataImportPlugin;
import com.inet.helpdesk.plugins.dataimport.server.data.DataImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.data.UserImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.handler.FieldDescription;
import com.inet.helpdesk.usersandgroups.HDFieldLocator;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;

public abstract class AbstractDataImportHandler<INPUT, OUTPUT>
extends ServiceMethod<INPUT, OUTPUT> {
    private HttpServletRequest request;

    public short getMethodType() {
        return 1;
    }

    public OUTPUT invoke(HttpServletRequest req, HttpServletResponse res, INPUT data) throws IOException {
        this.request = req;
        DataImportConnector importConnector = (DataImportConnector)ServerPluginManager.getInstance().getSingleInstance(DataImportConnector.class);
        try {
            return this.invoke(importConnector, data);
        }
        catch (ServerDataException e) {
            HelpDeskDataImportPlugin.LOGGER.error((Throwable)e);
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            throw new ClientMessageException(t.getMessage());
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public abstract OUTPUT invoke(DataImportConnector var1, INPUT var2) throws IOException, ServerDataException;

    protected UserImportConfigInfo convertUserImport(UserImportEntry data) {
        UserImportConfigInfo uici = new UserImportConfigInfo();
        String id = data.getId();
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        uici.setUid(id);
        ConnectionEntry connection = data.getConnection();
        if (connection != null && !connection.getName().isEmpty()) {
            uici.setConnectionName(connection.getName());
            uici.setLdap(connection.getConnectionType() == DataImportConnector.ConnectionType.ldap);
        }
        uici.setLoeschen(data.isDeletePermission());
        uici.setSupporterLoeschen(data.isDeleteSupporterPermission());
        uici.setReaktivieren(data.isRestorePermission());
        uici.setAlle(data.isCreatePermission());
        uici.setTable(data.getTable());
        uici.setUseHideFromAddresslists(data.useHideFromAddresslists());
        uici.setUseUserSyntax(data.isLdapUserSearch());
        uici.setUserSyntax(data.getLdapUserSearch());
        uici.setSupervisorColumn(data.getSupervisorColumn());
        uici.setPictureImport(data.isPictureImport());
        ArrayList<DataImportEntry.MappingEntry> mapping = data.getMapping();
        ArrayList<FieldMappingEntry> importFieldMapping = new ArrayList<FieldMappingEntry>();
        if (mapping != null) {
            for (DataImportEntry.MappingEntry mEntry : mapping) {
                importFieldMapping.add(new FieldMappingEntry(mEntry.getDefinedColumn().getKey(), mEntry.getUserColumn()));
            }
        }
        uici.setFieldMapping(importFieldMapping);
        uici.setName(data.getName());
        uici.setSchedule(data.getSchedule());
        return uici;
    }

    protected UserImportEntry convertToJsonModel(String name, UserImportConfigInfo uici) {
        UserImportEntry userImportEntry = new UserImportEntry(name);
        if (uici.getConnectionName() != null && !uici.getConnectionName().isEmpty()) {
            DataImportConnector.ConnectionType type = uici.isLdap() ? DataImportConnector.ConnectionType.ldap : DataImportConnector.ConnectionType.database;
            userImportEntry.setConnection(new ConnectionEntry(type, uici.getConnectionName()));
        }
        userImportEntry.setId(uici.getUid());
        userImportEntry.setCreatePermission(uici.isAlle());
        userImportEntry.setDeletePermission(uici.isLoeschen());
        userImportEntry.setDeleteSupporterPermission(uici.isSupporterLoeschen());
        ArrayList<DataImportEntry.MappingEntry> mapping = new ArrayList<DataImportEntry.MappingEntry>();
        for (FieldMappingEntry field : uici.getFieldMapping()) {
            mapping.add(this.getDisplayNameForUserField(field));
        }
        userImportEntry.setMapping(mapping);
        userImportEntry.setRestorePermission(uici.isReaktivieren());
        userImportEntry.setSchedule(uici.getSchedule());
        userImportEntry.setTable(uici.isLdap() ? "organizationalPerson" : uici.getTable());
        userImportEntry.setHideFromAddresslists(uici.isUseHideFromAddresslists());
        userImportEntry.setLdapUserSearch(uici.isUseUserSyntax());
        userImportEntry.setLdapUserSearch(uici.getUserSyntax());
        userImportEntry.setSupervisorColumn(uici.getSupervisorColumn());
        userImportEntry.setPictureImport(uici.isPictureImport());
        return userImportEntry;
    }

    private DataImportEntry.MappingEntry getDisplayNameForUserField(FieldMappingEntry fe) {
        com.inet.helpdesk.shared.model.Field valueOfKey;
        FieldDescription lk = new FieldDescription(fe.getDefininitionColumn(), "UNKNOWN");
        if ("SecondUsername".equals(fe.getDefininitionColumn())) {
            lk = new FieldDescription(fe.getDefininitionColumn(), "de".equals(ClientLocale.getThreadLocale().getLanguage()) ? "Alternatives Login" : "Alternative login");
        }
        if ((valueOfKey = com.inet.helpdesk.shared.model.Field.valueOfKey((String)fe.getDefininitionColumn(), (String)"USERDATA")) != null) {
            Field apiField = HDFieldLocator.getFieldForOldDbField((com.inet.helpdesk.shared.model.Field)valueOfKey);
            lk = apiField != null ? new FieldDescription(fe.getDefininitionColumn(), apiField.getLabel()) : new FieldDescription(fe.getDefininitionColumn(), fe.getDefininitionColumn());
        }
        return new DataImportEntry.MappingEntry(lk, fe.getSelectedColumn());
    }

    protected boolean hasInvalidSchedule(DataImportSchedule schedule) {
        if ((schedule.getMainOption() == DataImportSchedule.MainTimeOption.HALFHOUR || schedule.getMainOption() == DataImportSchedule.MainTimeOption.HOURLY) && schedule.getStartHour() != 0 && schedule.getEndHour() != 0) {
            return schedule.getStartHour() == schedule.getEndHour();
        }
        return false;
    }
}

