/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.dataimport.server.handler;

import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.model.dataimport.ConnectionEntry;
import com.inet.helpdesk.plugins.dataimport.server.data.DataImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.data.DeviceImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.data.DeviceType;
import com.inet.helpdesk.plugins.dataimport.server.handler.FieldDescription;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.http.ClientMessageException;
import com.inet.plugin.DynamicExtensionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DeviceImportHelper {
    protected static DeviceImportEntry convertToJsonModel(String name, DeviceImportConfigInfo dici) {
        Map<Integer, List<FieldDescription>> deviceFieldsByTypeId;
        List<FieldDescription> list;
        DeviceImportEntry deviceImportEntry = new DeviceImportEntry(name);
        deviceImportEntry.setId(dici.getUid());
        if (dici.getConnectionName() != null && !dici.getConnectionName().isEmpty()) {
            DataImportConnector.ConnectionType type = dici.isLdap() ? DataImportConnector.ConnectionType.ldap : DataImportConnector.ConnectionType.database;
            deviceImportEntry.setConnection(new ConnectionEntry(type, dici.getConnectionName()));
        }
        deviceImportEntry.setSchedule(dici.getSchedule());
        deviceImportEntry.setDeletePermission(dici.isDelete());
        AssetTypeVO assetType = (AssetTypeVO)AssetTypeManager.getInstance().get(dici.getGerTyp());
        if (assetType != null) {
            deviceImportEntry.setDeviceType(new DeviceType(dici.getGerTyp(), assetType.getDisplayValue(), assetType.getSymbol()));
        }
        deviceImportEntry.setTable(dici.getImportSource());
        deviceImportEntry.setUniqueKey(dici.getUniqueIdent());
        deviceImportEntry.setTableRef(dici.isIndirekt());
        deviceImportEntry.setIgnoreUser(dici.isIgnoreUser());
        deviceImportEntry.setUsername(dici.getSelektionUserMain());
        deviceImportEntry.setRefTable(dici.getIndirectUserReferenceObject());
        deviceImportEntry.setRefAttr(dici.getIndirectUserKeyReference());
        deviceImportEntry.setUserAttr(dici.getIndirectUsernameReference());
        Map userSelectedMapping = dici.getUserSelectedMapping();
        ArrayList<DataImportEntry.MappingEntry> mapping = new ArrayList<DataImportEntry.MappingEntry>();
        if (userSelectedMapping != null && (list = (deviceFieldsByTypeId = DeviceImportHelper.getDeviceFieldsByTypeId()).get(dici.getGerTyp())) != null) {
            for (FieldDescription field : list) {
                String fieldKey = field.getKey();
                String userColumn = null;
                userColumn = (String)userSelectedMapping.get(fieldKey);
                mapping.add(new DataImportEntry.MappingEntry(new FieldDescription(fieldKey, field.getDisplayName(), field.getType(), field.isMandatory()), userColumn == null ? "" : userColumn));
            }
        }
        deviceImportEntry.setMapping(mapping);
        return deviceImportEntry;
    }

    protected static DeviceImportConfigInfo convertDeviceImport(DeviceImportEntry data) throws ClientMessageException {
        DeviceImportConfigInfo dici = new DeviceImportConfigInfo();
        ConnectionEntry connection = data.getConnection();
        String id = data.getId();
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        dici.setUid(id);
        if (connection != null && !connection.getName().isEmpty()) {
            dici.setConnectionName(connection.getName());
            dici.setLdap(connection.getConnectionType() == DataImportConnector.ConnectionType.ldap);
        }
        dici.setDelete(data.isDeletePermission());
        DeviceType deviceType = data.getDeviceType();
        if (deviceType != null) {
            dici.setGerTyp(deviceType.getGerTypeId());
        }
        dici.setImportSource(data.getTable());
        dici.setIndirectUserKeyReference(data.getRefAttr());
        dici.setIndirectUsernameReference(data.getUserAttr());
        dici.setIndirectUserReferenceObject(data.getRefTable());
        dici.setIndirekt(data.isTableRef());
        dici.setIgnoreUser(data.isIgnoreUser());
        dici.setSchedule(data.getSchedule());
        HashMap<String, String> selectionColumnsMap = new HashMap<String, String>();
        ArrayList<DataImportEntry.MappingEntry> mapping = data.getMapping();
        if (mapping != null) {
            for (DataImportEntry.MappingEntry mEntry : mapping) {
                selectionColumnsMap.put(mEntry.getDefinedColumn().getKey(), mEntry.getUserColumn() == null ? "" : mEntry.getUserColumn());
            }
        }
        dici.setUserSelectedMapping(selectionColumnsMap);
        dici.setSelektionUserMain(data.getUsername());
        dici.setUniqueIdent(data.getUniqueKey());
        return dici;
    }

    static Map<Integer, List<FieldDescription>> getDeviceFieldsByTypeId() {
        List types = AssetTypeManager.getInstance().getAll(true);
        HashMap<Integer, List<FieldDescription>> deviceFieldsMapping = new HashMap<Integer, List<FieldDescription>>();
        List<AssetFieldDefinition> deviceFields = DeviceImportHelper.getDeviceFieldDefinitions();
        deviceFields.removeIf(d -> d.getFieldKey().equalsIgnoreCase("type") || d.getFieldKey().equalsIgnoreCase("parent") || d.getFieldKey().equalsIgnoreCase("owner") || d.getFieldKey().equalsIgnoreCase("license"));
        for (AssetFieldDefinition fieldDefinition : deviceFields) {
            if (!(fieldDefinition instanceof AssetFieldWithDefinition)) continue;
            AssetFieldWithDefinition fieldWithDefinition = (AssetFieldWithDefinition)fieldDefinition;
            types.forEach(type -> {
                if (fieldDefinition.isVisibleInType(type.getId())) {
                    String displayType = fieldWithDefinition.getDisplayType().toString();
                    FieldDescription deviceFieldDescription = new FieldDescription(fieldWithDefinition.getKey(), fieldWithDefinition.getLabel(), displayType.toLowerCase(), fieldWithDefinition.isMandatory());
                    deviceFieldsMapping.computeIfAbsent(type.getId(), ArrayList::new).add(deviceFieldDescription);
                }
            });
        }
        return deviceFieldsMapping;
    }

    static List<AssetFieldDefinition> getDeviceFieldDefinitions() {
        List deviceFields = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class);
        deviceFields.sort((a, b) -> {
            int compare = Integer.compare(a.getPriority(), b.getPriority());
            if (compare == 0) {
                compare = String.CASE_INSENSITIVE_ORDER.compare(a.getLabel(), b.getLabel());
            }
            return compare;
        });
        return deviceFields;
    }
}

