/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.search;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkMessage;
import com.inet.cowork.api.model.a;
import com.inet.cowork.server.webapi.search.SearchRequestData;
import com.inet.id.GUID;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@JsonData
@Schema(description="List of messages matching the search query")
@ArraySchema(schema=@Schema(implementation=Entry.class))
public class SearchResponseData
extends ArrayList<Entry> {
    public static SearchResponseData from(List<a> coWorkMessages, SearchRequestData.a searchRequestFormat) {
        SearchResponseData searchResponseData = new SearchResponseData();
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        searchResponseData.addAll(coWorkMessages.stream().map(srm -> {
            CoWorkChannel coWorkChannel = coWorkManager.getChannel(srm.getChannelId());
            if (coWorkChannel == null) {
                return null;
            }
            CoWorkMessage coWorkMessage = coWorkManager.getMessage(srm.getChannelId(), srm.getMessageId());
            if (coWorkMessage == null) {
                return null;
            }
            Entry entry = new Entry();
            entry.messageId = srm.getMessageId();
            entry.teamId = coWorkChannel.getTeamId();
            entry.channelId = srm.getChannelId();
            entry.userId = coWorkMessage.getUserId();
            switch (searchRequestFormat) {
                case bC: {
                    entry.text = coWorkMessage.getText();
                    break;
                }
                case bD: {
                    entry.text = coWorkMessage.getPlainText();
                    break;
                }
                case bE: {
                    entry.text = coWorkMessage.getFormattedText();
                    break;
                }
            }
            return entry;
        }).filter(m2 -> m2 != null).collect(Collectors.toList()));
        return searchResponseData;
    }

    @JsonData
    @Schema(description="A single message entry in the search results")
    protected static class Entry {
        @Schema(description="Unique identifier of the message")
        public GUID messageId;
        @Schema(description="Unique identifier of the team containing the message")
        public GUID teamId;
        @Schema(description="Unique identifier of the channel containing the message")
        public GUID channelId;
        @Schema(description="Unique identifier of the message author")
        public GUID userId;
        @JsonExcludeNull
        @Schema(description="Message content in the requested format (original, plain, or HTML)", nullable=true)
        public String text;

        private Entry() {
        }
    }
}

