/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.messages;

import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkMessage;
import com.inet.cowork.api.webapi.CoWorkWebAPIUtils;
import com.inet.cowork.server.webapi.messages.CreateMessageRequestData;
import com.inet.cowork.server.webapi.messages.MessageResponseData;
import com.inet.cowork.server.webapi.reactions.a;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.plugin.webapi.api.handler.RequestHandlerWithGUIDPathToken;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nullable;

@Tag(name="Messages", description="Message operations within channels")
public class b
extends RequestHandlerWithGUIDPathToken<CreateMessageRequestData, MessageResponseData> {
    public b() {
        super(new String[]{"message"});
        this.registerRequestHandler((RequestHandlerBase)new com.inet.cowork.server.webapi.attachments.b());
        this.registerRequestHandler((RequestHandlerBase)new a());
    }

    public String getHelpPageKey() {
        return "webapi.cowork.teams.channels.messages.id";
    }

    @Operation(summary="Get, update or delete a message", description="Retrieves, updates or deletes a specific message. Can return the message text in HTML format using the 'format=html' parameter.", responses={@ApiResponse(responseCode="200", description="Message retrieved or updated successfully", content={@Content(schema=@Schema(implementation=MessageResponseData.class))}), @ApiResponse(responseCode="204", description="Message deleted successfully"), @ApiResponse(responseCode="400", description="Invalid message data or empty update text"), @ApiResponse(responseCode="403", description="User not authorized to update/delete message"), @ApiResponse(responseCode="404", description="Message or channel not found")})
    public MessageResponseData b(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable CreateMessageRequestData createMessageRequestData, @Nullable GUID gUID, boolean bl) throws IOException {
        if (gUID == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse, (String)"Message ID is missing.");
            return null;
        }
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        GUID gUID2 = CoWorkWebAPIUtils.getGUIDFromPathInfo(httpServletRequest, "channels");
        CoWorkChannel coWorkChannel = CoWorkWebAPIUtils.checkAndGetChannelIfIsValid(httpServletRequest, httpServletResponse, gUID2);
        if (coWorkChannel == null) {
            return null;
        }
        CoWorkMessage coWorkMessage = coWorkManager.getMessage(coWorkChannel.getId(), gUID);
        if (coWorkMessage == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse, (String)"Message could not be found.");
            return null;
        }
        if ("DELETE".equalsIgnoreCase(httpServletRequest.getMethod())) {
            boolean bl2;
            boolean bl3 = coWorkManager.getTeam(coWorkChannel.getTeamId()).isAdmin();
            GUID gUID3 = UserManager.getInstance().getCurrentUserAccountID();
            boolean bl4 = bl2 = gUID3 != null && gUID3.equals((Object)coWorkMessage.getUserId());
            if (!bl2) {
                boolean bl5;
                boolean bl6 = coWorkManager.isMemberOfChannel(gUID2, gUID3);
                boolean bl7 = bl5 = bl3 && bl6;
                if (!bl5) {
                    ResponseWriter.forbidden((HttpServletResponse)httpServletResponse, (String)"User is not owner of message and does not have admin priviledges for the message.");
                    return null;
                }
            }
            if (!bl) {
                coWorkManager.deleteMessage(gUID2, gUID);
            }
            httpServletResponse.setStatus(204);
            return null;
        }
        String string = httpServletRequest.getParameter("format");
        boolean bl8 = string != null && string.equalsIgnoreCase("html");
        CoWorkMessage coWorkMessage2 = this.a(httpServletRequest, httpServletResponse, coWorkChannel, coWorkMessage, createMessageRequestData, bl);
        if (coWorkMessage2 != null) {
            return MessageResponseData.from(coWorkMessage2, coWorkChannel, bl8);
        }
        if (this.isMethodAllowedForData(httpServletRequest)) {
            throw new ClientMessageException("A Message was expected but not given.");
        }
        return MessageResponseData.from(coWorkMessage, coWorkChannel, bl8);
    }

    private CoWorkMessage a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, CoWorkChannel coWorkChannel, CoWorkMessage coWorkMessage, CreateMessageRequestData createMessageRequestData, boolean bl) {
        if (createMessageRequestData == null) {
            return null;
        }
        GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        if (gUID == null || !gUID.equals((Object)coWorkMessage.getUserId())) {
            ResponseWriter.forbidden((HttpServletResponse)httpServletResponse, (String)"Only the owner can update the message text.");
            return null;
        }
        if (createMessageRequestData.getAttachments() != null && createMessageRequestData.getAttachments().size() > 0) {
            throw new ClientMessageException("Attachments are not allowed when updateing a message");
        }
        if (StringFunctions.isEmpty((String)createMessageRequestData.getText())) {
            throw new ClientMessageException("A non-empty text has to be set when updating a message");
        }
        if (bl) {
            return new CoWorkMessage(coWorkMessage.getId(), coWorkMessage.getUserId(), coWorkMessage.getParentId(), createMessageRequestData.getText(), coWorkMessage.getCreated(), coWorkMessage.getAttachmentsIds(), coWorkMessage.getReactions());
        }
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        coWorkManager.updateMessage(coWorkChannel.getId(), coWorkMessage.getId(), createMessageRequestData.getText());
        return coWorkManager.getMessage(coWorkChannel.getId(), coWorkMessage.getId());
    }

    @Operation(summary="Get, update or delete a message", description="Retrieves, updates or deletes a specific message. Can return the message text in HTML format using the 'format=html' parameter.", responses={@ApiResponse(responseCode="200", description="Message retrieved or updated successfully", content={@Content(schema=@Schema(implementation=MessageResponseData.class))}), @ApiResponse(responseCode="204", description="Message deleted successfully"), @ApiResponse(responseCode="400", description="Invalid message data or empty update text"), @ApiResponse(responseCode="403", description="User not authorized to update/delete message"), @ApiResponse(responseCode="404", description="Message or channel not found")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, boolean bl) throws IOException {
        return this.b(httpServletRequest, httpServletResponse, (CreateMessageRequestData)object, (GUID)object2, bl);
    }
}

