/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.channels;

import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.cowork.server.webapi.channels.ChannelCreateRequestData;
import com.inet.cowork.server.webapi.channels.ChannelListResponseData;
import com.inet.cowork.server.webapi.channels.c;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

@Tag(name="Channels", description="Channel management operations within teams")
public class d
extends RequestHandler.WithParentPathToken<ChannelCreateRequestData, ChannelListResponseData, GUID> {
    public d() {
        super(new String[]{"channels"});
        this.setGenericRequestHandler((RequestHandler)new c());
    }

    public d(String ... stringArray) {
        super(stringArray);
    }

    public String getHelpPageKey() {
        return "webapi.cowork.teams.channels";
    }

    @Operation(summary="List team channels", description="Returns a list of channels in a team that the current user has access to based on permissions", responses={@ApiResponse(responseCode="200", description="List of channels retrieved successfully", content={@Content(schema=@Schema(implementation=ChannelListResponseData.class))}), @ApiResponse(responseCode="403", description="Channel creation attempted without admin context"), @ApiResponse(responseCode="404", description="Team not found or not available for the user")})
    public ChannelListResponseData b(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable ChannelCreateRequestData channelCreateRequestData, @Nullable GUID gUID, List<String> list, boolean bl) throws IOException {
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        CoWorkTeam coWorkTeam = coWorkManager.getTeam(gUID);
        if (coWorkTeam == null) {
            throw new ClientMessageException("Team could not be not found or is not available for the user.");
        }
        if (this.isMethodAllowedForData(httpServletRequest) && channelCreateRequestData != null) {
            ResponseWriter.forbidden((HttpServletResponse)httpServletResponse, (String)"Channel creation attempted, but admin context not requested.");
            return null;
        }
        List<CoWorkChannel> list2 = coWorkManager.getChannels(gUID);
        return ChannelListResponseData.from(list2, false);
    }

    @Operation(summary="List team channels", description="Returns a list of channels in a team that the current user has access to based on permissions", responses={@ApiResponse(responseCode="200", description="List of channels retrieved successfully", content={@Content(schema=@Schema(implementation=ChannelListResponseData.class))}), @ApiResponse(responseCode="403", description="Channel creation attempted without admin context"), @ApiResponse(responseCode="404", description="Team not found or not available for the user")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, List list, boolean bl) throws IOException {
        return this.b(httpServletRequest, httpServletResponse, (ChannelCreateRequestData)object, (GUID)object2, list, bl);
    }
}

