/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.search;

import com.inet.cowork.api.CoWorkI18n;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.cowork.server.d;
import com.inet.cowork.server.search.b;
import com.inet.cowork.server.search.c;
import com.inet.cowork.server.search.f;
import com.inet.cowork.server.search.i;
import com.inet.cowork.server.search.j;
import com.inet.error.ErrorCode;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.FastStringReader;
import com.inet.lib.util.StringFunctions;
import com.inet.search.SearchDataCache;
import com.inet.search.SearchDataCacheChangeListener;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.SuggestedValue;
import com.inet.search.SuggestedValuesFilter;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.JoinTokenMatcher;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.IdType;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.tokenizers.CollectionSearchTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.search.tokenizers.TextSearchTokenizer;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class e {
    private static e bg;
    @Nonnull
    private final IndexSearchEngine<GUID> bh = new IndexSearchEngine("coworkmessage", null, true, new IdType(GUID.class, 'S'), false);
    @Nonnull
    private final IndexSearchEngine<GUID> be = new IndexSearchEngine<GUID>("coworkchannel", null, true, GUID.class){

        public void reIndex() throws IOException {
            super.reIndex();
            e.this.bh.reIndexAsync();
        }
    };
    @Nonnull
    private final c bi = new c();
    @Nonnull
    private final f bj = new f(this.be, this.bi);
    @Nonnull
    private final SearchTag bk;
    @Nonnull
    private final SearchTag bl;
    private ConcurrentHashMap<String, String> bm;

    private e() {
        try {
            this.bk = new SearchTag("msgid", 0);
            this.be.addTag(this.bk);
            this.be.setData((SearchDataCache)this.bi);
            this.be.setPrimaryTag(this.bk);
            CollectionSearchTokenizer collectionSearchTokenizer = new CollectionSearchTokenizer(){

                @Nonnull
                public Set<String> tokens(@Nullable Object value, int type) {
                    if (type == 1) {
                        return TextSearchTokenizer.DEFAULT.tokens(value, type);
                    }
                    return super.tokens(value, type);
                }
            };
            this.bh.addTag(new SearchTag("text", (SearchTokenizer)collectionSearchTokenizer, 1000, () -> CoWorkI18n.MSG_SERVER.getMsg("search.text", new Object[0])));
            SearchTag searchTag = new SearchTag("time", SearchDataType.Date, false, 0, () -> CoWorkI18n.MSG_SERVER.getMsg("search.time", new Object[0]));
            this.bh.addTag(searchTag);
            this.bh.addTag(new SearchTag("attachment", (SearchTokenizer)collectionSearchTokenizer, 0, () -> CoWorkI18n.MSG_SERVER.getMsg("search.attachment", new Object[0])));
            this.bl = new SearchTag("mention", SearchDataType.StringMap, false, (SearchTokenizer)collectionSearchTokenizer, 0, () -> CoWorkI18n.MSG_SERVER.getMsg("search.mention", new Object[0]), true){

                @Nonnull
                public Map<? extends Comparable<?>, String> getMapData() {
                    ConcurrentHashMap<String, String> concurrentHashMap = e.this.bm;
                    if (concurrentHashMap == null) {
                        e.this.bm = concurrentHashMap = e.this.B();
                    }
                    return concurrentHashMap;
                }
            };
            this.bh.addTag(this.bl);
            SearchTag searchTag2 = new SearchTag("from", 0);
            this.bh.addTag(searchTag2);
            this.bh.addTag(new SearchTag("parent", 0));
            IndexSearchEngine indexSearchEngine = UserManager.getInstance().getSearchEngine();
            this.bh.addTokenMatcher((TokenMatcher)new JoinTokenMatcher<GUID>(this.bh, searchTag2, indexSearchEngine, indexSearchEngine.getTag("useraccountdisplayname"), false){

                public String getDisplayName() {
                    return CoWorkI18n.MSG_SERVER.getMsg("search.from", new Object[0]);
                }

                public boolean useTwoStage() {
                    return false;
                }
            });
            this.bh.addTokenMatcher((TokenMatcher)new b(this.be));
            this.bh.addTokenMatcher((TokenMatcher)new i(this.be));
            this.bh.setData((SearchDataCache)this.bj, 4);
            this.bh.setPrimaryTag(searchTag);
        }
        catch (IOException iOException) {
            CoWorkManager.LOGGER.error((Throwable)iOException);
            throw (RuntimeException)ErrorCode.throwAny((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static e v() {
        e e2 = bg;
        if (e2 != null) return e2;
        Class<e> clazz = e.class;
        synchronized (e.class) {
            e2 = bg;
            if (e2 != null) return e2;
            bg = new e();
            return bg;
        }
    }

    @Nonnull
    public IndexSearchEngine<GUID> w() {
        return this.bh;
    }

    @Nonnull
    public List<SuggestedValue> a(String string, final int n2) {
        final com.inet.cowork.server.search.a a2 = new com.inet.cowork.server.search.a(this.be, e.x());
        return this.bh.getSuggestedValues(string, (SuggestedValuesFilter)new SuggestedValuesFilter<GUID>(){

            public int getMaxValues() {
                return n2;
            }

            @Nonnull
            public Predicate<GUID> getCondition() {
                return a2;
            }
        });
    }

    @Nonnull
    public Set<com.inet.cowork.api.model.a> b(String string, int n2) {
        SearchCommand searchCommand = new TextSearchCommandBuilder(this.bh, string).build();
        searchCommand.setResultLimit(n2);
        searchCommand.addFilter((Predicate)new com.inet.cowork.server.search.a(this.be, e.x()));
        return this.a(searchCommand);
    }

    @Nonnull
    public Set<GUID> a(@Nonnull GUID gUID, @Nonnull GUID gUID2, long l2, int n2) {
        OrSearchExpression orSearchExpression;
        AndSearchExpression andSearchExpression = new AndSearchExpression();
        andSearchExpression.add((SearchExpression)new SearchCondition("time", SearchCondition.SearchTermOperator.GT, (Object)l2));
        CoWorkChannel coWorkChannel = CoWorkManager.getInstance().getChannel(gUID);
        if (coWorkChannel == null || !CoWorkManager.DIRECTMESSAGE_TEAM_ID.equals((Object)coWorkChannel.getTeamId())) {
            orSearchExpression = new OrSearchExpression();
            orSearchExpression.add((Object)new SearchCondition("mention", SearchCondition.SearchTermOperator.Equals, (Object)"@channel:all"));
            orSearchExpression.add((Object)new SearchCondition("mention", SearchCondition.SearchTermOperator.Equals, (Object)"@channel:online"));
            orSearchExpression.add((Object)new SearchCondition("mention", SearchCondition.SearchTermOperator.Equals, (Object)("@user:" + gUID2.toString())));
            Set set = UserGroupManager.getInstance().getGroupsForUser(gUID2);
            for (UserGroupInfo userGroupInfo : set) {
                orSearchExpression.add((Object)new SearchCondition("mention", SearchCondition.SearchTermOperator.Equals, (Object)("@group:" + userGroupInfo.getID().toString())));
            }
            andSearchExpression.add((SearchExpression)orSearchExpression);
        }
        orSearchExpression = new SearchCommand(new SearchExpression[]{andSearchExpression});
        orSearchExpression.setResultLimit(n2);
        orSearchExpression.addFilter((Predicate)new com.inet.cowork.server.search.a(this.be, Set.of(gUID)));
        return this.bh.simpleSearch((SearchCommand)orSearchExpression);
    }

    @Nonnull
    public Set<GUID> J(@Nonnull GUID gUID) {
        return this.bh.simpleSearch(new SearchCommand("parent", SearchCondition.SearchTermOperator.Equals, (Object)gUID));
    }

    @Nonnull
    Set<com.inet.cowork.api.model.a> a(SearchCommand searchCommand) {
        LinkedHashSet<com.inet.cowork.api.model.a> linkedHashSet = new LinkedHashSet<com.inet.cowork.api.model.a>();
        a a2 = new a();
        SearchCommand searchCommand2 = new SearchCommand(new SearchExpression[]{a2});
        Set set = this.bh.simpleSearch(searchCommand);
        for (GUID gUID : set) {
            a2.M(gUID);
            Set set2 = this.be.simpleSearch(searchCommand2);
            linkedHashSet.add(new com.inet.cowork.api.model.a((GUID)set2.iterator().next(), gUID));
        }
        return linkedHashSet;
    }

    @Nonnull
    private static Set<GUID> x() {
        HashSet<GUID> hashSet = new HashSet<GUID>();
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        for (CoWorkTeam coWorkTeam : coWorkManager.getTeams()) {
            if (!coWorkTeam.isAvailable()) continue;
            for (CoWorkChannel coWorkChannel : coWorkManager.getChannels(coWorkTeam.getId())) {
                hashSet.add(coWorkChannel.getId());
            }
        }
        return hashSet;
    }

    @Nonnull
    c y() {
        return this.bi;
    }

    @Nonnull
    f z() {
        return this.bj;
    }

    public void A() throws ClientMessageException {
        CoWorkManager.getInstance().cleanUpMembers();
        try {
            if (!this.bh.isReindexRunning()) {
                this.be.reIndex();
            }
        }
        catch (IOException iOException) {
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)iOException));
        }
    }

    @Nonnull
    private ConcurrentHashMap<String, String> B() {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        e.a(concurrentHashMap, this.bh.createValuesIterator(this.bl, true));
        return concurrentHashMap;
    }

    void a(@Nonnull j j2) {
        Set set;
        ConcurrentHashMap<String, String> concurrentHashMap = this.bm;
        if (concurrentHashMap != null && (set = (Set)j2.get("mention")) != null) {
            e.a(concurrentHashMap, set.iterator());
        }
    }

    private static void a(@Nonnull ConcurrentHashMap<String, String> concurrentHashMap, @Nonnull Iterator<String> iterator) {
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            concurrentHashMap.computeIfAbsent(string2, string -> {
                FastStringReader fastStringReader = new FastStringReader(string);
                String[] stringArray = new String[1];
                d.T.read(fastStringReader.read(), fastStringReader, markDownToken -> {
                    stringArray[0] = markDownToken.toString();
                }, false);
                return stringArray[0];
            });
        }
    }

    public void K(@Nonnull GUID gUID) {
        ForkJoinPool.commonPool().execute(() -> {
            Iterator iterator = this.be.createEntryIterator(this.bk, true);
            while (iterator.hasNext()) {
                SearchDataCacheChangeListener<GUID>[] searchDataCacheChangeListenerArray = (SearchDataCacheChangeListener<GUID>[])iterator.next();
                if (!((Set)searchDataCacheChangeListenerArray.getValue()).contains(gUID)) continue;
                @Nonnull GUID gUID2 = GUID.valueOf((String)((String)searchDataCacheChangeListenerArray.getKey()));
                for (SearchDataCacheChangeListener<GUID> searchDataCacheChangeListener : this.bj.getListeners()) {
                    searchDataCacheChangeListener.entryRemovedCompletely((Object)gUID2);
                }
            }
            for (SearchDataCacheChangeListener<GUID> searchDataCacheChangeListener : this.bi.getListeners()) {
                searchDataCacheChangeListener.entryRemovedCompletely((Object)gUID);
            }
        });
    }

    private static class a
    extends SearchCondition {
        private GUID id;

        a() {
            super("msgid", SearchCondition.SearchTermOperator.Equals, null);
        }

        void M(GUID gUID) {
            this.id = gUID;
        }

        @Nullable
        public Object getRightOperand() {
            return this.id;
        }
    }
}

